//
//  FallDetect.swift
//  Orbis
//
//  Created by KALSI on 6/26/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import CoreMotion
import MessageUI



class FallDetect: UIViewController, UIPickerViewDataSource, UIPickerViewDelegate ,MFMessageComposeViewControllerDelegate {

    @IBOutlet weak var senstivityPicker: UIPickerView!
    @IBOutlet weak var picker: UIPickerView!
    @IBOutlet weak var NoMovementView: UIView!
    @IBOutlet weak var senstivityView: UIView!
    
    @IBOutlet weak var senseLabel: UILabel!
    @IBOutlet weak var dropArrow: UIImageView!
    @IBOutlet weak var movementBtn: UIButton!
    @IBOutlet weak var senseBtn: UIButton!
    
    @IBOutlet weak var fallDetectLabel: UILabel!
    
    @IBOutlet weak var noMoveLabel: UILabel!
    
    var minutes = NSMutableArray()
    var seconds = NSMutableArray()
    var currentMinutes = Int()
    var currentSeconds = Int()
    var TotalSeconds = Int()

    var motion: CMMotionManager!
    var initialAttitude : CMAttitude!
    
    var oldMagnitude : Float = 0.0

    var  senstivityValue : Float = 1
    var x : Float = 0
    var y : Float = 0
    var z : Float = 0

    //MARK:-
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(true)
        
//        if UserDefaults.standard.bool(forKey: "FallDetect"){
//            senstivityView.alpha = 1
//            senstivityView.isUserInteractionEnabled = true
//            senseBtn.isSelected = true
//            fallDetectLabel.text = "Fall detect - ON"
//
//        }else{
//            senstivityView.alpha = 0.5
//            senstivityView.isUserInteractionEnabled = false
//            senseBtn.isSelected = false
//            senstivityPicker.selectRow(Int(senstivityValue), inComponent: 0, animated: false)
//            fallDetectLabel.text = "Fall detect - OFF"
//
//        }
//        
//        if UserDefaults.standard.bool(forKey: "NoMovementToggle"){
//            movementBtn.isSelected = true
//            
//            NoMovementView.alpha = 0.5
//            NoMovementView.isUserInteractionEnabled = false
//            noMoveLabel.text = "No movement - ON"
//
//            
//            }else{
//            movementBtn.isSelected = false
//            NoMovementView.alpha = 1
//            NoMovementView.isUserInteractionEnabled = true
//            if currentMinutes <= 5 {
//                picker.selectRow(5, inComponent: 0, animated: false)
//                currentMinutes = 5
//                
//            }
//
//            noMoveLabel.text = "No movement - OFF"
//
//            
//            }
        
        if appDelegate.movescheduler.isValid{
            movementBtn.isSelected = true
            
            NoMovementView.alpha = 0.5
            NoMovementView.isUserInteractionEnabled = false
            noMoveLabel.text = "No movement - ON"
 
            
        }else{
            movementBtn.isSelected = false
            NoMovementView.alpha = 1
            NoMovementView.isUserInteractionEnabled = true
            if currentMinutes <= 5 {
                picker.selectRow(5, inComponent: 0, animated: false)
                currentMinutes = 5
                
            }
            
            noMoveLabel.text = "No movement - OFF"
            
        }
        
        if appDelegate.fallscheduler.isValid{
            self.setFallDetectOnProps()
            
        }else{
            senstivityView.alpha = 0.5
            senstivityView.isUserInteractionEnabled = false
            senseBtn.isSelected = false
            senstivityPicker.selectRow(Int(senstivityValue), inComponent: 0, animated: false)
            fallDetectLabel.text = "Fall detect - OFF"
            
}
        
        if AppConfiguration.sharedInstance.isFallDetectOn == 1{
            
            self.setFallDetectOnProps()
            self.getFallDetect()
        }

        if AppConfiguration.sharedInstance.userinteractionEnabled == 0{
            
          senseBtn.isUserInteractionEnabled = false
        senstivityPicker.isUserInteractionEnabled = false
        }else{
            
            senseBtn.isUserInteractionEnabled = true
            senstivityPicker.isUserInteractionEnabled = true

        }
        

    }
    func setFallDetectOnProps() {
        senstivityView.alpha = 1
        senstivityView.isUserInteractionEnabled = true
        senseBtn.isSelected = true
        fallDetectLabel.text = "Fall detect - ON"
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        //Genrating minutes & seconds
        var mins = 0
        while mins < 60 {
            minutes.add("\(mins)")
            if mins != 0{
                seconds.add("\(mins)")
            }
            mins += 1
        }
        seconds.add("60")
        picker.reloadAllComponents()
        
        
        if (UserDefaults.standard.integer(forKey: "fallSenstivity") != 0)
        {
        let selectedSensVal = UserDefaults.standard.integer(forKey: "fallSenstivity")
        senstivityValue = Float(selectedSensVal)
            senseLabel.text = "\(selectedSensVal)"
        senstivityPicker.selectRow((UserDefaults.standard.integer(forKey: "fallSenstivity")-1), inComponent: 0, animated: false)
        }
        
        if appDelegate.isMovementTimer{
       self.displayTime()
        
        }
        
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        senstivityPicker.isHidden = true
        
        currentMinutes = 0
        currentSeconds = 1
        
        motion = CMMotionManager()
        motion.startAccelerometerUpdates()
        
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    //MARK:-
    func UnitLabel( text : String) -> UILabel {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: picker.frame.size.width / 2, height: 40))
        label.textAlignment = .center
        label.textColor = UIColor.white
        label.attributedText = NSAttributedString(string: text, attributes: [kCTFontAttributeName as NSAttributedStringKey: UIFont.systemFont(ofSize: 30.0, weight: UIFont.Weight.regular)])
        return label
    }
    func StopScheduler(){
        print("stopped")
       appDelegate.movescheduler.invalidate()
        self.picker.isUserInteractionEnabled = true
        picker.selectRow(0, inComponent: 0, animated: true)
        picker.selectRow(0, inComponent: 2, animated: true)
    }
    
    func restartOnComplete(){
        self.motion.stopDeviceMotionUpdates()
        
        self.picker.selectRow(appDelegate.mins, inComponent: 0, animated: false)
        self.picker.selectRow(appDelegate.secs, inComponent: 2, animated: false)
        self.TotalSeconds = appDelegate.noMovTotSec
        appDelegate.movescheduler.invalidate()
        
        appDelegate.noMovTotSec = appDelegate.newnoMovTotSec
        self.resetStartTimer(totalSec: appDelegate.newnoMovTotSec)
        print("devicemoving")
        
    }
    func displayTime() {
        
        print(appDelegate.noMovTotSec)
        
//        self.TotalSeconds = appDelegate.noMovTotSec - 1
        appDelegate.noMovTotSec = appDelegate.noMovTotSec - 1
     //   print("\n\n total secs: \(TotalSeconds) \n")
        
        //Count again
        let countdownMinutes = "\(appDelegate.noMovTotSec / 60)"
        let countdownSeconds = "\(appDelegate.noMovTotSec % 60)"
        print("minutes  : \(countdownMinutes) seconds : \(countdownSeconds)")
        self.picker.selectRow(Int(self.minutes.index(of: countdownMinutes)), inComponent: 0, animated: true)
        if countdownSeconds != "0"{
            self.picker.selectRow(Int(self.seconds.index(of: countdownSeconds)), inComponent: 2, animated: true)
        }
        
        self.motion.startDeviceMotionUpdates()
        // Timer.scheduledTimer(withTimeInterval: 0.1, repeats: true) { (timer) in
        
        
        self.initialAttitude  = self.motion.deviceMotion?.attitude
        self.motion.startDeviceMotionUpdates(to: OperationQueue.current!, withHandler:{
            deviceManager, error in
            //Do stuffs with deviceManager or with error
            
            let magnitude = self.magnitudeFromAttitude(attitude: (deviceManager?.attitude)!)
            let floatMagn = String(format: "%.2f", Float(magnitude))
       //     print(floatMagn)
            let floatOldMagn = String(format: "%.2f", self.oldMagnitude)
           // print(floatOldMagn)
            
            if (floatOldMagn as NSString).floatValue != (floatMagn as NSString).floatValue{
                
                self.motion.stopDeviceMotionUpdates()

                self.oldMagnitude = Float(magnitude)
                self.restartOnComplete()
                
//                self.picker.selectRow(appDelegate.mins, inComponent: 0, animated: false)
//                self.picker.selectRow(appDelegate.secs, inComponent: 2, animated: false)
//                self.TotalSeconds = appDelegate.noMovTotSec
//                appDelegate.movescheduler.invalidate()
//
//                appDelegate.noMovTotSec = appDelegate.newnoMovTotSec
//                self.resetStartTimer(totalSec: appDelegate.newnoMovTotSec)
                print("devicemoving")
                
            }else{
               // print("devicnotemoving")
                //Check if alert meets end point
                if appDelegate.noMovTotSec == 0{
                    //Web service NoMovement
                    
//                    appDelegate.isMovementTimer = false
//                    appDelegate.movescheduler.invalidate()
//                    self.motion.stopDeviceMotionUpdates()
//
//                    UserDefaults.standard.set(false, forKey: "NoMovementToggle")
//
//                    self.StopScheduler()
//                    appDelegate.isMove = true

                    Globals().anotherNo()

                    Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sManDown)
                    //NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 3)
               
                self.restartOnComplete()
                }
            }
        })
    }
    func magnitudeFromAttitude(attitude: CMAttitude) -> Double {
        return sqrt(pow(attitude.roll, 2) + pow(attitude.yaw, 2) + pow(attitude.pitch, 2))
    }
    
    //MARK:- GetFallDetect
    
    func getFallDetect()  {
        motion = CMMotionManager()
        motion.startAccelerometerUpdates()
        
        appDelegate.fallscheduler.invalidate()
        
        UIApplication.shared.beginBackgroundTask { }
        
        
        var customizeSenstivityValue : Float = 0
        switch self.senstivityValue {
        case 5:
            customizeSenstivityValue = 1
        case 4:
            customizeSenstivityValue = 2
        case 3:
            customizeSenstivityValue = 3
        case 2:
            customizeSenstivityValue = 4
        case 1:
            customizeSenstivityValue = 5
        default : break
            
        }


        appDelegate.fallscheduler = Timer.scheduledTimer(withTimeInterval: 0.1, repeats: true) { (timer) in
                    if let data = self.motion.accelerometerData {
                        
                        self.x = Float(data.acceleration.x)
                        self.y = Float(data.acceleration.y)
                        self.z = Float(data.acceleration.z)
                        print("x=\(self.x), y=\(self.y), z=\(self.z)")

                        if self.x  >= customizeSenstivityValue || self.y  >= customizeSenstivityValue || self.z  >= customizeSenstivityValue {
                            
                            //FallCode here
                            appDelegate.isFall = true
                            
                            print("\n\n Oh teri! mai digg gya!! \n\n")
                            UIApplication.shared.beginBackgroundTask { }

                        
                           Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sFallDetectAlarm)
                            

                           Globals().anotherNo()

//                            NotificationCenter.default.post(name: NSNotification.Name("RedBegan"), object:nil)
//                            
                        //    NotificationCenter.default.post(name: NSNotification.Name("tabColorShiftReset"), object: nil)
                            
                           // NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 3)

                           // appDelegate.fallscheduler.invalidate()
                           // self.motion.stopAccelerometerUpdates()
                            
//                            UserDefaults.standard.set(false, forKey: "FallDetect")
                        }
                        // Use the accelerometer data in your app.
                    }
                }
        
    }

    //MARK:- IBActions -
    @IBAction func MakeToggles(_ sender: UIButton) {
        if !Globals().checkLocationAuthorization(selectedView: self){
            return
        }
        
        
        if !sender.isSelected{
            sender.isSelected = true
            if sender.tag == 1{
             
                
                senstivityView.alpha = 1
                senstivityView.isUserInteractionEnabled = true
                fallDetectLabel.text = "Fall detect - ON"
                self.getFallDetect()

                UserDefaults.standard.set(true, forKey: "FallDetect")
                
                
            }else{
                
                appDelegate.isMovementTimer = true
                noMoveLabel.text = "No movement - ON"
                NoMovementView.alpha = 0.5
                NoMovementView.isUserInteractionEnabled = false
                print(currentMinutes)
                print(currentSeconds)
                if currentMinutes <= 5 {
                    picker.selectRow(5, inComponent: 0, animated: false)
                    currentMinutes = 5
                    
                }

                
                TotalSeconds = (currentMinutes * 60) + currentSeconds
                print(TotalSeconds)
                appDelegate.noMovTotSec = TotalSeconds
                appDelegate.mins = self.picker.selectedRow(inComponent: 0)
                appDelegate.secs = self.picker.selectedRow(inComponent: 2)
                
                appDelegate.newnoMovTotSec = TotalSeconds

                
                UserDefaults.standard.set(true, forKey: "NoMovementToggle")
                resetStartTimer(totalSec: appDelegate.noMovTotSec)

                
                
              }
        }else{
            sender.isSelected = false
            if sender.tag == 1{
                
                appDelegate.isFall = false

                
                fallDetectLabel.text = "Fall detect - OFF"

                senstivityView.alpha = 0.5
                senstivityView.isUserInteractionEnabled = false
                UserDefaults.standard.set(false, forKey: "FallDetect")
                
                if senstivityPicker.isHidden == false{
                    senstivityPicker.isHidden = true
                    dropArrow.isHidden = false
                    senseLabel.isHidden = false
                }
                appDelegate.fallscheduler.invalidate()
                motion.stopAccelerometerUpdates()
                UserDefaults.standard.set(false, forKey: "FallDetect")
                

                
                }else{
                
                appDelegate.isMove = false
                appDelegate.isMovementTimer = false

                NoMovementView.alpha = 1
                NoMovementView.isUserInteractionEnabled = true
                self.StopScheduler()
                noMoveLabel.text = "No movement - OFF"

                self.picker.selectRow(0, inComponent: 0, animated: false)
                self.picker.selectRow(0, inComponent: 2, animated: false)

                appDelegate.mins = 0
                appDelegate.secs = 1
                
                self.currentMinutes = 0
                self.currentSeconds = 1
                UserDefaults.standard.set(false, forKey: "NoMovementToggle")

             
                
                
                
                           }
        }
        UserDefaults.standard.synchronize()
    }
    
    //MARK:- Reset and start Timer
    
    func resetStartTimer(totalSec : Int)  {
        if UserDefaults.standard.bool(forKey: "NoMovementToggle"){
            print("Globals().noMovTotSec \(appDelegate.noMovTotSec),\(appDelegate.mins),\(appDelegate.secs)")
            self.StopScheduler()
            
            appDelegate.movescheduler.invalidate()
            UIApplication.shared.beginBackgroundTask { }

            appDelegate.movescheduler = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (scheduler) in
                // self.TotalSeconds = appDelegate.noMovTotSec
                self.displayTime()
            })
        }
    }
    @IBAction func SenstivityAction(_ sender: UIButton) {
        senstivityPicker.isHidden = false
        dropArrow.isHidden = true
        senseLabel.isHidden = true
    }
    
    // MARK:- UIPickerViewDelegate -
    public func numberOfComponents(in pickerView: UIPickerView) -> Int{
        if pickerView == picker{
            return 4
        }else{
            return 1
        }
    }
    public func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int{
        if pickerView == picker{
            if component == 0{
                return minutes.count
            }else if component == 1{
                return 1
            }else if component == 2{
                return seconds.count
            }else{
                return 1
            }
        }else{
            return 5
        }
    }
    
    func pickerView(_ pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusing view: UIView?) -> UIView {
        if pickerView == picker{
            if component == 0{
                return UnitLabel(text: (minutes.object(at: row) as? String)!)
            }else if component == 1{
                return UnitLabel(text: "mins")
            }else if component == 2{
                return UnitLabel(text: (seconds.object(at: row) as? String)!)
            }else{
                return UnitLabel(text: "secs")
            }
        }else{
            return UnitLabel(text: "\(row + 1)")
        }
    }
    public func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int){
        if pickerView == picker{
            //For timer
            if component == 0{
                currentMinutes = Int(minutes.object(at: row) as! String)!
                if currentMinutes <= 5 {
                    picker.selectRow(5, inComponent: 0, animated: false)
                    currentMinutes = 5

                }
                

            }
            if component == 2{
                currentSeconds = Int(seconds.object(at: row) as! String)!
            }
        }else{
            //For senstivity
            senseLabel.text = "\(row + 1)"
            
             senstivityValue = Float(row + 1)
            self.getFallDetect()


            UserDefaults.standard.set(Int(row + 1), forKey: "fallSenstivity")
            UserDefaults.standard.synchronize()
            
            senstivityPicker.isHidden = true
            dropArrow.isHidden = false
            senseLabel.isHidden = false
        }
    }
    
    
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)
    }
    
}
