//
//  Dashboard.swift
//  Orbis
//
//  Created by KALSI on 6/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import MessageUI


class Dashboard: UIViewController,MFMessageComposeViewControllerDelegate {

    //@IBOutlet weak var userImage: UIImageView!
    @IBOutlet weak var level: UILabel!
    @IBOutlet weak var locationTime: UILabel!
//    @IBOutlet weak var locationPlace: UILabel!
    @IBOutlet weak var amberTime: UILabel!
    @IBOutlet weak var amberActivity: UILabel!
    @IBOutlet weak var kebabMenu: UIView!
    @IBOutlet weak var kebabDemolition: UIButton!
    
    @IBOutlet weak var FallState: UILabel!
    @IBOutlet weak var FallSenstivity: UILabel!
    
    @IBOutlet weak var usernameLabel: UILabel!
    @IBOutlet weak var lastAmberCallLabel: UILabel!
    var locationUpdateTimer = Timer()

    
    
    var batteryLevel: Float {
        return UIDevice.current.batteryLevel
    }
    
    //MARK:-
    
    override func viewWillDisappear(_ animated: Bool) {
        locationUpdateTimer.invalidate()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        
        kebabMenu.alpha = 0
        level.text = "\(Int(batteryLevel * 100)) %"
       locationUpdateTimer =  Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (timer) in
        self.locationTime.text = String().timeOfLocationUpdate
        })
    //    locationPlace.text = String().placeOfLocationUpdate
        if UserDefaults.standard.object(forKey: Constants.dUserInfo) != nil{
            let dict  = NSKeyedUnarchiver.unarchiveObject(with: UserDefaults.standard.object(forKey: Constants.dUserInfo) as! Data) as! NSDictionary
            usernameLabel.text = (dict.value(forKey: "fullname") as! String).capitalized
        }
        
        if UserDefaults.standard.bool(forKey: "FallDetect") {
            if UserDefaults.standard.object(forKey: "fallSenstivity") != nil{
                FallSenstivity.isHidden = false
                FallState.text = "Active"
                let senstivity = UserDefaults.standard.object(forKey: "fallSenstivity") as! Int
                if senstivity == 4 || senstivity == 5{
                    FallSenstivity.text = "High Senstivity"
                }else if senstivity == 3{
                    FallSenstivity.text = "Medium Senstivity"
                }else if senstivity == 1 || senstivity == 2{
                    FallSenstivity.text = "Low Senstivity"
                }
            }
        }else{
            FallSenstivity.isHidden = true
            FallState.text = "Inactive"
        }
        
        lastAmberCallLabel.text = String().timeOfLastAmberCall
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        
       AppConfiguration.sharedInstance.setConfigData()
        
        
        

        //Notifications
        NotificationCenter.default.addObserver(self, selector: #selector(batteryLevelDidChange), name: .UIDeviceBatteryLevelDidChange, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.displayAmberTime(notify:)), name: NSNotification.Name("amber_display"), object: nil)
    }
    override func viewWillLayoutSubviews() {
//        userImage.frame =  CGRect(x: userImage.frame.origin.x, y:userImage.frame.origin.y , width: userImage.frame.size.height, height: userImage.frame.size.height)
//        userImage.layer.cornerRadius = userImage.frame.size.height / 2
//        userImage.layer.borderColor = UIColor.white.cgColor
//        userImage.layer.borderWidth = 1
//        userImage.layer.masksToBounds = true
        kebabMenu.layer.cornerRadius = 3
        kebabMenu.layer.masksToBounds = true
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    //MARK:-
    @objc func batteryLevelDidChange(_ notification: Notification) {
        level.text = "\(Int(batteryLevel * 100)) %"
    }

    @objc func displayAmberTime(notify : Notification) {
        var TotalSeconds = notify.object as! Int
        TotalSeconds = TotalSeconds - 1
        if TotalSeconds == 0{
            amberActivity.text = "Not Active"
            //stop_amber
            NotificationCenter.default.post(name: NSNotification.Name("stop_amber"), object: nil)
            //Stop scheduler notification
        }
        let countdownMinutes = "\(TotalSeconds / 60)"
        let countdownSeconds = "\(TotalSeconds % 60)"
        amberTime.text = "\(countdownMinutes) mins \(countdownSeconds) secs"
        amberActivity.text = "Active"
    }

    //MARK:- IBActions -
    @IBAction func ShowSideMenu(_ sender: UIButton) {
        kebabDemolition.isHidden = false
        Globals.animations().fadeIn(view: kebabMenu)
    }
    @IBAction func MenuActions(_ sender: UIButton) {
        kebabDemolition.isHidden = true
        Globals.animations().fadeOut(view: kebabMenu)

        var identifier = ""
        switch sender.tag {
        case 1:
            //Profile info
            identifier = "ProfileInfo"
        case 2:
            //Settings
            identifier = "Settings"
            break
        case 3:
            //Device Info
            identifier = "DeviceInfo"
            break
        case 99:
            //Device Info
            isCancel = true
            identifier = "EscalationDetails"
            break
        default:
            break
        }
        if identifier != ""{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: identifier)
            self.navigationController?.pushViewController(vc!, animated: true)
        }
    }
    
    @IBAction func DashActions(_ sender: UIButton) {
        
        appDelegate.interval = 0
        
        switch sender.tag {
        case 1:
            //Amber Alert
           NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 6)
            break
        case 2:
            //Location
            NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 2)
            break
        case 3:
            //Fall Detect
            NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 5)
            break
        case 4:
            //Call
            UserDefaults.standard.setValue(String().fullFormatCurrentTime, forKey: "lastAmberCall")
            UserDefaults.standard.synchronize()
            lastAmberCallLabel.text = "Just Now"
            guard let number = URL(string: "tel://01513432852") else { return }
            UIApplication.shared.open(number)
            break
        case 5:
            break
        case 6:
//            let vc = self.storyboard?.instantiateViewController(withIdentifier: "EscalationDetails") as! EscalationDetails
//            self.navigationController?.pushViewController(vc, animated: true)

            break
        default:
            break
        }
    }
    
    @IBAction func userGuideClck(_ sender: Any) {
        
        let trainingView = self.storyboard?.instantiateViewController(withIdentifier: "TrainingManual")
        
        self.navigationController?.pushViewController(trainingView!, animated: true)


    }
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)
    }
    
 
}
