//
//  AppDelegate.swift
//  Orbis
//
//  Created by KALSI on 6/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import CoreData
import IQKeyboardManagerSwift
import MapKit
import UserNotifications


protocol ClassLocationDelegate {
    func getLocation(_ location: CLLocationCoordinate2D)
    func bgLocation(_ location: CLLocationCoordinate2D)
}



@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate , CLLocationManagerDelegate {
    
     var delegate: ClassLocationDelegate?
    var window: UIWindow?
    var locationArray = NSMutableArray()
    var userLocation = CLLocationCoordinate2D()
    var locmanager = CLLocationManager()
    
    var iPhnToken = ""
  
    
    var isForeground = Bool()
    var isMovementTimer : Bool = false

    var fallscheduler = Timer()
    var blinker = Timer()

    var isFall : Bool = false
    var isMove : Bool = false

    var movescheduler = Timer()

    var isTimerProgress : Bool = false

    var backgroundAccess : Bool = false
    
    var isRedForAmber : Bool = false

    
    var messagePopup : Bool = true

    
    var locTimer = Timer()
    var pudTimer = Timer()
    var isPud : Bool = false

    var isAmberTimer = Bool()

    var totAmberSecs : Int = 0

    //For No Movement
    var noMovTotSec = Int()
    var newnoMovTotSec = Int()
    
    var mins = Int()
    
    var secs = Int()
    var postDateTime = ""
    
    var interval : Int = 0
    var scheduler = Timer()
    
    var selectedViewController  = UIViewController()

    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplicationLaunchOptionsKey: Any]?) -> Bool {
        
       // print("24hoursformat---\(Date().toString(format:""))")
        
        UNUserNotificationCenter.current().requestAuthorization(options:[.badge, .alert, .sound]){ (granted, error) in }
        application.registerForRemoteNotifications()
      
        
        UNUserNotificationCenter.current().requestAuthorization(options: [.badge, .alert, .sound]) {(accepted, error) in
            
            if !accepted {
                print("Notification access denied")
            }
        }
        
        IQKeyboardManager.shared.enable = true
        UIDevice.current.isBatteryMonitoringEnabled = true
        
        
        
        if UserDefaults.standard.bool(forKey: "isLogged") == true {
            self.navigateToDashboard()
            }
        
        isForeground = true
        isAmberTimer = false

        appDelegate.isAmberTimer = true
        
       

        
        locmanager = CLLocationManager()
        
        locmanager.delegate = self
        
        locmanager.requestWhenInUseAuthorization()
        
        locmanager.desiredAccuracy = kCLLocationAccuracyBest
        
        locmanager.startUpdatingLocation()
        
         locmanager.startMonitoringSignificantLocationChanges()
        
//        locTimer = Timer.scheduledTimer(withTimeInterval: 1, repeats: true) { (timer) in
//            self.isAmberTimer = false
//       self.startUpdatingLocation()
//        }
        UserDefaults.standard.set(true, forKey: "isSignalsAllowed")

        
        return true
    }
    
    func startPUD (){
        pudTimer = Timer.scheduledTimer(withTimeInterval: TimeInterval(AppConfiguration.sharedInstance.positionUpdateInterval), repeats: true) { (timer) in
            if (!Globals().checkSignalsAuthorization()){
                
                return
            }
            Globals().SetLocationDelegate()
            self.isPud = true
            self.isAmberTimer = false
            //  self.startUpdatingLocation()
        }
        
    }
    
//    func getAppConfigData() {
//
//        
////        parameters = [
////            "ref":UserDefaults.standard.object(forKey: "userRefID") ?? 0
////                   ]
//print("\(baseURL)\(appConfigService)?ref=\(UserDefaults.standard.object(forKey: "userRefID")!)")
//        
//        print("\(parameters)")
//        
//        
//        Globals.Services().AlamofireGetService(serviceURL: "\(baseURL)\(appConfigService)?ref=\(UserDefaults.standard.object(forKey: "userRefID")!)", completion: { (result) in
//            print(result["data"]!)
//            AppConfiguration.sharedInstance.setConfigData(configData: result["data"]! as! NSDictionary)
//
//        }) { (failure) in
//            print(failure)
//
//        }
//      
//       
//
//    }
    
    func navigateToDashboard() {
        
    //   self.getAppConfigData()
    AppConfiguration.sharedInstance.setConfigData()
        
        self.startPUD()
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let eventDetailsVC = storyboard.instantiateViewController(withIdentifier: "TabController") as! TabController
        let navigationController = self.window?.rootViewController as! UINavigationController
        navigationController.pushViewController(eventDetailsVC, animated: false)
        
    }
    
    func startUpdatingLocation(){
        //Set Location
        print("startUpdatingLocationamber-----")
        UIApplication.shared.beginBackgroundTask {
            
        }
        
        locmanager.delegate = self
        locmanager.desiredAccuracy = kCLLocationAccuracyBest
        locmanager.requestAlwaysAuthorization()
        locmanager.allowsBackgroundLocationUpdates = true
        
        locmanager.startUpdatingLocation()
    }

    
    
    public func locationManager(_ manager: CLLocationManager, didUpdateLocations locations: [CLLocation]){
        
        userLocation = (locmanager.location?.coordinate)!
      //  print("didUpdateLocationscalled")
//
//        if isAmberTimer {
//            print("isamertruecalled")
//            delegate?.getLocation((manager.location?.coordinate)!)
//            self.isAmberTimer = false
//
//        }else{
//           // self.delegate?.bgLocation(self.userLocation)
//
//        }
        if isPud{
            if UserDefaults.standard.object(forKey: "wantTraining") != nil {
                let updatesDictionary = ["date":String().fullFormatCurrentTime, "location":""] as [String : Any]
                UserDefaults.standard.setValue(updatesDictionary, forKey: "locationOrb")
                //UserDefaults.standard.synchronize()


            self.delegate?.bgLocation(self.userLocation)

                
            isPud = false
            }

        }
           // locmanager.stopUpdatingLocation()
        
            //locmanager.delegate = nil
            self.backgroundAccess = false
         
    }

    func applicationWillResignActive(_ application: UIApplication) {
        print("Orbis is resigned")
       // if !self.messagePopup{

        if UserDefaults.standard.bool(forKey: "code_red"){
            NotificationCenter.default.post(name: NSNotification.Name("stopViberating"), object: nil)
        }
        //}
        
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        
       
        
        isForeground = false
        appDelegate.isFall = false
        appDelegate.isMove = false

        
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
        isForeground = true
        locTimer.invalidate()
        if UserDefaults.standard.bool(forKey: "code_red") {
            Timer.scheduledTimer(withTimeInterval: 1, repeats: false, block: { (Timer) in
                NotificationCenter.default.post(name: NSNotification.Name("CallRed"), object: nil)
            })
        }
        
        if self.isFall || self.isMove{
            Globals().anotherNo()

        }
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        
        //if !self.messagePopup{
        if UserDefaults.standard.bool(forKey: "code_red") {
            NotificationCenter.default.post(name: NSNotification.Name("startViberating"), object: nil)
        }
       // }
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }
    
    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
        // Saves changes in the application's managed object context before the application terminates.
        self.saveContext()
    }

    // MARK: - Core Data stack

    lazy var persistentContainer: NSPersistentContainer = {
        /*
         The persistent container for the application. This implementation
         creates and returns a container, having loaded the store for the
         application to it. This property is optional since there are legitimate
         error conditions that could cause the creation of the store to fail.
        */
        let container = NSPersistentContainer(name: "Orbis")
        container.loadPersistentStores(completionHandler: { (storeDescription, error) in
            if let error = error as NSError? {
                // Replace this implementation with code to handle the error appropriately.
                // fatalError() causes the application to generate a crash log and terminate. You should not use this function in a shipping application, although it may be useful during development.
                 
                /*
                 Typical reasons for an error here include:
                 * The parent directory does not exist, cannot be created, or disallows writing.
                 * The persistent store is not accessible, due to permissions or data protection when the device is locked.
                 * The device is out of space.
                 * The store could not be migrated to the current model version.
                 Check the error message to determine what the actual problem was.
                 */
                fatalError("Unresolved error \(error), \(error.userInfo)")
            }
        })
        return container
    }()

    // MARK: - Core Data Saving support

    func saveContext () {
        let context = persistentContainer.viewContext
        if context.hasChanges {
            do {
                try context.save()
            } catch {
                // Replace this implementation with code to handle the error appropriately.
                // fatalError() causes the application to generate a crash log and terminate. You should not use this function in a shipping application, although it may be useful during development.
                let nserror = error as NSError
                fatalError("Unresolved error \(nserror), \(nserror.userInfo)")
            }
        }
    }
    
    //MARK: RemoteNotification
    
    public func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any]){
        
        print(userInfo)
    }
    
    func userNotificationCenter(_ center: UNUserNotificationCenter, didReceive response: UNNotificationResponse, withCompletionHandler completionHandler: @escaping () -> Swift.Void){
       
        print("Recived: \(response)")
        
    }
    
     func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Swift.Void) {
        
        completionHandler( [.alert, .badge, .sound])
    }
    
     private func application(application: UIApplication,  didReceiveRemoteNotification userInfo: [NSObject : AnyObject],  fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
        
        print("Recived: \(userInfo)")
        
        completionHandler(.newData)
        
    }

    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Swift.Void){
        print("Recived: \(userInfo)")
let aps = userInfo["aps"] as? NSDictionary
        print("Recivedddddddaps: \(aps!)")
        
        if aps?["alert"] as! String ==  "Signal Allowed"{
            UserDefaults.standard.set(true, forKey: "isSignalsAllowed")

        }
        else{
            UserDefaults.standard.set(false, forKey: "isSignalsAllowed")

        }
    }
    
//    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
//        if let aps = userInfo["aps"] as? NSDictionary {
//            print(aps)
//          //  let alert = (aps.object(forKey: "alert") as? String)!
//        }
//        
//        
//    }
    
    func application(_ application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data) {
        // Convert token to string
        let deviceTokenString = deviceToken.reduce("", {$0 + String(format: "%02X", $1)})
        
        // Print it to console
        print("APNs device token: \(deviceTokenString)")
        iPhnToken = deviceTokenString
        
        let alertView = UIAlertController(title: "", message: deviceTokenString, preferredStyle: .alert)
        let action = UIAlertAction(title: "OK", style: .default, handler: { (alert) in
            
        })
        alertView.addAction(action)
      //  self.window?.rootViewController?.present(alertView, animated: true, completion: nil)

        // DF279E65798F9202273A28793F494FE1CEB713A9B2E507C9C511592CE09A6E80
        // Persist it in your backend in case it's new
    }
    
    // Called when APNs failed to register the device for push notifications
    func application(_ application: UIApplication, didFailToRegisterForRemoteNotificationsWithError error: Error) {
        // Print the error to console (you should alert the user that registration failed)
        print("APNs registration failed: \(error)")
    }

}


