//
//  AmberAlert.swift
//  Orbis
//
//  Created by KALSI on 5/26/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import AudioToolbox
import MapKit
import MessageUI
import CoreLocation




class AmberAlert: UIViewController, UIPickerViewDataSource, UIPickerViewDelegate,MFMessageComposeViewControllerDelegate {
    
    @IBOutlet weak var picker: UIPickerView!
    @IBOutlet weak var StartBtn: UIButton!
    @IBOutlet weak var StopBtn: UIButton!
    @IBOutlet weak var ExtendBtn: UIButton!
    @IBOutlet weak var startView: UIView!
    @IBOutlet weak var stopView: UIView!
    @IBOutlet weak var extendView: UIView!
    @IBOutlet weak var stopLabel: UILabel!
    @IBOutlet weak var extendLabel: UILabel!
    @IBOutlet weak var startLabel: UILabel!
    @IBOutlet weak var startImage: UIImageView!
    @IBOutlet weak var stopImage: UIImageView!
    @IBOutlet weak var extendImage: UIImageView!
    @IBOutlet weak var countdownLabel: UILabel!
    
    @IBOutlet weak var setTimerLabel: UILabel!
    @IBOutlet weak var HMSLabel: UILabel!
    
    var hours = NSMutableArray()
    var minute = NSMutableArray()
    var currentHours = Int()
    var currentMinutes = Int()
    var TotalSeconds = Int()
    
    var locmanager = CLLocationManager()
    
    
    // MARK: -
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        selection(view: startView, andButton: StartBtn)
        GenerateClockUnits()
       // self.picker.selectRow(1, inComponent: 1, animated: false)
        if UserDefaults.standard.bool(forKey: "code_amber") != false{
            resetButtons()
            selection(view: stopView, andButton: StopBtn)
            selection(view: extendView, andButton: ExtendBtn)
            startLabel.textColor = UIColor.darkGray
            stopLabel.textColor = UIColor.white
            extendLabel.textColor = UIColor.white
            
            startImage.image = UIImage(named: "gray")
            stopImage.image = UIImage(named: "purple")
            extendImage.image = UIImage(named: "purple")
        }
        picker.selectRow(4, inComponent: 2, animated: false)

        if appDelegate.isTimerProgress {

            HMSLabel.isHidden = false
            self.picker.isHidden = true
            NotificationCenter.default.post(name: NSNotification.Name("amber_display"), object: appDelegate.totAmberSecs)
            countdownLabel.isHidden = false

        }else{

            self.HMSLabel.isHidden = true


            countdownLabel.isHidden = true

            
            self.picker.isHidden = false

        }


    }
    
    override func viewWillDisappear(_ animated: Bool) {
        appDelegate.interval = 0
       // appDelegate.totAmberSecs = self.TotalSeconds
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        if AppConfiguration.sharedInstance.userinteractionEnabled == 0{
            
            picker.isUserInteractionEnabled = false
        }else{
            
            picker.isUserInteractionEnabled = true
        }

        
        UserDefaults.standard.set("AmberAlert", forKey: "screen?")
        UserDefaults.standard.synchronize()
        resetButtons()
        TotalSeconds = 0
        currentHours = 0
        currentMinutes = 1
        picker.setValue(UIColor.white, forKeyPath: "textColor")
        
        //Notifications
        NotificationCenter.default.addObserver(self, selector: #selector(self.displayTime(notify:)), name: NSNotification.Name("amber_display"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.StopScheduler), name: NSNotification.Name("stop_amber"), object: nil)
        
        
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    override func viewWillLayoutSubviews() {
        if UserDefaults.standard.bool(forKey: "code_amber") != false{
            AnimateBegins()
        }
    }
    
    //MARK:-
    func GenerateClockUnits(){
        //Genrating minutes & seconds
        
        print("AppConfigurationTimerrrrrr\(AppConfiguration.sharedInstance.fixedAmberTime)")
        var mins = 0
//        while mins < 30 {
        while mins < AppConfiguration.sharedInstance.fixedAmberTime {
            hours.add("\(mins)")
            if mins != 0{
                minute.add("\(mins)")
            }
            mins += 1
        }
        minute.add("60")
        picker.reloadAllComponents()
    }
    
    func resetButtons(){
        startView.alpha = 0.5
        stopView.alpha = 0.5
        extendView.alpha = 0.5
        StartBtn.isUserInteractionEnabled = false
        StopBtn.isUserInteractionEnabled = false
        ExtendBtn.isUserInteractionEnabled = false
    }
    
    func ResetTimer() {
        TotalSeconds = 0
        currentHours = 5
        currentMinutes = 1
        
        appDelegate.scheduler.invalidate()
    }
    func selection(view : UIView , andButton: UIButton) {
        view.alpha = 1
        andButton.isUserInteractionEnabled = true
    }
    func AnimateBegins() {
        UIView.animate(withDuration: 0.3) {
            self.startView.transform = CGAffineTransform(scaleX: 0.7, y: 0.7)
            self.stopView.transform = CGAffineTransform(scaleX: 1.3, y: 1.3)
            self.extendView.transform = CGAffineTransform(scaleX: 1.3, y: 1.3)
        }
    }
    func AnimateFinishes() {
        //Animation
        UIView.animate(withDuration: 0.3) {
            self.startView.transform = CGAffineTransform(scaleX: 1, y: 1)
            self.stopView.transform = CGAffineTransform(scaleX: 1, y: 1)
            self.extendView.transform = CGAffineTransform(scaleX: 1, y: 1)
        }
    }
    
    @objc func StopScheduler() {
        
        SingletonTimer.sharedInstance.stop30SecTimer()
        startLabel.textColor = UIColor.white
        stopLabel.textColor = UIColor.darkGray
        extendLabel.textColor = UIColor.darkGray
        
        startImage.image = UIImage(named: "orange")
        stopImage.image = UIImage(named: "gray")
        extendImage.image = UIImage(named: "gray")
        
        resetButtons()
        ResetTimer()
        selection(view: startView, andButton: StartBtn)
        picker.isUserInteractionEnabled = true
        picker.selectRow(0, inComponent: 0, animated: true)
        picker.selectRow(0, inComponent: 2, animated: true)
        UserDefaults.standard.set(false, forKey: "code_amber")
        UserDefaults.standard.removeObject(forKey: "amber_time")
        UserDefaults.standard.synchronize()
    }
    
    @objc func displayTime(notify : Notification) {
        
        print("TotalSeconds:::::::::::::::::::::::::::::::----- \(self.TotalSeconds)")
        self.TotalSeconds = notify.object as! Int
        
        print("TotalSeconds:::::::::::::::::::::::::::::::----- \(self.TotalSeconds)")

        self.TotalSeconds = self.TotalSeconds - 1
        
        appDelegate.totAmberSecs = self.TotalSeconds

        if appDelegate.totAmberSecs == 120  {
            Globals().createNotification(title: "Amber Alert", message: "2 minutes left to activate!")
            SingletonTimer.sharedInstance.start30SecTimer()
        }
        
        if TotalSeconds < 120{
            AudioServicesPlayAlertSound(SystemSoundID(kSystemSoundID_Vibrate))
        }
        
        print(TotalSeconds)
//
        
        //Count again
        
        let countdownMinutes = (self.TotalSeconds / 60) % 60
        
        //        let countdownHours = (self.TotalSeconds / 3600)
        
        let countdownHours = (self.TotalSeconds / 3600)
        
        
        let countdownSeconds = (self.TotalSeconds % 60)
        
        
        print("TotalSeconds:\(self.TotalSeconds)")
        print("countdownHours:\(countdownHours),countdownMinutes:\(countdownMinutes),countdownSeconds:\(countdownSeconds)")
        
        var showHrs = "\(countdownHours)"
        var showMins = "\(countdownMinutes)"
        var showSecs = "\(countdownSeconds)"
        if countdownHours < 10{
            showHrs = "0\(countdownHours)"
        }
        if countdownMinutes < 10{
            showMins = "0\(countdownMinutes)"
        }
        if countdownSeconds < 10{
            showSecs = "0\(countdownSeconds)"
        }
        
        
        
        print(TotalSeconds)
        
        
        countdownLabel.text = "\(showHrs) : \(showMins) : \(showSecs) "
        print("countdownHours: \(countdownHours), countdownMinutes: \(countdownMinutes), countdownSeconds:  \(countdownSeconds)")
        
        //        self.picker.selectRow(Int(self.hours.index(of: countdownHours)), inComponent: 0, animated: true)
        //        if countdownSeconds != "0"{
        //            self.picker.selectRow(Int(self.minute.index(of: countdownMinutes)), inComponent: 2, animated: true)
        
        //Check if alert meets end point
        if self.TotalSeconds <= 0{
            //Web service
            appDelegate.isTimerProgress = false
            self.perform(#selector(self.sendexceedSignal), with: nil, afterDelay: 0.2)
            AnimateFinishes()
            StopScheduler()
            self.picker.isUserInteractionEnabled = true
            NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 3)
        }
        
    }
    
    @objc func sendexceedSignal(){
        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sAmberExpiredAlarm)

    }
    
    func UnitLabel( text : String) -> UILabel {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: picker.frame.size.width / 2, height: 40))
        label.textAlignment = .center
        label.textColor = UIColor.white
        label.attributedText = NSAttributedString(string: text, attributes: [kCTFontAttributeName as NSAttributedStringKey: UIFont.systemFont(ofSize: 27.0, weight: UIFont.Weight.regular)])
        return label
    }
    @objc func setCall()  {
        Globals().call()
    }
    
    
    // MARK: - IBActions -
    
    @IBAction func StartAlert(_ sender: UIButton) {
        
        
        if !Globals().checkLocationAuthorization(selectedView: self){
            return
        }
        
        
        self.setSecondsinProp()

        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sAmberStart)
        self.perform(#selector(self.setCall), with: nil, afterDelay: 0.2)

        startAmber()
           }
    
    
    func setSecondsinProp(){
        appDelegate.isTimerProgress = true
        appDelegate.isRedForAmber = true
        
        if (self.picker.selectedRow(inComponent: 2) == 4) {
            
            //DangerLeft mnts -- 5
            currentMinutes = 5
        }
        
        
        //        if currentHours <= 0 {
        //            currentMinutes = 5
        //
        //        }
        if (self.picker.selectedRow(inComponent: 0) == 0) {
            currentHours = 0
        }
        
        
        
        print(self.picker.selectedRow(inComponent: 0))
        
        print("currentHours:::\(currentHours),currentMinutes::\(currentMinutes)")
        
        // appDelegate.interval = currentHours
        
        
        let hoursToMint = currentHours  * 60
        
        let hrsMintToSec = hoursToMint  * 60
        
        
        let mintToSec = currentMinutes * 60
        
        self.TotalSeconds = hrsMintToSec + mintToSec
        
        print("TotalSeconds::::::::>\(TotalSeconds)")
        appDelegate.totAmberSecs = TotalSeconds
        
        appDelegate.interval = appDelegate.totAmberSecs / 60
        

    }
    func startAmber() {
               //        TotalSeconds = ((currentHours * 60) + currentMinutes) * 60
        
        self.setSecondsinProp()
        //it has to be 300
        if TotalSeconds >= 0{
            //Web service
            
            resetButtons()
            selection(view: stopView, andButton: StopBtn)
            selection(view: extendView, andButton: ExtendBtn)
            
            startLabel.textColor = UIColor.darkGray
            stopLabel.textColor = UIColor.white
            extendLabel.textColor = UIColor.white
            
            startImage.image = UIImage(named: "gray")
            stopImage.image = UIImage(named: "purple")
            extendImage.image = UIImage(named: "purple")
            
            //Animation
            AnimateBegins()
            
            self.picker.isUserInteractionEnabled = false
            //Globals().addPrompt(message: "Amber alert activated!", view: self) {}
            UserDefaults.standard.set(true, forKey: "code_amber")
            let amberTime = ["m": "\(currentHours)", "s":"\(currentMinutes)"]
            
            UserDefaults.standard.set(amberTime, forKey: "amber_time")
            UserDefaults.standard.synchronize()
            UIApplication.shared.beginBackgroundTask { }
            
            print("TotalSeconds::::::::>\(TotalSeconds)")
            
            appDelegate.scheduler.invalidate()
            appDelegate.scheduler = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (timer) in
                if UserDefaults.standard.bool(forKey: "code_amber"){
                    
                    print("totAmberSecs::::::::>\(appDelegate.totAmberSecs)")
                    
                    print("TotalSeconds::::::::>\(self.TotalSeconds)")
                    
                    NotificationCenter.default.post(name: NSNotification.Name("amber_display"), object:appDelegate.totAmberSecs)
                    
                    self.picker.isHidden = true
                    self.setTimerLabel.isHidden = true
                    self.countdownLabel.isHidden = false
                    self.HMSLabel.isHidden = false
                    
                }
            })
            
            
        }else{
            Globals().addPrompt(message: "Alert must not be less than 5 minutes!", view: self, completion: {  })
        }

    }
    
    func callDisplay()  {
       
    }
    @IBAction func GoBack(_ sender: Any) {
        NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 1)
    }
    @IBAction func StopAlert(_ sender: UIButton) {
        
        appDelegate.isRedForAmber = false

        currentMinutes = 0
    currentHours = 0

        appDelegate.interval = 0
        appDelegate.isTimerProgress = false

        //Web service
        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sAmberStop)
        
        AnimateFinishes()
        StopScheduler()
        
        picker.isHidden = false
        setTimerLabel.isHidden = false
        countdownLabel.isHidden = true
        HMSLabel.isHidden = true
        appDelegate.scheduler.invalidate()
self.TotalSeconds = 0
        picker.selectRow(4, inComponent: 2, animated: false)

    }
    @IBAction func ExtendAlert(_ sender: UIButton) {
        
        SingletonTimer.sharedInstance.stop30SecTimer()

        
        if !Globals().checkLocationAuthorization(selectedView: self){
            return
        }
        
        
        self.setSecondsinProp()

        
        //Web service
        Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sAmberExtended)
        
        //reset timer
        
        startAmber()
        return
        
        if UserDefaults.standard.value(forKey: "amber_time") != nil {
            let amberTime = UserDefaults.standard.value(forKey: "amber_time") as! NSDictionary
            let m = amberTime.value(forKey: "m") as! String
            let s = amberTime.value(forKey: "s") as! String
            picker.selectRow(Int(hours.index(of: m)), inComponent: 0, animated: true)
            if s != "0"{
                picker.selectRow(Int(minute.index(of: s)), inComponent: 2, animated: true)
            }
            
            currentHours = Int(m)!
            currentMinutes = Int(s)!
            
            let hoursToMint = currentHours  * 60
            
            let hrsMintToSec = hoursToMint  * 60
            
            
            let mintToSec = currentMinutes * 60
            
            TotalSeconds = hrsMintToSec + mintToSec
            
            appDelegate.totAmberSecs = TotalSeconds
            appDelegate.interval = appDelegate.totAmberSecs / 60

            appDelegate.scheduler.invalidate()
            UIApplication.shared.beginBackgroundTask { }

            appDelegate.scheduler = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (timer) in
                if UserDefaults.standard.bool(forKey: "code_amber"){
                    
                    
                    NotificationCenter.default.post(name: NSNotification.Name("amber_display"), object:appDelegate.totAmberSecs)
                    
                    
                }
            })
            
           // NotificationCenter.default.post(name: NSNotification.Name("amber_display"), object:appDelegate.totAmberSecs)
            
         //   TotalSeconds = (currentHours * 60) + currentMinutes
        }
    }
    
    // MARK:- UIPickerViewDelegate -
    public func numberOfComponents(in pickerView: UIPickerView) -> Int{
        return 4
    }
    public func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int{
        if component == 0{
            return hours.count
        }else if component == 1{
            return 1
        }else if component == 2{
            return minute.count
        }else{
            return 1
        }
    }
    func pickerView(_ pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusing view: UIView?) -> UIView {
        if component == 0{
            return UnitLabel(text: (hours.object(at: row) as? String)!)
        }else if component == 1{
            return UnitLabel(text: "hrs")
        }else if component == 2{
            return UnitLabel(text: (minute.object(at: row) as? String)!)
        }else{
            return UnitLabel(text: "mins")
        }
    }
    public func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int){
        if component == 0{
            //            if row < 5 {
            //                Globals().addPrompt(message: "Amber timer must not be less than 5 minutes!", view: self, completion: {
            //                    self.picker.selectRow(5, inComponent: 0, animated: true)
            //                })
            //            }else{
            
            currentHours = Int((hours[row] as? String)!)! //Int(hours.object(at: row) as! String)!
            
            //            }
        }
        if component == 2{
            
            let selectedComponentz = pickerView.selectedRow(inComponent: 0)
            if selectedComponentz == 0{
                currentHours = 0

            }
            if row < 5 {
                if currentHours <= 0 {
                picker.selectRow(4, inComponent: 2, animated: false)
                currentMinutes = 5
                }else{
                    currentMinutes = Int((minute[row]  as? String)!)!
                }
            }
            else{
                currentMinutes = Int((minute[row]  as? String)!)!//Int(minute.object(at: row) as! String)!
                
            }
            
            
        }
    }
    
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)
    }
    
    
}
