$(document).ready(function(){

	function getUrlVars()
	{
	    var vars = [], hash;
	    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
	    for(var i = 0; i < hashes.length; i++)
	    {
	        hash = hashes[i].split('=');
	        vars.push(hash[0]);
	        vars[hash[0]] = hash[1];
	    }
	    return vars;
	}

	if( getUrlVars()["q"] == 'addlwd' )
	{
		$('#lightbox').modal('show');
	}

	if( getUrlVars()["q"] == 'addcostcenter' )
	{
		$('#lightbox').modal('show');
	}

	if( getUrlVars()["q"] == 'addcontract' )
	{
		$('#lightbox').modal('show');
	}
	if( getUrlVars()["q"] == 'addoffices' )
	{
		$('#lightbox').modal('show');
	}


	/* get signal value by selecting checkbox in lwd screen */
	$('.signal_kill').change(function(){
		/*alert( $(this).val() );
		alert( $(this).data('lwd_id') );*/
		$.ajax({
			url: 'http://54.218.78.31:50/index.php/lwd/change_signal_kill/',
			type: 'post',
			data: { lwd_id: $(this).data('lwd_id'), signal_kill: $(this).val() },
			success: function(result)
			{
				console.log(result);
				if( result == 'done' )
				{
					$('.img_src').html('<img src="http://54.218.78.31:50/img/TickGif.gif">');
					$('.modal_text').html('<p>Signal Update</p>');
					$('#lightboxPopup').modal('show');
					setTimeout( function() {
						window.location.href="";
					}, 3000);
				}
			}
		})
	});

	$.validator.addMethod(
		    "dateFormat",
		    function(value, element) {
		        // put your own logic here, this is just a (crappy) example
		        var regEx = /^\d{2}-\d{2}-\d{4}$/;
  				return value.match(regEx) != null;
		    },
		    "Please enter a date in the format dd-mm-yyyy."
		);

	$("#add_lwd").validate({
		rules:
		{
			costcenter:
			{
				required: true
			},
			email: 
			{
				required: true,
				email: true
			},
			password: "required",
			gender:
			{
				required: true
			},
			dob:
			{
				required: true
			},
			fname: 'required',
			login_name: 'required',
			number:
			{
				required: true,
				number: true,
				minlength: 12,
				maxlength: 13
			},
			imei: 'required',
			address: 'required'
		},
		messages: 
		{
			costcenter: "Select your Cost Center",
			email:
			{
				required: "Email is required",
				email: "Invalid Email"
			},
			gender:
			{
				required: "Please Select Gender"
			},
			number:
			{
				minlength: 'Please insert country code',
				maxlength: 'Please insert country code'
			}
		},
	  submitHandler: function(form) {
	    	$.ajax({
	    		type: 'post',
	    		url: 'lwd/add_lwd',
	    		data: $('#add_lwd').serialize(),
	    		success: function(result)
	    		{
	    			if(result == "done")
	    			{
	    				$('.ajax_msg').html('<span style="color: green; font-weight: bold">Insert Success</span>');
	    				setTimeout(function(){ 
	    					$('.ajax_msg').text(' ');
	    					$("#add_lwd")[0].reset();
	    					$('#lightbox').modal('hide');
	    				}, 1500);
	    			}
	    			else
	    			{
	    				$('.ajax_msg').html('<span style="color: red; font-weight: bold">Insert Fail</span>');
	    				setTimeout(function(){ $('.ajax_msg').text(' '); }, 1500);
	    			}
	    		}
	    	})
	  }
 	});


/*----------adding more divs-----------*/


	var clicks = 0;
 	$('.addMoreDiv').on('click', function()
 	{
 		clicks++;
 		var html_div;
 		var html = $(this).data('form');
 		if( html == "costcenter" )
		{
			html_div = '<div class="row lighboxInner" id="div_'+clicks+'"><div class="col-lg-12"><div class="form-group label-floating"><label class="control-label">Cost Service Name</label><input type="text" class="form-control fullNameField" name="cc_name[]" required=""></div><a href="javascript:void(0);" class="deleteDiv" onclick="return deleteDiv('+clicks+')"><img src="/img/deleteIcon.svg"></a><a href="javascript:void(0);" class="addMoreDivNew"><img src="/img/addIcon.svg"></a></div></div>';
		}
		$('.add_more_fields').append(html_div);
 	});

 	$('.add_more_fields').on( 'click', '.addMoreDivNew', function(){
 		$('.addMoreDiv').trigger('click');
 	});


 	$('#add_costcenter').submit(function(event){
 		event.preventDefault();
 		$.ajax({
 			url: 'costcenter/add_cost_center',
 			type: 'post',
 			data: $('#add_costcenter').serialize(),
 			success: function(result)
 			{
 				if(result == "done")
 				{
 					$('.ajax_msg').html('<p style="color: green;">Cost Center Added </p>');
 					setTimeout(function(){ window.location.href='' ; }, 1000);
 				}
 				else if(result == "update")
 				{
 					$('.ajax_msg').html('<p style="color: green;">Cost Center Updated </p>');
 					setTimeout(function(){ window.location.href='' ; }, 1000);
 				}
 				else
 				{
 					$('.ajax_msg').html('<p style="color: green;">'+result+'</p>');	
 					setTimeout(function(){ window.location.href='' ; }, 1000);
 				}
 			}
 		});
 	});


/*----- adding contract area ----*/

$("#add_contractarea").validate({
		rules:
		{
			office_name: 'required',
			costcenter: 'required',
			contract_area: 'required',
			admin_name: 'required',
			email_address: 'required',
			contact_number: {
				required: true,
				number: true
			},
			password:
			{
				required: true
			},
			cpassword:
			{
				required: true,
				equalTo: '#password'
			}
		},
		submitHandler: function(form)
		{
			$.ajax({
				url: 'contractarea/add_contractAreaOffice',
				type: 'post',
				data: $('#add_contractarea').serialize(),
				success: function(result)
				{
					if(result == "done")
	 				{
	 					$('.ajax_msg').html('<p style="color: green;">Contract Area Added </p>');
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
	 				else if(result == "update")
	 				{
	 					$('.ajax_msg').html('<p style="color: green;">Cost Center Updated </p>');
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
	 				else
	 				{
	 					$('.ajax_msg').html('<p style="color: green;">'+result+'</p>');	
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
				}
			});
		}
	});


/*--- add offices ---*/
$("#add_office").validate({
		rules:
		{
			office_name: 'required',
			contract_area: 'required',
			admin_name: 'required',
			email_address: 'required',
			contact_number: {
				required: true,
				number: true
			},
			password:
			{
				required: true
			},
			cpassword:
			{
				required: true,
				equalTo: '#password'
			}
		},
		submitHandler: function(form)
		{
			$.ajax({
				url: 'office/add_Office',
				type: 'post',
				data: $('#add_office').serialize(),
				success: function(result)
				{
					console.log(result);
					if(result == "done")
	 				{
	 					$('.ajax_msg').html('<p style="color: green;">Office Added </p>');
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
	 				else if(result == "update")
	 				{
	 					$('.ajax_msg').html('<p style="color: green;">Office Updated </p>');
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
	 				else
	 				{
	 					$('.ajax_msg').html('<p style="color: red;">'+result+'</p>');	
	 					setTimeout(function(){ window.location.href='' ; }, 1000);
	 				}
				}
			});
		}
	});



/*---- change status of cost center ----*/
$('.status').change(function()
{
	/*alert( $(this).data('cost_id') );
	alert( $(this).val() );*/
	$.ajax(
	{
		url: 'costcenter/change_status',
		type: 'post',
		data: { id: $(this).data('cost_id'), status: $(this).val() },
		success: function(result)
		{
			console.log(result);
			if( result == 'done' )
			{
					$('.img_src').html('<img src="http://54.218.78.31:50/img/TickGif.gif">');
					$('.modal_text').html('<p>Status Update </p>');
					$('#lightboxPopup').modal('show');
					setTimeout( function() {
						window.location.href="";
					}, 3000);
			}
			else
			{
				$('.img_src').html('<img src="http://54.218.78.31:50/img/Cancel.png">');
				$('.modal_text').html('<p>Status Update Fail</p>');
				$('#lightboxPopup').modal('show');
			}
		}
	});
});


/*---- change status of contract area ----*/
$('.contractarea_status').change(function()
{
	$.ajax(
	{
		url: 'contractarea/change_status',
		type: 'post',
		data: { id: $(this).data('cost_id'), status: $(this).val() },
		success: function(result)
		{
			console.log(result);
			if( result == "done" )
			{
				$('.img_src').html('<img src="http://54.218.78.31:50/img/TickGif.gif">');
				$('.modal_text').html('<p>Status Update </p>');
				$('#lightboxPopup').modal('show');
				setTimeout( function() {
					window.location.href="";
				}, 3000)
			}
			else
			{
				$('.img_src').html('<img src="http://54.218.78.31:50/img/Cancel.png">');
				$('.modal_text').html('<p>Status Update Fail</p>');
				$('#lightboxPopup').modal('show');
			}
		}
	});
});


/*---- change the status of office ----*/
$('.office_status').change(function()
{
	$.ajax(
	{
		url: 'office/change_status',
		type: 'post',
		data: { id: $(this).data('cost_id'), status: $(this).val() },
		success: function(result)
		{
			console.log(result);
			if( result == "done" )
			{
				$('.img_src').html('<img src="http://54.218.78.31:50/img/TickGif.gif">');
				$('.modal_text').html('<p>Status Update </p>');
				$('#lightboxPopup').modal('show');
				setTimeout( function() {
					window.location.href="";
				}, 3000)
			}
			else
			{
				$('.img_src').html('<img src="http://54.218.78.31:50/img/Cancel.png">');
				$('.modal_text').html('<p>Status Update Fail</p>');
				$('#lightboxPopup').modal('show');
			}
		}
	});
});


$('.cancel').click(function(e){
	e.preventDefault();
	var r = confirm("Are you sure you want to cancel the action");
	if (r == true) {
		$('.deleteDiv').trigger('click');
		$('.closepopup').trigger('click');
	} else {
		
	}
});


}); /*document ready function*/

/*--------------------- Check for Login Name--------------------------*/
function login_name_check()
{
	//alert();
	$.ajax({
		type: 'get',
		url: 'lwd/login_name',
		data: { login_name: $('#login_name').val() },
		success: function(result)
		{
			if( result == "already" )
			{
				$('.login_name_error').text("Login Name already used");
				$('#submit_button').attr('disabled', 'true');
			}
			else
			{
				$('.login_name_error').text(" ");
				$('#submit_button').removeAttr('disabled');
			}
		}
	});
}


function email_address_check()
{
	$.ajax({
		type: 'get',
		url: 'lwd/email_address',
		data: { email_address: $('#email_address').val() },
		success: function(result)
		{
			if( result == "already" )
			{
				$('.email_error').text("Email already used");
				$('#submit_button').attr('disabled', 'true');
			}
			else
			{
				$('.email_error').text(" ");
				$('#submit_button').removeAttr('disabled');
			}
		}
	});
}


/*---- check for contract area email -----*/
function email_check()
{
	$.ajax({
		type: 'get',
		url: 'contractarea/check_email',
		data: { email_address: $('#email_address').val() },
		success: function(result)
		{
			/*if( result == "already" )
			{
				$('.login_name_error').text("Login Name already used");
			}
			else
			{
				$('.login_name_error').text(" ");	
			}*/
			console.log(result);
		}
	});
}

/*---- deleting more cost center ----*/
function deleteDiv(num)
{
	$('#div_'+num).html(' ');	
}


function add_costcenter_modal()
{
	$('#cc_name').val(' ');
	$('#costcenterID').val(' ');
	$('#lightbox').modal({
        backdrop: 'static',
        keyboard: false
    });
	
}

/*----- ajax for editing costcenter -------*/
function editing_costcenter(id,name)
{
	$('#cc_name').val(name);
	$('#costcenterID').val(id);
	$('.label-floating').addClass('is-focused');
	$('#lightbox').modal({
        backdrop: 'static',
        keyboard: false
    });
}


function add_contract_area()
{
	$('#pop_heading').text('Add Contract Area');
	$('#contract_area').val(' ');
	$('#contractarea_id').val(' ');
	$('#add_costcenter').css('display', 'block');
	$('#edit_costcenter').html(' ');
	$('#lightbox').modal({
        backdrop: 'static',
        keyboard: false
    });
}

function edit_contract_area(id, name, costcenter)
{
	$('#pop_heading').text('Edit Contract Area');
	$('#add_costcenter').css('display', 'none');
	$('#edit_costcenter').html('<select disabled ><option>'+costcenter+'</option></select>');
	$('#contract_area').val(name);
	$('#contractarea_id').val(id);
	$('.label-floating').addClass('is-focused');
	$('#lightbox').modal({
        backdrop: 'static',
        keyboard: false
    });
}