<?php
Class Cost_center extends CI_Model
{
	private $mysql;
	private $table;
	public $cost_center_name;
	public $costcenterid;
	public $status;

	public function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
		$this->table = 'newcostcentres';
	}

/*---- get all cost center list -----*/
	function cc_list()
	{
		return $this->mysql->select('*')->from($this->table)->order_by('create_date', 'asc')->get()->result_array();
		//echo $this->mysql->last_query();
	}
	
/*---- get all cost center list -----*/
	function cc_filter_list($id)
	{
		return $this->mysql->select('*')->from($this->table)->where('lindex',$id)->order_by('create_date', 'asc')->get()->result_array();
	}

/*-------- adding cost center query -------*/	
	function add_cost_center()
	{
		for( $i=0; $i<count( $this->cost_center_name['cc_name'] ); $i++ )
		{
			$data['description'] = $this->cost_center_name['cc_name'][$i];
			$data['create_date'] = date('Y-m-d H:i:s');
			$this->mysql->insert($this->table,$data);
		}
		$insert_id = $this->mysql->insert_id();

		/*-- checking for successful insertion --*/
		if($insert_id > 0)
		{
			return "done";
		}
		else
		{
			return $this->db->error();
		}
	}

/*----- edit cost center -----*/
	function edit_costcenter()
	{

		$data['description'] = $this->cost_center_name;
		$update_costcenter = $this->mysql->where('lindex', $this->costcenterid)->update($this->table, $data);
		if($update_costcenter)
		{
			return "update";
		}
		else
		{
			return $this->mysql->error();
		}
	}


	function get_list()
	{
		return $this->mysql->select('*')->from('newcostcentres')->where([ 'lindex' => $this->costcenterid ])->get()->first_row('array');
	}
	
	
	function get_contract()
	{
		return $this->mysql->select('lindex')->from('newcontractareas')->where(['lindex' => $this->costcenterid ])->get()->first_row('array');	
	}

/*--- change status of cost center ---*/
	function update_status()
	{
		$data['status'] = $this->status;
		$update_status = $this->mysql->where([ 'lindex' => $this->costcenterid ])->update($this->table, $data);
		if( $update_status )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}

}