<?php

Class Users extends CI_Model
{
	public $username;
	public $password;
	public $number;
	public $device_id;
	public $device_token;
	public $device_type;
	public $ref;
	public $ref_id;
	public $lat;
	public $long;
	public $token;
	public $status;
	public $otp;
	public $app_type;

	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->mysql = $this->load->database('mysql',true);

	}


	function get_login_asm()
	{
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from CREATEAPPLOGIN('".$this->number."','".$this->otp."')")->result_array();
	}

	function get_login()
	{
		$query_mysql =  $this->mysql->select('*')->from('operators')->where([ 'number' => trim($this->number) ])->get()->first_row('array');
		if(  $query_mysql['ref']!="" )
		{
			return $this->mysql->select('ref,lindex, loginname,fullname, accesslevel,number,imei_no, otp, is_verified, lastin, lastout, custref, depot,type, logintype, costcentre , contractarea, office, emailaddress, createdate, termsagree')->from('operators')->where([ 'number' => trim($this->number)])->get()->first_row('array');
		}
	}

	// Update OTP
	function update_otp()
	{
		$data['otp'] = $this->otp;
		$this->mysql->where('ref', $this->ref);
		$this->mysql->update('operators', $data);
	}


	function verified_otp_asm()
	{
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from VERIFYAPPUSER('".$this->number."', '".$this->device_type."', '".$this->device_token."', '".$this->device_id."', '".$this->otp."', '".$this->app_type."') ")->result_array();
	}

	function verified_otp()
	{
		$get_result = $this->mysql->select('ref')->from('operators')->where([ 'number' => trim($this->number), 'otp' => $this->otp ])->get()->first_row('array');
		if( $get_result['ref'] )
		{
			$data['device_token'] = $this->device_token;
			$data['device_type'] = $this->device_type;
			$data['is_verified'] = '1';
			$data['lastin'] = date( 'Y-m-d H:i:s' );
			$this->mysql->where('ref', $get_result['ref'])->update('operators', $data);
		}

		return $get_result;
	}

	// update token of logged in user
	function update_user_token()
	{
		$data['token'] = $this->token;
		$data['lastin'] = date( 'Y-m-d H:i:s' );
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);
	}

	function user_logout()
	{
		$data['token'] = " ";
		$data['lastout'] = date('Y-m-d H:i:s');
		$data['otp'] = "0";
		$data['is_verified'] = "0";
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);

	}

	function update_location()
	{
		$data['ref_id'] = $this->ref_id;
		$data['lat'] = $this->lat;
		$data['long'] = $this->long;
		$data['status'] = $this->status;
		$data['create_date'] = date('Y-m-d h:i:s');
		$this->mysql->insert('location', $data);
		return $insert_id = $this->mysql->insert_id();
	}


	function get_detail(){
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from WEB_GETALARMCONTACTS(000010)")->result_array();
	}

	function escalation(){
		$this->testasm = $this->load->database('test',true);
		$query = $this->testasm->query("select * from EXPORT_PORTAL_NUMBERS2")->result_array();
		debug($query );
		echo "Total rows: ".count($query);
		for( $i=0; $i<count($query); $i++ ){
			$data['ref'] = $query[$i]['PROPERTYREF'];
			$data['number	'] = $query[$i]['PHONENUMBER'];
			$data['loginname'] = $query[$i]['FORENAME'];
			$data['fullname'] = $query[$i]['FORENAME'];
			$data['surname	'] = $query[$i]['SURNAME'];
			$this->mysql->insert( 'export_portal_numbers' ,$data );
		}
		if( $this->mysql->insert_id() > 0 ){
			echo "<br>Database Synced";
		}
	}

	function get_operator_lindex($number){
		$query = $this->mysql->select('ref')->from('export_portal_numbers')->where('number',$number)->get();
		foreach( $query->result_array() as $row )
		{
			return $row['ref'];
		}
	}

	function escalation_detail($lindex){
		//$this->testasm = $this->load->database('test',true);
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from WEB_GETALARMCONTACTS(".$lindex.")")->result_array();
	}

	// function get_operator_lindex($lindex){
	// 	return $query = $this->mysql->select('*')->from('export_portal_numbers')->where('ref',$lindex)->get()->first_row('array');
	// }

	function get_phone_number($lindex)
	{
		return $this->mysql->select('*')->from('export_portal_numbers')->where('ref', $lindex)->get()->first_row();
	}

	function get_operator_detail($lindex)
	{
		return $this->mysql->select('*')->from('operators')->where('lindex', $lindex)->get()->first_row();
		echo $this->mysql->last_query();
	}

}
