<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('users');
		$this->load->library('jwt');
		$this->load->library('jres');
		$this->load->library('sms');
		$this->load->model('signal');
	}

	function index()
	{
		$this->login();
	}

	function login_asm()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$otp_code = rand(0000,9999);

			$this->users->number = $number;
			$this->users->otp = $otp_code;

			$login = $this->users->get_login_asm();


			if( $login[0]['STATUS'] <> 0 )
			{

				//$msg_id = $this->sms->send_sms($number,$otp_code);
				$msg_id = $this->sms->send_sms('918968163577',$otp_code);
				$msg_report = $this->sms->check_sms_report($msg_id);
			}

			header('content-type:application/json');
			echo json_encode($login);
		}
	}

	function new_login()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$otp_code = rand(0000,9999);


			$this->users->number = $number;
			$this->users->otp = $otp_code;

			$login = $this->users->get_login_asm();

			if( $login[0]['STATUS'] <> 0 )
			{
				$msg_id = $this->sms->send_sms($number,$otp_code);
				$msg_report = $this->sms->check_sms_report($msg_id);
			}

			header('content-type:application/json');
			echo json_encode($login);
		}
	}

	function login()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == '0' )
		{
			$number = '44'.substr($number, 1);
		}

		//if( $number == "447599804885" || $number == "918826622177" )
		if( $number == "447599804885")
		{
			$otp_code = "3456";
			$msg_report = "Sent";
			$this->jres->successotp($otp_code, $msg_report);
		}
		else
		{
			if( !isset($number) || $number=="" )
				{
					$msg= 'number cant be empty';
		 			$this->jres->failure($msg);
					exit;
				}
				else
				{
					$this->users->number = $number;
					$login = $this->users->get_login();
					if(empty($login))
						{
							$msg = 'Wrong Phone Number';
				 			$this->jres->failure($msg);
						}
						else
						{
							//echo '1';
							$otp_code = rand(0000,9999);
							//update otp to database
							$this->users->otp = $otp_code ;
		 					$this->users->ref = $login['ref'];
							$update_otp = $this->users->update_otp();
							//
							//debug($otp_code);
							$msg_id = $this->sms->send_sms($number,$otp_code);
							$msg_report = $this->sms->check_sms_report($msg_id);
		 					//sleep(1);
		 					$this->jres->successotp($otp_code);
							//sleep(2);
							// Sending OTP
		 				}
				}
		}

	}



	function verify_otp_asm()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);


		if( !isset($number) || $number=="" )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else if( !isset($otp) || $otp=="" )
		{
			$msg= 'otp cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->number = $number;
			$this->users->otp = $otp;
			$this->users->device_type = $device_type;
			$this->users->device_token = $device_token;
			$this->users->device_id = $device_id;
			$this->users->app_type = $app_type;
			$verified_otp = $this->users->verified_otp_asm();
			//debug($verified_otp[0],1);
			header('content-type:application/json');
			echo json_encode($verified_otp[0]);

		}
	}


	function verify_otp()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);
		if( !isset($device_id) || $device_id=="" )
			{
				$device_id = '0';
			}

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( $otp == "3456" )
		{
			//echo "1";
			$this->users->number = $number;
			$verified_login = $this->users->get_login();
			//debug($verified_login,1);
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			//echo "2";
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				//echo "3";
				$this->users->number = $number;
				$login = $this->users->get_login();

				if(empty($login))
					{
						//echo "4";
						$msg = 'Wrong Phone Number11';
			 			$this->jres->failure($msg);
					}
					else
					{
						$this->users->number = $number;
						$this->users->otp = $otp;
						$this->users->device_type = $device_type;
						$this->users->device_token = $device_token;
						$this->users->device_id = $device_id;
						$this->users->app_type = $app_type;
						$verified_otp = $this->users->verified_otp();
						////debug($verified_otp,1);
						if( !empty($verified_otp) )
						{
							$this->users->ref = $login['ref'];
							$this->users->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->users->update_user_token();
							if( !empty($update_user_token) )
							{
								$verified_login = $this->users->get_login();
								//var_dump($verified_login);
								$this->jres->success($verified_login,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	}


	function logout()
	{
		$ref = $this->input->get('ref',true);
		if( !isset($ref) || $ref=="" )
		{
			$msg= 'login id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $ref;
			$logout = $this->users->user_logout();
			if( !empty($logout) )
				{
					$this->jres->successotp('','logout');
				}
				else
				{
					$this->jres->failure('invalid login id');
				}
		}
	}

	function location_update()
	{
		//echo json_encode([ 'msg' => 'asm' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		//$ref_id = '004862';
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($lat) || $lat=="" )
		{
			// $msg= 'lat cant be empty';
 		// 	$this->jres->failure($msg);
			// exit;
			$lat = '0.0000000';
		}
		if( !isset($long) || $long=="" )
		{
			// $msg= 'long cant be empty';
 		// 	$this->jres->failure($msg);
			// exit;
			$long = '0.0000000';
		}


		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/
			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){

				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , '46.255.118.104' , 5055))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
							if( $errormsg == 'Connection timed out' )
						    {
						    	socket_close($sock);
						    }
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}else{
							
						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    $data['error_msg'] = "Could not send data: [$errorcode] $errormsg";
						    $socket_log = $this->signal->socket_log($data);
						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}
						else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
				}
			}
		}

	}

	function new_location_update()
	{
		//echo json_encode([ 'msg' => 'sentinel' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}elseif( !isset($lat) || $lat=="" )
		{
			$msg= 'lat cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($long) || $long=="" )
		{
			$msg= 'long cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/

				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , '81.142.251.60' , 8731))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Could not connect: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}
						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						//$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
		}

	}

	function get_setting_lwd()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_lwd_setting = $this->users->get_lwd_setting();
			if($get_lwd_setting)
			{
				$this->jres->success( $get_lwd_setting );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function check_signal()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_signal_status = $this->users->get_signal_status();
			if($get_signal_status)
			{
				if($get_signal_status['signal_kill'] == '0')
				{
					$get_signal_status['signal_kill'] = 'signal on';
				}
				if($get_signal_status['signal_kill'] == '1')
				{
					$get_signal_status['signal_kill'] = 'signal off';
				}
				$this->jres->success( $get_signal_status );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function sms_test()
	{
		echo $msg_id = $this->sms->send_sms('918826622177','1111');
		echo '------<br>';
		echo $this->sms->check_sms_report($msg_id);
	}

	function new_detail(){
		$response = $this->users->get_detail();
		debug($response);
	}

	function new_operators(){
		$escalation = $this->users->escalation();
		debug($escalation);
	}

	function verify_otp_operators()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);
		if( !isset($device_id) || $device_id=="" )
			{
				$device_id = '0';
			}

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( $otp == "3456" )
		{
			//echo "1";
			$this->users->number = $number;
			$verified_login = $this->users->get_login();
			//debug($verified_login,1);
			// $get_operator_lindex = $this->users->get_operator_lindex($number);
			if( empty($verified_login['lindex']) || $verified_login['lindex'] == '0'  )
			{
				$verified_login['lindex'] = "58238578";
			}
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			//echo "2";
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				//echo "3";
				$this->users->number = $number;
				$login = $this->users->get_login();

				if(empty($login))
					{
						//echo "4";
						$msg = 'Wrong Phone Number11';
			 			$this->jres->failure($msg);
					}
					else
					{
						$this->users->number = $number;
						$this->users->otp = $otp;
						$this->users->device_type = $device_type;
						$this->users->device_token = $device_token;
						$this->users->device_id = $device_id;
						$this->users->app_type = $app_type;
						$verified_otp = $this->users->verified_otp();
						////debug($verified_otp,1);
						if( !empty($verified_otp) )
						{
							$this->users->ref = $login['ref'];
							$this->users->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->users->update_user_token();
							if( !empty($update_user_token) )
							{
								$verified_login = $this->users->get_login();
								if( empty($verified_login['lindex']) || $verified_login['lindex'] == '0'  )
								{
									$verified_login['lindex'] = "58238578";
								}

								//var_dump($verified_login);
								$this->jres->success($verified_login,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	} // verify otp operator

	function get_escalation(){
		$lindex = $this->input->post('lindex');
		if( !isset($lindex) || $lindex=="" )
		{
			$lindex= 'Lindex is empty';
 			$this->jres->failure($lindex);
			exit;
		}
		else
		{
			$escalation_detail = $this->users->escalation_detail($lindex);
			if(!empty($escalation_detail))
			{
				for( $i=0; $i<count( $escalation_detail ); $i++ )
				{
					if( $escalation_detail[$i]['OTHER'] == '' || empty($escalation_detail[$i]['OTHER']) )
					{
						$escalation_detail[$i]['OTHER'] = '0';
					}
					if( $escalation_detail[$i]['PAGER'] == '' || empty($escalation_detail[$i]['PAGER']) )
					{
						$escalation_detail[$i]['PAGER'] = '0';
					}
					if( $escalation_detail[$i]['EMAIL'] == '' || empty($escalation_detail[$i]['EMAIL']) )
					{
						$escalation_detail[$i]['EMAIL'] = '0';
					}
					if( $escalation_detail[$i]['HOMETELEPHONE'] == '' || empty($escalation_detail[$i]['HOMETELEPHONE']) )
					{
						$escalation_detail[$i]['HOMETELEPHONE'] = '0';
					}
					if( $escalation_detail[$i]['MOBILE'] == '' || empty($escalation_detail[$i]['MOBILE']) )
					{
						$escalation_detail[$i]['MOBILE'] = '0';
					}

					if( $escalation_detail[$i]['SITEINDEX'] == '' || empty($escalation_detail[$i]['SITEINDEX']) )
					{
						$escalation_detail[$i]['SITEINDEX'] = '0';
					}
					if( $escalation_detail[$i]['CONTACTINDEX'] == '' || empty($escalation_detail[$i]['CONTACTINDEX']) )
					{
						$escalation_detail[$i]['CONTACTINDEX'] = '0';
					}
					if( $escalation_detail[$i]['PRIORITY'] == '' || empty($escalation_detail[$i]['PRIORITY']) )
					{
						$escalation_detail[$i]['PRIORITY'] = '0';
					}
					if( $escalation_detail[$i]['FULLNAME'] == '' || empty($escalation_detail[$i]['FULLNAME']) )
					{
						$escalation_detail[$i]['FULLNAME'] = '0';
					}
					if( $escalation_detail[$i]['CTYPE'] == '' || empty($escalation_detail[$i]['CTYPE']) )
					{
						$escalation_detail[$i]['CTYPE'] = '0';
					}
					if( $escalation_detail[$i]['DESCRIPTION'] == '' || empty($escalation_detail[$i]['DESCRIPTION']) )
					{
						$escalation_detail[$i]['DESCRIPTION'] = '0';
					}
					if( $escalation_detail[$i]['BUSINESSTELEPHONE'] == '' || empty($escalation_detail[$i]['BUSINESSTELEPHONE']) )
					{
						$escalation_detail[$i]['BUSINESSTELEPHONE'] = '0';
					}

				}
				$this->jres->success($escalation_detail);
			}
			else
			{
				$this->jres->failure('no data available');
			}
		}
	}

	function escalation_mail()
	{

		$subject = $this->input->post('subject');

		if(!empty($subject)){

		//$escalation_detail = json_decode($this->input->post('parameter',true),true);
		$escalation_detail = json_decode($this->input->post('parameter'),true);
		//debug($escalation_detail,1);
		//$escalation_detail = $this->input->post('parameter');
		//debug($escalation_detail,1);
		//print_r($escalation_detail); exit;
		//debug($this->input->post('parameter')); exit;

    $lindex = '';
    $username = '';
    $number = '';
    for( $m=0; $m<count($escalation_detail); $m++ )
		{
			 $lindex = $escalation_detail[0]['SITEINDEX'];
		}

    //get phone number of operator
    // if( !empty($lindex) ){
		  // $get_phone_number = $this->users->get_phone_number($lindex);
    // }else{
      // $this->jres->failure('lindex or siteindex is not defined');
      // exit;
    // }
	  //debug($get_detail,1);

    //get username and phone number
    if(!empty($lindex)){
      $get_detail = $this->users->get_operator_detail($lindex);
	  //debug($get_detail,1);
        if(!empty($get_detail))
        {
          $username = $get_detail->loginname;
          $number = $get_detail->number;
        }
    }else{
      $this->jres->failure('wrong phone number or data not available');
      exit;
    }

		//$escalation_detail = $this->users->escalation_detail($lindex);
		//$get_operator_lindex = $this->users->get_operator_lindex($lindex);
			//debug($escalation_detail);
		$array = '<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
	<head>
		<!-- NAME: 1 COLUMN -->
		<!--[if gte mso 15]>
		<xml>
			<o:OfficeDocumentSettings>
			<o:AllowPNG/>
			<o:PixelsPerInch>96</o:PixelsPerInch>
			</o:OfficeDocumentSettings>
		</xml>
		<![endif]-->
		<meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
		<title>*HS2 Escalation Change Request *CUSTOMER_NAME* *PHONE* *</title>

    <style type="text/css">
		p{
			margin:10px 0;
			padding:0;
		}
		table{
			border-collapse:collapse;
		}
		h1,h2,h3,h4,h5,h6{
			display:block;
			margin:0;
			padding:0;
		}
		img,a img{
			border:0;
			height:auto;
			outline:none;
			text-decoration:none;
		}
		body,#bodyTable,#bodyCell{
			height:100%;
			margin:0;
			padding:0;
			width:100%;
		}
		.mcnPreviewText{
			display:none !important;
		}
		#outlook a{
			padding:0;
		}
		img{
			-ms-interpolation-mode:bicubic;
		}
		table{
			mso-table-lspace:0pt;
			mso-table-rspace:0pt;
		}
		.ReadMsgBody{
			width:100%;
		}
		.ExternalClass{
			width:100%;
		}
		p,a,li,td,blockquote{
			mso-line-height-rule:exactly;
		}
		a[href^=tel],a[href^=sms]{
			color:inherit;
			cursor:default;
			text-decoration:none;
		}
		p,a,li,td,body,table,blockquote{
			-ms-text-size-adjust:100%;
			-webkit-text-size-adjust:100%;
		}
		.ExternalClass,.ExternalClass p,.ExternalClass td,.ExternalClass div,.ExternalClass span,.ExternalClass font{
			line-height:100%;
		}
		a[x-apple-data-detectors]{
			color:inherit !important;
			text-decoration:none !important;
			font-size:inherit !important;
			font-family:inherit !important;
			font-weight:inherit !important;
			line-height:inherit !important;
		}
		#bodyCell{
			padding:10px;
		}
		.templateContainer{
			max-width:600px !important;
		}
		.ul_li li { list-style: none }
		a.mcnButton{
			display:block;
		}
		.mcnImage,.mcnRetinaImage{
			vertical-align:bottom;
		}
		.mcnTextContent{
			word-break:break-word;
		}
		.mcnTextContent img{
			height:auto !important;
		}
		.mcnDividerBlock{
			table-layout:fixed !important;
		}
		body,#bodyTable{
			/*@editable*/background-color:#FAFAFA;
		}

		#bodyCell{
			/*@editable*/border-top:0;
		}
	/*
	@tab Page
	@section Email Border
	@tip Set the border for your email.
	*/
		.templateContainer{
			/*@editable*/border:0;
		}
	/*
	@tab Page
	@section Heading 1
	@tip Set the styling for all first-level headings in your emails. These should be the largest of your headings.
	@style heading 1
	*/
		h1{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:26px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 2
	@tip Set the styling for all second-level headings in your emails.
	@style heading 2
	*/
		h2{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:22px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 3
	@tip Set the styling for all third-level headings in your emails.
	@style heading 3
	*/
		h3{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:20px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}
	/*
	@tab Page
	@section Heading 4
	@tip Set the styling for all fourth-level headings in your emails. These should be the smallest of your headings.
	@style heading 4
	*/
		h4{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:18px;
			/*@editable*/font-style:normal;
			/*@editable*/font-weight:bold;
			/*@editable*/line-height:125%;
			/*@editable*/letter-spacing:normal;
			/*@editable*/text-align:left;
		}

		#templatePreheader{
			/*@editable*/background-color:#FAFAFA;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:9px;
			/*@editable*/padding-bottom:9px;
		}

		#templatePreheader .mcnTextContent,#templatePreheader .mcnTextContent p{
			/*@editable*/color:#656565;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:12px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templatePreheader .mcnTextContent a,#templatePreheader .mcnTextContent p a{
			/*@editable*/color:#656565;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateHeader{
			/*@editable*/background-color:#FFFFFF;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:9px;
			/*@editable*/padding-bottom:0;
		}

		#templateHeader .mcnTextContent,#templateHeader .mcnTextContent p{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:16px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templateHeader .mcnTextContent a,#templateHeader .mcnTextContent p a{
			/*@editable*/color:#2BAADF;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateBody{
			/*@editable*/background-color:#FFFFFF;
			/*@editable*/background-image:none;
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:cover;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:2px solid #EAEAEA;
			/*@editable*/padding-top:0;
			/*@editable*/padding-bottom:9px;
		}

		#templateBody .mcnTextContent,#templateBody .mcnTextContent p{
			/*@editable*/color:#202020;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:16px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:left;
		}

		#templateBody .mcnTextContent a,#templateBody .mcnTextContent p a{
			/*@editable*/color:#2BAADF;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}

		#templateFooter{
			/*@editable*/background-color:#fafafa;
			/*@editable*/background-image:url("https://gallery.mailchimp.com/63ca19c645f0b2816eaff297d/images/e4b05e3d-72a1-4e86-ae58-9d0200e63a44.png");
			/*@editable*/background-repeat:no-repeat;
			/*@editable*/background-position:center;
			/*@editable*/background-size:auto;
			/*@editable*/border-top:0;
			/*@editable*/border-bottom:0;
			/*@editable*/padding-top:10px;
			/*@editable*/padding-bottom:10px;
		}
		#templateFooter .mcnTextContent,#templateFooter .mcnTextContent p{
			/*@editable*/color:#656565;
			/*@editable*/font-family:Helvetica;
			/*@editable*/font-size:12px;
			/*@editable*/line-height:150%;
			/*@editable*/text-align:center;
		}

		#templateFooter .mcnTextContent a,#templateFooter .mcnTextContent p a{
			/*@editable*/color:#0909a7;
			/*@editable*/font-weight:normal;
			/*@editable*/text-decoration:underline;
		}
	@media only screen and (min-width:768px){
		.templateContainer{
			width:600px !important;
		}

}	@media only screen and (max-width: 480px){
		body,table,td,p,a,li,blockquote{
			-webkit-text-size-adjust:none !important;
		}

}	@media only screen and (max-width: 480px){
		body{
			width:100% !important;
			min-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		#bodyCell{
			padding-top:10px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnRetinaImage{
			max-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImage{
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnCartContainer,.mcnCaptionTopContent,.mcnRecContentContainer,.mcnCaptionBottomContent,.mcnTextContentContainer,.mcnBoxedTextContentContainer,.mcnImageGroupContentContainer,.mcnCaptionLeftTextContentContainer,.mcnCaptionRightTextContentContainer,.mcnCaptionLeftImageContentContainer,.mcnCaptionRightImageContentContainer,.mcnImageCardLeftTextContentContainer,.mcnImageCardRightTextContentContainer,.mcnImageCardLeftImageContentContainer,.mcnImageCardRightImageContentContainer{
			max-width:100% !important;
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnBoxedTextContentContainer{
			min-width:100% !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupContent{
			padding:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnCaptionLeftContentOuter .mcnTextContent,.mcnCaptionRightContentOuter .mcnTextContent{
			padding-top:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardTopImageContent,.mcnCaptionBottomContent:last-child .mcnCaptionBottomImageContent,.mcnCaptionBlockInner .mcnCaptionTopContent:last-child .mcnTextContent{
			padding-top:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardBottomImageContent{
			padding-bottom:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupBlockInner{
			padding-top:0 !important;
			padding-bottom:0 !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageGroupBlockOuter{
			padding-top:9px !important;
			padding-bottom:9px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnTextContent,.mcnBoxedTextContentColumn{
			padding-right:18px !important;
			padding-left:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcnImageCardLeftImageContent,.mcnImageCardRightImageContent{
			padding-right:18px !important;
			padding-bottom:0 !important;
			padding-left:18px !important;
		}

}	@media only screen and (max-width: 480px){
		.mcpreview-image-uploader{
			display:none !important;
			width:100% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 1
	@tip Make the first-level headings larger in size for better readability on small screens.
	*/
		h1{
			/*@editable*/font-size:22px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 2
	@tip Make the second-level headings larger in size for better readability on small screens.
	*/
		h2{
			/*@editable*/font-size:20px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 3
	@tip Make the third-level headings larger in size for better readability on small screens.
	*/
		h3{
			/*@editable*/font-size:18px !important;
			/*@editable*/line-height:125% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Heading 4
	@tip Make the fourth-level headings larger in size for better readability on small screens.
	*/
		h4{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Boxed Text
	@tip Make the boxed text larger in size for better readability on small screens. We recommend a font size of at least 16px.
	*/
		.mcnBoxedTextContentContainer .mcnTextContent,.mcnBoxedTextContentContainer .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){

		#templatePreheader{
			/*@editable*/display:block !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Preheader Text
	@tip Make the preheader text larger in size for better readability on small screens.
	*/
		#templatePreheader .mcnTextContent,#templatePreheader .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Header Text
	@tip Make the header text larger in size for better readability on small screens.
	*/
		#templateHeader .mcnTextContent,#templateHeader .mcnTextContent p{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Body Text
	@tip Make the body text larger in size for better readability on small screens. We recommend a font size of at least 16px.
	*/
		#templateBody .mcnTextContent,#templateBody .mcnTextContent p{
			/*@editable*/font-size:16px !important;
			/*@editable*/line-height:150% !important;
		}

}	@media only screen and (max-width: 480px){
	/*
	@tab Mobile Styles
	@section Footer Text
	@tip Make the footer content text larger in size for better readability on small screens.
	*/
		#templateFooter .mcnTextContent,#templateFooter .mcnTextContent p{
			/*@editable*/font-size:14px !important;
			/*@editable*/line-height:150% !important;
		}

}</style></head>
    <body>
		<!--*|IF:MC_PREVIEW_TEXT|*-->
		<!--[if !gte mso 9]><!----><span class="mcnPreviewText" style="display:none; font-size:0px; line-height:0px; max-height:0px; max-width:0px; opacity:0; overflow:hidden; visibility:hidden; mso-hide:all;">*|MC_PREVIEW_TEXT|*</span><!--<![endif]-->
		<!--*|END:IF|*-->
        <center>
            <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
                <tr>
                    <td align="center" valign="top" id="bodyCell">
                        <!-- BEGIN TEMPLATE // -->
						<!--[if (gte mso 9)|(IE)]>
						<table align="center" border="0" cellspacing="0" cellpadding="0" width="600" style="width:600px;">
						<tr>
						<td align="center" valign="top" width="600" style="width:600px;">
						<![endif]-->
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="templateContainer">
                            <tr>
                                <td valign="top" id="templatePreheader"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding: 0px 18px 9px; text-align: center;">

                            <a href="*|ARCHIVE|*" target="_blank">View this email in your browser</a>
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateHeader"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnImageBlock" style="min-width:100%;">
    <tbody class="mcnImageBlockOuter">
            <tr>
                <td valign="top" style="padding:0px" class="mcnImageBlockInner">
                    <table align="left" width="100%" border="0" cellpadding="0" cellspacing="0" class="mcnImageContentContainer" style="min-width:100%;">
                        <tbody><tr>
                            <td class="mcnImageContent" valign="top" style="padding-right: 0px; padding-left: 0px; padding-top: 0; padding-bottom: 0; text-align:center;">


                                        


                            </td>
                        </tr>
                    </tbody></table>
                </td>
            </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateBody"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">

                            <br>
Hello,<br>
<br>
 '.$username.' with Phone Number '.$number.' has requested to change their escalation details. Following are the requested changes:
<ol class="ul_li">';
for( $i = 0; $i<count($escalation_detail); $i++ )
{
	$array .= '<li> FULLNAME: '.$escalation_detail[$i]['FULLNAME'].'</li>';
	$array .= '<li> EMAIL: '.$escalation_detail[$i]['EMAIL'].'</li>';
	$array .= '<li> MOBILE: '.$escalation_detail[$i]['MOBILE'].'</li>';
	$array .= '<li> BUSINESSTELEPHONE: '.$escalation_detail[$i]['BUSINESSTELEPHONE'].'</li>';
	$array .= '<li> HOMETELEPHONE: '.$escalation_detail[$i]['HOMETELEPHONE'].'</li>';
	$array .= '<li> PRIORITY: '.$escalation_detail[$i]['PRIORITY'].'</li>';
	$array .= '<br>';
}

		// $array .= '<li>'.$escalation_detail['HOMETELEPHONE'].'</li>';
		// $array .= '<li>'.$escalation_detail['SITEINDEX'].'</li>';
		// $array .= '<li>'.$escalation_detail['EMAIL'].'</li>';
		// $array .= '<li>'.$escalation_detail['FULLNAME'].'</li>';
		// $array .= '<li>'.$escalation_detail['BUSINESSTELEPHONE'].'</li>';
		// $array .= '<li>'.$escalation_detail['MOBILE'].'</li>';
$array .= '</ol>
Thanks,<br>
	Escalation Automailer.&nbsp;
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                            <tr>
                                <td valign="top" id="templateFooter"><table border="0" cellpadding="0" cellspacing="0" width="100%" class="mcnTextBlock" style="min-width:100%;">
    <tbody class="mcnTextBlockOuter">
        <tr>
            <td valign="top" class="mcnTextBlockInner" style="padding-top:9px;">
              	<!--[if mso]>
				<table align="left" border="0" cellspacing="0" cellpadding="0" width="100%" style="width:100%;">
				<tr>
				<![endif]-->

				<!--[if mso]>
				<td valign="top" width="600" style="width:600px;">
				<![endif]-->
                <table align="left" border="0" cellpadding="0" cellspacing="0" style="max-width:100%; min-width:100%;" width="100%" class="mcnTextContentContainer">
                    <tbody><tr>

                        <td valign="top" class="mcnTextContent" style="padding-top:0; padding-right:18px; padding-bottom:9px; padding-left:18px;">

                            <br>
<span style="color:#F0FFFF"><em>Copyright © *|CURRENT_YEAR|* *|LIST:COMPANY|*, All rights reserved.</em></span><br>
<br>
<span style="color:#FFFFFF">Want to change how you receive these emails?</span><br>
<span style="color:#FFFFFF">You can </span><a href="*|UPDATE_PROFILE|*"><span style="color:#000080">update your preferences</span></a><span style="color:#000080"> </span><span style="color:#FFFFFF">or</span><span style="color:#000080"> </span><a href="*|UNSUB|*"><span style="color:#000080">unsubscribe from this list</span></a><span style="color:#000080">.</span><br>
&nbsp;
                        </td>
                    </tr>
                </tbody></table>
				<!--[if mso]>
				</td>
				<![endif]-->

				<!--[if mso]>
				</tr>
				</table>
				<![endif]-->
            </td>
        </tr>
    </tbody>
</table></td>
                            </tr>
                        </table>
						<!--[if (gte mso 9)|(IE)]>
						</td>
						</tr>
						</table>
						<![endif]-->
                        <!-- // END TEMPLATE -->
                    </td>
                </tr>
            </table>
        </center>
    </body>
</html>';
// Always set content-type when sending HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// if( !empty($escalation_detail) ){
		// // send email
		// 	mail("jack@iivo.co.uk",$subject,$array,$headers);
		// 	if(mail("lwpsupport@orbisprotect.com",$subject,$array,$headers))
		// 	//if(mail("jack@iivo.co.uk",$subject,$array,$headers))
		// 	{
		// 		//mail("sunil@iivo.io",$subject,$array,$headers);
		// 		$this->jres->success([],'mail send');
		// 	}
		// 	else{
		// 		$this->jres->failure('mail send fail');
		// 	}
		// }else
		// {
		// 	$this->jres->failure('no data available');
		// }

		if( !empty($escalation_detail) ){
			$this->load->library('email');
            //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            $this->email->from('no-reply@orbisprotect.com', 'Escalation Emailer');
            $this->email->to('jack@iivo.co.uk');
			$this->email->to('jatin@iivo.io');  
            $this->email->to('arcadmin@orbisprotect.com');  
            //$this->email->to('arcadmin@orbisprotect.com');						
            $this->email->subject($subject);
            $this->email->message($array);
            //$send_mail = $this->email->send();
            if($this->email->send())
			{
				//mail("sunil@iivo.io",$subject,$array,$headers);
				$this->jres->success([],'mail send');
			}
			else{
				$this->jres->failure('mail send fail');
			}
        }
        else
		{
			$this->jres->failure('no data available');
		}
	}else{
		$this->jres->failure('subject empty');
	}

	}

	function test_mail(){
			$this->load->library('email');
            //$this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
            $this->email->from('no-reply@iivo.io', 'Eversmart');
            //$this->email->to($this->input->post('email'));
            $this->email->to('jatin@iivo.io');
            $this->email->subject('Signup Confirmation');
            $this->email->message("thanks");
            $this->email->send();
	}

	function location_update_sentinal(){
			//echo json_encode([ 'msg' => 'asm' ]);exit;
		$ref_id = $this->input->post('ref_id',true);
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}elseif( !isset($lat) || $lat=="" )
		{
			$msg= 'lat cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($long) || $long=="" )
		{
			$msg= 'long cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($number) || $number=="0" || $number == 0 || $number == '' )
		{
			$msg= 'number cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			/*$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){*/
			$checkNumberBlock = $this->signal->checkNumberBlock($number);
			if( empty($checkNumberBlock->id) ){

				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}

						if(!socket_connect($sock , '89.197.154.25' , 5051))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
							if( $errormsg == 'Connection timed out' )
						    {
						    	socket_close($sock);
						    }
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}else{
							
						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;

						$checksum = md5($signals);

						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;

						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);

						    $data['error_msg'] = "Could not send data: [$errorcode] $errormsg";
						    $socket_log = $this->signal->socket_log($data);
						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}
						else
						{
							$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
							$data['DateTime'] = $DateTime;
							$data['IMEI'] = $IMEI;
							$data['number'] = $number;
							$data['messageType'] = $messageType;
							$data['lat'] = $lat;
							$data['long'] = $long;
							$data['posdatatime'] = $posdatatime;
							$data['postype'] = $postype;
							$data['status'] = $status;
							$data['interval'] = $interval;
							$data['speed'] = $speed;
							$data['checksum'] = $checksum;
							$report_trigger = $this->signal->asm_trigger($data);
						}
						$this->jres->success_message('Signals send successfully');
						socket_close($sock);

					//}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
				}
			}
		}
	}

}
