<?php

Class Users extends CI_Model
{
	
	public function insert_user_data($token, $username, $password, $googleFirebaseToken) {
		
		$checkUser = $this->db->select('*')->from('mobile_app_users')->where(['user_name' => encrypt_string($username), 'user_password' => encrypt_string($password)])->get()->first_row('array');
		
		
		
		
		if ($checkUser) {
			
			$data['jwt_token']	  = $token;
			$data['login_status'] = 'true';
			$data['google_firebase_token'] 	= $googleFirebaseToken;
			
			$this->db->where('user_id', $checkUser['user_id'])->update('mobile_app_users',$data);
			
			$insert_id = $checkUser['user_id'] ;
			
		} else {
			$data['jwt_token']     			= $token;
			$data['user_name'] 	   			= encrypt_string($username);
			$data['user_password'] 			= encrypt_string($password);
			$data['google_firebase_token'] 	= $googleFirebaseToken;
			$data['auto_arm_disarm_status'] = "true" ;
			$data['disarm_range'] 			= "100" ;
			$data['disarm_time'] 			= "60" ;
			
			$query 	   = $this->db->insert('mobile_app_users', $data);
			$insert_id = $this->db->insert_id();
		}
		
		$getUserData = $this->db->select('*')->from('mobile_app_users')->where('user_id',$insert_id)->get()->first_row('array');
		
		return $getUserData ;
	}
	
	public function delete_user_data($user_id) {
		
		 $checkUser = $this->db->select('*')->from('mobile_app_users')->where('user_id',$user_id)->get()->first_row('array');
		 
		 if($checkUser) {
			 // $this->db->where('user_id',$user_id)->delete('mobile_app_users');
			 $data['login_status'] = "false" ;
			 $this->db->where('user_id', $user_id)->update('mobile_app_users',$data);
			 $message = "User logged out." ;
			
		 } else {
			   $message = "No data found." ;
		 }
		 
		 return $message ;
	}
	
	
	public function chek_user_authentication($jwtToken, $user_id) {
		 $checkUser = $this->db->select('*')->from('mobile_app_users')->where(['user_id' => $user_id, 'jwt_token' => $jwtToken])->get()->first_row('array');
		 return $checkUser;
	}
	
	public function insertDisarmedSites($data){
		
		$newData['NAME'] = $data['NAME'];
		$newData['SERIALNO'] = $data['SERIALNO'];
		$newData['ADDRESS_POSTCODE'] = $data['ADDRESS_POSTCODE'];
		$newData['NETADDR2'] = $data['NETADDR2'];
		$newData['USER_ID'] = $data['USER_ID'];
		
		$query 	   = $this->db->insert('disarmed_sites', $newData);
	}
	
	public function checkSiteDisarmed($serialNumber, $userId) {
		
		 $checkSiteDisarmed = $this->db->select('*')->from('disarmed_sites')->where(['USER_ID' => $userId, 'SERIALNO' => $serialNumber])->get()->first_row('array');
		 
		 if ($checkSiteDisarmed) {
			return "YES" ;
		 } else {
			 return "NO" ;
		 }
	}
	
	
	public function deleteDisarmedSites($serialNumber, $userId) {
		
		$this->db->where(['USER_ID' => $userId, 'SERIALNO' => $serialNumber])->delete('disarmed_sites');
	
	}
	
	
	public function updateAutoArmDisarm($data, $userId) {
		
		return $this->db->where('user_id', $userId)->update('mobile_app_users',$data);
	}
	
	public function log_putItemOnTestAutomatically($latitudeFrom, $longitudeFrom, $userId) {
		$data['latitude']  =  $latitudeFrom;
		$data['longitude'] =  $longitudeFrom;
		$data['user_id']   =  $userId;
		
		$query 	   = $this->db->insert('log_putItemOnTestAutomatically', $data);
	}
	
	public function checkSiteAlreadyExists($serialNumber) {
		
		 $checkSiteAlreadyExists = $this->db->select('*')->from('all_sites_geocodes')->where(['SERIALNO' => $serialNumber])->get()->first_row('array');
		 
		 return $checkSiteAlreadyExists ;
		 
	}
	
	
	public function insertSiteGeocodes($data) {
		$query 	   = $this->db->insert('all_sites_geocodes', $data);
	}
	
	
	public function getTokenLoggedInUsers () {

		
		$googleFCMTOkens = [] ;
		
		$query = $this->db->select('*')->from('mobile_app_users')->where(['login_status' => 'true', 'google_firebase_token !=' => '' ])->get()->result_array();
		
		if ( $query ) {
		
			foreach ($query as $data) {
				$googleFCMTOkens[] = $data['google_firebase_token'] ;
			}
			
		}
		
		
		return $googleFCMTOkens ;
	
	}
	
	
}
