<?php

Class Tracking extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('trackings');
	}

	function index()
	{
		if( !empty($this->input->get('searchbar')) )
		{
			$this->session->set_userdata('search_value', $this->input->get('searchbar'));
			$data['tracking'] = $this->trackings->get_tracking_list_search($this->input->get('searchbar'));
		}
		else
		{
			$this->session->unset_userdata('search_value');
			$data['tracking'] = $this->trackings->get_tracking_list();
		}
		
		$this->load->view('tracking/report_trigger',$data);

	}

	function asm()
	{
		if( !empty($this->input->get('searchbar')) )
		{
			$this->session->set_userdata('search_value', $this->input->get('searchbar'));
			$data['tracking'] = $this->trackings->get_asm_tracking_list_search($this->input->get('searchbar'));
		}
		else
		{
			$this->session->unset_userdata('search_value');
			$data['tracking'] = $this->trackings->get_asm_tracking_list();
		}
		//debug($data,1);
		$this->load->view('tracking/asm_trigger',$data);	
	}

	function login(){
		$this->load->view('tracking/login');
	}

	function login_check(){
		if( $this->input->post('loginEmail') == 'admin@orbis.com' && $this->input->post('loginPass') == md5('admin@123') ){
			echo json_encode([ 'error' => 0 ]);
		}else{
			echo json_encode([ 'error' => 1 ]);
		}
	}

	function blocklist(){
		$data['number'] = $this->trackings->getBlockNumberList();
		$this->load->view('tracking/blockedNumber',$data);
	}

	function addNumberBlock(){
		$asmblocklistform = $this->input->post('Mobile');
		//check whether number exits in db or not
		$getBlockNumber = $this->trackings->getBlockNumber($asmblocklistform);
		if( !empty($getBlockNumber->id) ){
			echo json_encode([ 'error' => 1, 'message' => 'Number already blocked!']);
		}else{
			$insertBlockNumber = $this->trackings->insertBlockNumber($asmblocklistform);
			if( $insertBlockNumber ){
				echo json_encode([ 'error' => 0, 'message' => 'added in block list']);	
			}else{
				echo json_encode([ 'error' => 1, 'message' => 'error while adding in block list']);	
			}
		}
		//debug($getBlockNumber,1);
	}

	function removeBlockNumber(){
		$number_id = $this->input->post('id');
		$removeBlockNumber = $this->trackings->removeBlockNumber($number_id);
		if( $removeBlockNumber ){
				echo json_encode([ 'error' => 0, 'message' => 'number remove from block list']);	
			}else{
				echo json_encode([ 'error' => 1, 'message' => 'Error while removing number from block list']);	
			}
	}
}