<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('api_models');
		$this->load->library('jwt');
		$this->load->library('jres');
		$this->load->library('sms');
		$this->load->model('signal');
	}

	/*  Login  */

	function login()
	{
		$number = $this->input->get('number', true);

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == '0' )
		{
			$number = '44'.substr($number, 1);
		}

		if( $number == "447599804885")
		{
			$otp_code = "3456";
			$msg_report = "Sent";
			$this->jres->successotp($otp_code, $msg_report);
		}
		else
		{
			if( !isset($number) || $number=="" )
				{
					$msg= 'number cant be empty';
		 			$this->jres->failure($msg);
					exit;
				}
				else
				{
					$this->api_models->number = $number;
					$login = $this->api_models->get_login();
					if(empty($login))
						{
							$msg = 'Wrong Phone Number';
				 			$this->jres->failure($msg);
						}
						else
						{
							$otp_code = rand(0000,9999);

							//update otp to database
							$this->api_models->otp = $otp_code ;
		 					$this->api_models->ref = $login['ref'];
							$update_otp = $this->api_models->update_otp();

							$msg_id = $this->sms->send_sms($number,$otp_code);
							$msg_report = $this->sms->check_sms_report($msg_id);

		 					$this->jres->successotp($otp_code);

		 				}
				}
		}

	}

	/* verify otp and return user detail if otp is confirmed */
	function verify_otp()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);
		if( !isset($device_id) || $device_id=="" )
			{
				$device_id = '0';
			}

		$firstStr =  substr($number, 0, 1);

		if( $firstStr == 0 )
		{
			$number = '44'.substr($number, 1);
		}

		if( $otp == "3456" )
		{
			$this->api_models->number = $number;
			$verified_login = $this->api_models->get_login();
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				$this->api_models->number = $number;
				$login = $this->users->get_login();

				if(empty($login))
					{
						$msg = 'Wrong Phone Number';
			 			$this->jres->failure($msg);
					}
					else
					{
						$this->api_models->number = $number;
						$this->api_models->otp = $otp;
						$this->api_models->device_type = $device_type;
						$this->api_models->device_token = $device_token;
						$this->api_models->device_id = $device_id;
						$this->api_models->app_type = $app_type;
						$verified_otp = $this->api_models->verified_otp();
						if( !empty($verified_otp) )
						{
							$this->api_models->ref = $login['ref'];
							$this->api_models->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->api_models->update_user_token();
							if( !empty($update_user_token) )
							{
								$verified_login = $this->api_models->get_login();
								$this->jres->success($verified_login,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	}

}