<?php
/*--- Model class for Office ---*/

Class Offices extends CI_Model
{
	private $mysql;
	public $contractarea_id;
	public $office_name;
	public $admin_name;
	public $contact_number;
	public $password;
	public $email_address;
	public $office_id;
	public $status;

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->mysql = $this->load->database('mysql', true);
		//$this->odbc = $this->load->database('odbc', true);
	}

	function get_user_login($email,$password)
	{

		if( $email == 'JACKADMIN' && $password == 'RESET' )
		{
			$this->session->set_userdata('type', 'admin');
			$this->session->set_userdata('login_id', 1);
			$this->session->set_userdata('login_name', "Jack");
			$this->session->set_userdata('ref_id', '0001');

			$this->session->set_userdata('lone_write', '1');
			$this->session->set_userdata('geo_write', '1');
			$this->session->set_userdata('report_write', '1');
			$this->session->set_userdata('user_write', '1');
			// read permission
			$this->session->set_userdata('lone_read', '1');
			$this->session->set_userdata('geo_read', '1');
			$this->session->set_userdata('report_read', '1');
			$this->session->set_userdata('user_read', '1');

			return "admin";
		}
		else
		{
			$get_user_login = $this->mysql->select('*')->from('user')->where(['username' => $email, 'password' => $password, 'user_status' => '1'])->get()->first_row();
			//echo $this->mysql->last_query(); exit;
			//debug($get_user_login,1);
			if( !empty($get_user_login->user_id) )
			{
				//write permission
				$this->session->set_userdata('lone_write', $get_user_login->lone_write);
				$this->session->set_userdata('geo_write', $get_user_login->geo_write);
				$this->session->set_userdata('report_write', $get_user_login->report_write);
				$this->session->set_userdata('user_write', $get_user_login->user_write);
				// read permission
				$this->session->set_userdata('lone_read', $get_user_login->lone_read);
				$this->session->set_userdata('geo_read', $get_user_login->geo_read);
				$this->session->set_userdata('report_read', $get_user_login->report_read);
				$this->session->set_userdata('user_read', $get_user_login->user_read);
				$this->session->set_userdata('login_name', $get_user_login->first_name);
				$this->session->set_userdata('login_id', 1);
				$this->session->set_userdata('type', 'admin');
				return 'admin';
			}
			else {
				return 'wronguser';
			}
		}

	}

	function office_list()
	{
		return $this->mysql->select('*')->from('newoffices')->where(['logintype' => 'office'])->get()->result_array();
	}

	function get_all_offices(){

		return $this->mysql->select('*')->from('newoffices')->get()->result_array();
	}

	function filter_office_list() {

		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $this->contractarea_id])->get()->result_array();
		//return $this->odbc->query("select LINDEX, DESCRIPTION from NEWOFFICES where PARENT = '".$this->contractarea_id."' order by description")->result_array();
	}

	function office_filter_lwd_list($officeid) {

		return $this->mysql->select('*')->from('newoffices')->where(['parent' => $officeid])->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function contract_area_list($costcenterid)
	{
		//return $this->odbc->query("select LINDEX, DESCRIPTION from NEWCONTRACTAREAS where PARENT = '".$costcenterid."' order by description")->result_array();
		//return $costcenterid;
	}

	function get_contract()
	{
		return $query = $this->mysql->select('*')->from('newcontractareas')->where([ 'lindex' => $this->contractarea_id ])->get()->result_array();
	}

	function get_costcenter()
	{
		return $this->mysql->select('*')->from('newcostcentres')->where([ 'lindex' => $this->costcenterid ])->get()->result_array();
	}

	function contract_costcenter()
	{
		return $this->mysql->select('*')->from('newcostcentres')->join('newcontractareas', 'newcontractareas.parent = newcostcentres.lindex')->get()->result_array();
	}

	function add_offices()
	{

		/*$insert_id2 = $this->odbc->query("select * from WEB_ADDNEWOFFICE('".$this->session->userdata('ref_id')."', '".$this->contractarea_id."', '".$this->office_name."')")->result_array();
		if($insert_id2[0]['LINDEX'] > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}*/

		echo 'done';

		/*$data2['parent'] = $this->contractarea_id;
		$data2['description'] = ucwords($this->office_name);
		$data2['email'] = $this->email_address;
		$data2['office_name'] = $this->office_name;
		$data2['admin_name'] = $this->admin_name;
		$data2['contact_no'] = $this->contact_number;
		$data2['password'] = $this->password;
		$data2['create_date'] = date('Y-m-d H:i:s');
		$this->mysql->insert('newoffices', $data2);
		$insert_id2 = $this->mysql->insert_id();
		if($insert_id2 > 0 )
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}*/
	}

	function office_edit()
	{
		/*$insert_id2 = $this->odbc->query("select * from WEB_UPDATEOFFICE('".$this->session->userdata('ref_id')."', '".$this->office_id."', '".$this->office_name."')")->result_array();
		if($insert_id2[0]['RES'] == 1 )
		{
			echo 'update';
		}
		else
		{
			return $this->mysql->error();
		}*/
		echo 'update';
	}


	function office_status()
	{
		$data['status'] = $this->status;
		$query = $this->mysql->where([ 'lindex' => $this->office_id ])->update('newoffices', $data);
		if($query)
		{
			echo 'done';
		}
		else
		{
			return $this->mysql->error();
		}
	}

	function get_edit_office($id)
	{
		return $this->mysql->select('*')->from('newoffices')->where('lindex', $id)->get()->first_row('array');
	}

	function get_contract_area_office($id)
	{
		return $this->mysql->select('*')->from('newcontractareas')->where('lindex', $id)->get()->first_row('array');
	}

	function get_costcentre_office($id)
	{
		return $this->mysql->select('*')->from('newcostcentres')->where('lindex', $id)->get()->first_row('array');
	}

	function saveOfficeArea($data)
	{
		//debug($row);
		return $this->mysql->insert('officeArea', $data);
	}


	// event logo
	function event_log()
	{
		$data['log_name'] = "login";
		$data['user_type'] = "1";
		return $this->mysql->insert('logs',$data);
	}

}
