<?php

Class Lwds extends CI_Model
{
	private $mysql;
	public $lwd_id;
	public $login_name;
	public $fname;
	public $password;
	public $imei;
	public $email_address;
	public $costcenter;
	public $address;
	public $operator_table;
	public $signal_kill;
	public $redalertnumber;
	public $amberalertnumber;
	public $ipaddress;
	public $port;
	public $redalertsmsnumber;
	public $silentdial;
	public $positionupdateinterval;
	public $fixedambertime;
	public $falldetectenabled;
	public $limitamber;
	public $falldetectedsensitivity;
	public $allow_user;
	public $search_term;
	

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql',true);
		$this->operator_table = 'operators';
	}

	function login_name()
	{
		return $this->mysql->select('ref, loginname, createdate')->from('operators')->where(['loginname' => $this->login_name, 'logintype' => 'LWD'])->get()->first_row('array');
		 $this->mysql->last_query();
	}

	function email_address()
	{
		return$this->mysql->select('ref, emailaddress, createdate')->from('operators')->where(['emailaddress' => $this->email_address, 'logintype' => 'LWD'])->get()->first_row('array');
	}

	function add_lwd_db()
	{
		$data['fullname'] = $this->fname;
		$data['loginname'] = $this->fname;
		$data['surname'] = $this->login_name;
		$data['password'] = $this->password;
		$data['number'] = $this->number;
		$data['imei_no'] = $this->imei;
		$data['office'] = $this->office;
		$data['emailaddress'] = $this->email_address;
		$data['address'] = $this->address;
		$data['logintype'] = 'LWD';
		$data['createdate'] = date('Y-m-d H:i:s');
		//debug($data,1);
		$this->mysql->insert('operators', $data);
		return $insert_id = $this->mysql->insert_id();
	}
	
	function office_list($contractareaid)
	{
		return $this->mysql->select('*')->from('newoffices')->where(['parent'=>$contractareaid])->get()->result_array();
	}
	
	//fetch blogs
    function get_lwd_list($limit, $offset) {

    	return $this->mysql->select('*')->from('operators')->where('logintype','LWD')->limit( $limit , $offset )->order_by('
    		createdate', 'desc')->get()->result_array();
    	//echo $this->mysql->last_query();
    	/*return $this->mysql->where('logintype','LWD')->get($this->operator_table, $limit, $offset)->result_array();*/
    }

    function get_lwd_list_sys($limit, $offset)
    {
    	return $this->mysql->select('*')->from('operators')->where([ 'logintype' => 'LWD', 'office' => '23' ])->limit( $limit , $offset )->order_by('
    		createdate', 'desc')->get()->result_array();
    	//echo $this->mysql->last_query();
    	
    }


    function get_office_lwd_sys()
	{
		return count($this->mysql->select('*')->from('operators')->where(['office' => '23'])->get()->result_array());
	}
	
	 function get_lwd_list_filter($officeid, $limit, $offset) {

    	return $this->mysql->select('*')->from('operators')->where('logintype','LWD')->where('office',$officeid)->limit($limit , $offset )->order_by('
    		createdate', 'desc')->get()->result_array();
    	//echo $this->mysql->last_query();
    	/*return $this->mysql->where('logintype','LWD')->get($this->operator_table, $limit, $offset)->result_array();*/
    }
	
	function get_lwd_office_list($officeid, $limit, $offset) {
		
		$array = array('logintype' => 'LWD', 'office' => $officeid);

		return $this->mysql->select('*')->from('operators')->where($array)->limit( $limit , $offset )->order_by('
    		createdate', 'desc')->get()->result_array();
		
	}
	
	function getcontractareaname($contractareaid){
		
		 return $this->mysql->select('*')->from('newcontractareas')->where(['parent' => $contractareaid ])->get()->result();
	}

	function detail_escalation_lwd($id)
	{
		return $this->mysql->select('*')->from('escalation_detail')->where('ref_id', $id)->get()->first_row('array');
	}
	
	function getcostcentername($costcenterid) {
		
		 return $this->mysql->select('*')->from('newcostcentres')->where(['lindex' => $costcenterid ])->get()->result();
	}

    function get_count_lwd()
    {
    	return $this->mysql->count_all('operators');
    }
	
    function map_location_lwd()
    {
    	//$this->lwd_id;
    	//$this->mysql->select('*')->from('location')->where(['ref_id' => $this->lwd_id ])->like('create_date', date('Y-m-d'), 'after')->get()->result();
    	return $this->mysql->select('*')->from('location')->where(['ref_id' => $this->lwd_id ])->like('create_date', date('Y-m-d'), 'after')->get()->result();
    	//echo $this->mysql->last_query();
    }

    function signal_status()
    {
    	$data['signal_kill'] = $this->signal_kill;
    	return $this->mysql->where([ 'ref' => $this->lwd_id ])->update('operators', $data);
		
    }
	
	function get_device_token(){
		
		return $this->mysql->select('*')->from('operators')->where(['ref' => $this->lwd_id ])->get()->result();
		
	}

	function get_lwd_profile()
	{
		return $this->mysql->select('*')->from('operators')->where([ 'ref' => $this->lwd_id, 'logintype' => 'LWD' ])->get()->first_row();
	}

	/*function get_filter_lwd_list($limit, $offset, $officeid) {
		
		 if ($offset > 0) {
            $offset = ($offset - 1) * $limit;
        }
		$array = array('logintype' => 'LWD', 'office' => $officeid);
        $result['rows'] = $this->mysql->where('logintype','LWD')->where($array)->get($this->operator_table, $limit, $offset);
        $result['num_rows'] = $this->mysql->where($array)->count_all_results($this->operator_table);
        return $result;
	}*/

	/*function lwd_list()
	{
		
		
		return $this->mysql->select('*')->from('operators')->where([ 'logintype' => 'LWD' ])->get()->result_array();
	}*/

	function add_lwd_setting()
	{
		$data['lwd_ids'] = $this->lwd_id;
		$data['redalertnumber'] = $this->redalertnumber;
		$data['amberalertnumber'] = $this->amberalertnumber;
		$data['ipaddress'] = $this->ipaddress;
		$data['port'] = $this->port;
		$data['redalertsmsnumber'] = $this->redalertsmsnumber;
		$data['silentdial'] = $this->silentdial;
		$data['positionupdateinterval'] = $this->positionupdateinterval;
		$data['falldetectenabled'] = $this->falldetectenabled;
		$data['limitamber'] = $this->limitamber;
		$data['fixedambertime '] = $this->fixedambertime;
		$data['allow_user'] = $this->allow_user;
		$data['falldetectedsensitivity'] = $this->falldetectedsensitivity;
		$data['create_date'] = date('Y-m-d H:i:s');
		return $this->mysql->insert('settings', $data);
	}

	function getlwds($id)
	{
		return $this->mysql->select('*')->from('operators')->where([ 'ref' => $id ])->get()->result_array();
	}

	function editlwds($lwdid,$firstname,$lastname,$emaddress,$devicetype,$phnumber,$imnumber,$addr, $gender)
	{
		$data['fullname'] = $firstname;
		$data['loginname'] = $firstname;
		$data['surname'] = $lastname;
		$data['number'] = $phnumber;
		$data['imei_no'] = $imnumber;
		$data['emailaddress'] = $emaddress;
		$data['address'] = $addr;
		$data['gender'] = $gender;
		$data['device_type '] = $devicetype ;
		$editlwds =  $this->mysql->where([ 'ref' => $lwdid ])->update('operators', $data);
		if($editlwds)
		{
			return 'success';
		}
		else
		{
			return 'fail';
		}
	}

	function getsettings($id)
	{
		$get_setting_id = $this->mysql->select('*')->from('operators')->where([ 'ref' => $id ])->get()->first_row();
		return $this->mysql->select("*")->from('settings')->where( [ 'id' => $get_setting_id->setting_id ] )->get()->result_array();
		
	}

	function get_lwds_escalation()
	{
		return $this->mysql->select('*')->from('escalation_detail')->where(' ref_id ', $this->lwd_id)->get()->first_row();
	}

	// search lwd by number
	function searchReturn()
	{
		return $this->mysql->select('number')->from('operators')->like('number', $this->search_term, 'both')->get()->result_array();
	}

	// search lwd by name
	function searchReturnName()
	{
		return $this->mysql->select('fullname')->from('operators')->like('fullname', $this->search_term, 'both')->get()->result_array();
	}

	// function to search lwd using like operators
	function office_list_search()
	{
		return $this->mysql->select('*')->from('operators')->like( 'ref', $this->search_term, 'both' )->or_like('fullname', $this->search_term, 'both')->or_like( 'number', $this->search_term, 'both' )->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function office_list_search_sys()
	{
		return $this->mysql->select('*')->from('operators')->like( 'ref', $this->search_term, 'both' )->or_like('fullname', $this->search_term, 'both')->or_like( 'number', $this->search_term, 'both' )->where('office', '23')->get()->result_array();
	}
	
	

	function office_list_search_lwd($officeid, $search_term)
	{
		return $this->mysql->select('*')->from('operators')->where( 'office', $officeid )->like( 'ref', $search_term, 'both' )->or_like('fullname',$search_term, 'both')->or_like( 'number', $search_term, 'both' )->get()->result_array();
	}
	
	function editsettings($lwdid, $redalert, $amberalert, $ipaddress, $port, $redalertsms, $silentdial, $positionupdate, $fixedamber, $falldetectenabled, $limitamber, $falldetectsensitivity, $allowuser){
		
		$data['redalertnumber'] = $redalert;
		$data['amberalertnumber'] = $amberalert;
		$data['ipaddress'] = $ipaddress;
		$data['port'] = $port;
		$data['redalertsmsnumber'] = $redalertsms;
		$data['silentdial'] = $silentdial;
		$data['positionupdateinterval'] = $positionupdate;
		$data['	falldetectenabled'] = $falldetectenabled;
		$data['limitamber'] = $limitamber;
		$data['fixedambertime'] = $fixedamber;
		$data['allow_user'] = $allowuser;
		$data['falldetectedsensitivity'] = $falldetectsensitivity;
		//debug($data,1);
		$this->mysql->insert('settings', $data);
		$insert_id = $this->mysql->insert_id();
		$data1['setting_id'] = $insert_id;
    	return $this->mysql->where([ 'ref' => $lwdid ])->update('operators', $data1);
		
	}

	function escalation_edit($data)
	{
		$row['name1'] = $data['name1'];
		$row['phone_number1'] = $data['phone1'];
		$row['name2'] = $data['name2'];
		$row['phone_number2'] = $data['phone2'];
		$row['name3'] = $data['name3'];
		$row['phone_number3'] = $data['phone3'];

		return $this->mysql->where( 'ref_id', $data['escalationID'] )->update('escalation_detail', $row);
	}

	function save_escalation($data)
	{
		$row['name1'] = $data['name1'];
		$row['phone_number1'] = $data['phone1'];
		$row['name2'] = $data['name2'];
		$row['phone_number2'] = $data['phone2'];
		$row['name3'] = $data['name3'];
		$row['phone_number3'] = $data['phone3'];
		$row['ref_id'] = $data['escalationID'];
		$row['create_date'] = date('Y-m-d H:i:s');
		return $this->mysql->insert('escalation_detail', $row);
	}

	function event_log()
	{
		return $this->mysql->select('*')->from('location')->where('ref_id', $this->lwd_id)->order_by('create_date', 'desc')->get()->result_array();
	}

	function current_location()
	{
		return $this->mysql->select('*')->from('location')->where(['ref_id' => $this->lwd_id ])->order_by('create_date', 'desc')->get()->first_row('array');
	}
}