<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller
{

	function __construct() 
	{
		parent::__construct();
		$this->load->model('users');
		$this->load->library('jwt');
		$this->load->library('jres');
		$this->load->library('sms');
		$this->load->model('signal');
	}

	function index()
	{
		$this->login();
	}

	function login()
	{
		$number = $this->input->get('number', true);

		if( $number == "918968163577" )
		{
			$otp_code = "3456";
			$msg_report = "Sent";
			$this->jres->successotp($otp_code, $msg_report);
		}
		else
		{
			if( !isset($number) || $number=="" )
				{
					$msg= 'number cant be empty';
		 			$this->jres->failure($msg);
					exit;
				}
				else
				{
					$this->users->number = $number;
					$login = $this->users->get_login();
					if(empty($login))
						{
							$msg = 'Wrong Phone Number';
				 			$this->jres->failure($msg);
						}
						else
						{
							$otp_code = rand(0000,9999);
							//update otp to database
							$this->users->otp = $otp_code ;
		 					$this->users->ref = $login['ref'];
							$update_otp = $this->users->update_otp();
							// Sending OTP
							$msg_id = $this->sms->send_sms($number,$otp_code);

							$msg_report = $this->sms->check_sms_report($msg_id);
							
		 					$this->jres->successotp($otp_code, $msg_report);
		 				}
				}	
		}
		
	}


	function verify_otp()
	{
		$number = $this->input->post('number', true);
		$device_type = $this->input->post('device_type', true);
		$device_token = $this->input->post('device_token', true);
		$app_type = $this->input->post('app_type', true);
		$device_id = $this->input->post('device_id', true);
		$otp = $this->input->post('otp', true);

		if( $otp == "3456" )
		{
			//echo "1";
			$this->users->number = $number;
			$verified_login = $this->users->get_login();
			$this->jres->success($verified_login,'otp verified');
		}
		else
		{
			//echo "2";
			if( !isset($number) || $number=="" )
			{
				$msg= 'number cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else if( !isset($otp) || $otp=="" )
			{
				$msg= 'otp cant be empty';
	 			$this->jres->failure($msg);
				exit;
			}
			else
			{
				//echo "3";
				$this->users->number = $number;
				$login = $this->users->get_login();
				
				if(empty($login))
					{
						//echo "4";
						$msg = 'Wrong Phone Number11';
			 			$this->jres->failure($msg);
					}
					else
					{
						$this->users->number = $number;
						$this->users->otp = $otp;
						$this->users->device_type = $device_type;
						$this->users->device_token = $device_token;
						$this->users->device_id = $device_id;
						$this->users->app_type = $app_type;
						$verified_otp = $this->users->verified_otp();
						////debug($verified_otp,1);
						if( !empty($verified_otp) )
						{
							$this->users->ref = $login['ref'];
							$this->users->token = $token = $this->jwt->encode($login);
							$update_user_token = $this->users->update_user_token();
							if( !empty($update_user_token) )
							{
								$verified_login = $this->users->get_login();

								//debug($verified_login,1);
								if( $verified_login['user_image'] )
								{
									$verified_login['user_image'] = 'http://54.218.78.31:50/dev/'.$verified_login['user_image'];
								}
								//debug($verified_login,1);
								$this->jres->success($verified_login,'otp verified');
							}
							else
							{
								$this->jres->failure('wrong otp detail');
							}
						}
						else
						{
							$this->jres->failure('wrong otp');
						}

					}
			}
		}


	}


	function logout()
	{
		$ref = $this->input->get('ref',true);
		if( !isset($ref) || $ref=="" )
		{
			$msg= 'login id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $ref;
			$logout = $this->users->user_logout();
			if( !empty($logout) )
				{
					$this->jres->successotp('','logout');
				}
				else
				{
					$this->jres->failure('invalid login id');
				}
		}
	}

	function location_update()
	{
		//debug( $this->input->post(),1 );
		//print_r($this->input->post());
		$ref_id = $this->input->post('ref_id',true);
		$lat = $this->input->post('lat',true);
		$long = $this->input->post('long',true);
		$DateTime = $this->input->post('datetime', true);
		$IMEI = $this->input->post('imei', true);
		$number = $this->input->post('number', true);
		$messageType = $this->input->post('messageType', true);
		$posdatatime = $this->input->post('posdatatime', true);
		$postype = $this->input->post('postype', true);
		$status = $this->input->post('status', true);
		$interval = $this->input->post('interval', true);
		$speed = $this->input->post('speed', true);

		if( !isset($ref_id) || $ref_id=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}elseif( !isset($lat) || $lat=="" )
		{
			$msg= 'lat cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		elseif( !isset($long) || $long=="" )
		{
			$msg= 'long cant be empty';
 			$this->jres->failure($msg);
			exit;
		}else
		{

			$this->signal->number = $number;
			$get_device_type = $this->signal->get_device_type();

			if($get_device_type['device_type'] == 'android' || $get_device_type['device_type'] == 'Android'){
		
				if(!($sock = socket_create(AF_INET, SOCK_STREAM, 0)))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
						     
						    //die("Couldn't create socket: [$errorcode] $errormsg \n");
						    $this->jres->failure("Couldn't create socket: [$errorcode] $errormsg \n");
						    exit;
						}
	
						if(!socket_connect($sock , '46.255.118.104' , 5055))
						{
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
						     
						    //die("Could not connect: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not connect: [$errorcode] $errormsg \n");
						    exit;
						}
						$signals = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed;
	
						$checksum = md5($signals);
						
						$message = "PRT,".$DateTime.",".$IMEI.",".$number.",".$messageType.",".$lat.",".$long.",".$posdatatime.",".$postype.",".$status.",".$interval.",".$speed.",".$checksum;
						
						//Send the message to the server
						if( ! socket_send ( $sock , $message , strlen($message) , 0))
						 {
						    $errorcode = socket_last_error();
						    $errormsg = socket_strerror($errorcode);
						     
						   // die("Could not send data: [$errorcode] $errormsg \n");
						    $this->jres->failure("Could not send data: [$errorcode] $errormsg \n");
						    exit;
						}
						//$this->jres->success_message('Signals send successfully');
						socket_close($sock);
			
					}

					$this->users->ref_id = $ref_id;
					$this->users->lat = $lat;
					$this->users->long = $long;
					$this->users->status = $status;
					$update_location = $this->users->update_location();
					if( $update_location > 0)
					{
						$this->jres->success_message('Signals and location updated');
					}
					else
					{
						$this->jres->failure('','location updated fail');
					}
		}

	}

	function get_setting_lwd()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_lwd_setting = $this->users->get_lwd_setting();
			if($get_lwd_setting)
			{
				$this->jres->success( $get_lwd_setting );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function check_signal()
	{
		$refID = $this->input->get('ref');

		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$get_signal_status = $this->users->get_signal_status();
			if($get_signal_status)
			{
				if($get_signal_status['signal_kill'] == '1')
				{
					$get_signal_status['signal_kill'] = 'signal on';
					$get_signal_status['signal_status'] = '1';
				}
				if($get_signal_status['signal_kill'] == '0')
				{
					$get_signal_status['signal_kill'] = 'signal off';
					$get_signal_status['signal_status'] = '0';
				}
				$this->jres->success( $get_signal_status );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

	function profile_download()
	{
		$refID = $this->input->get('ref');
		if( !isset($refID) || $refID=="" )
		{
			$msg= 'ref_id cant be empty';
 			$this->jres->failure($msg);
			exit;
		}
		else
		{
			$this->users->ref = $refID;
			$download_profile = $this->users->download_profile();
			//var_dump($download_profile);
			( is_null($download_profile['name1']) )? 'Name 1' : ucfirst($download_profile['name1']);
			if(  is_null($download_profile['name1']) )
			{
				$download_profile['name1'] = 'Name 1';
			}
			if(  is_null($download_profile['phone_number1']) )
			{
				$download_profile['phone_number1'] = '000000';
			}
			if(  is_null($download_profile['name2']) )
			{
				$download_profile['name2'] = 'Name 2';
			}
			if(  is_null($download_profile['phone_number2']) )
			{
				$download_profile['phone_number2'] = '000000';
			}
			if(  is_null($download_profile['name3']) )
			{
				$download_profile['name3'] = 'Name 3';
			}
			if(  is_null($download_profile['phone_number3']) )
			{
				$download_profile['phone_number3'] = '000000';
			}
			
			if($download_profile)
			{
				$this->jres->success( $download_profile );
			}
			else
			{
				$this->jres->failure('no row found');
			}
		}
	}

}