<?php

Class Streets extends CI_Model
{
	public $table_street = 'street_sheet';
	public $table_address = 'street_address';

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql',true);
	}

	function get_knock_address()
	{
		return $this->mysql->select('*')->from($this->table_address)->where([ 'status <>' => 'n/a' ])->order_by('update_at','desc')->get()->result_array();
	}

	function get_street_by_address($street_id)
	{
		$return = $this->mysql->select('street_name')->from($this->table_street)->where([ 'street_id' => $street_id ])->get();
		foreach( $return->result() as $row  )
		{
			return $row->street_name;
		}
	}

	function get_postcode_by_street($street_id)
	{
		$return = $this->mysql->select('postcode')->from($this->table_street)->where([ 'street_id' => $street_id ])->get();
		foreach( $return->result() as $row  )
		{
			return $row->postcode;
		}
	}

	//get pitch address
	function get_pitch()
	{
		return $this->mysql->select('*')->from($this->table_address)->where([ 'status' => 'P' ])->order_by('update_at','desc')->get()->result_array();
	}

	function get_address($address_id)
	{
		return $this->mysql->select('*')->from($this->table_address)->where([ 'address_id' => $address_id ])->get()->first_row('array');
	}

	function address_list()
	{
		return $this->mysql->select('*')->from($this->table_address)->get()->result_array();
	}

	function streetViaAddressId($street_id)
	{
		return $this->mysql->select('*')->from($this->table_street)->where('street_id',$street_id)->get()->first_row('array');
	}

	function street_list($user_id)
	{
		return $this->mysql->select('*')->from($this->table_street)->where(['user_id' => $user_id])->get()->result_array();
	}

	function get_user_street($userID)
	{
		$return = $this->mysql->select('*')->from($this->table_street)->where(['user_id' => $userID])->get();
		foreach( $return->result() as $row )
		{
			return $row->street_name;
		}
	}

	function get_street($postcode)
	{
		return $this->mysql->select('*')->from($this->table_street)->where_in('postcode',$postcode)->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function get_street_address($streetID)
	{
		return $this->mysql->select('*')->from( $this->table_address )->where('street_id', $streetID)->order_by('address','asc')->get()->result_array();
		//echo  $this->mysql->last_query();
	}
}
