<?php

Class User extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->model('sales');
		$this->load->model('users');
		$this->load->model('streets');
		$this->load->model('switchs');
		if( !empty($_SERVER['HTTP_HOST'] == 'localhost') )
		{
			$this->upload_path = 'E:\server\htdocs\eversmartportal';
			$this->upload_path1 = 'E:\server\htdocs\saleappbackend';
		}
		else
		{
			$this->upload_path = '/var/www/html/eversmart-sales-backend';
			$this->upload_path1 = '/var/www/html/eversmartsales';
		}
	}

	function index()
	{
		if( $this->session->userdata('login_id') != 1 )
        {
        	redirect('/user/login');
        }
        else
        {
        	redirect('/user/home');	
        }
		
	}

	function login()
	{
		$this->load->view('layout/newlogin');
	}

	function logout()
	{
		$this->session->set_userdata('login_id','0');
		redirect('/');
	}

	function system_user()
	{
		$this->session->set_userdata('type', 'system');
		$this->session->set_userdata('login_id', 1);
		$this->session->set_userdata('login_name', 'Super User');
		$this->session->set_userdata('office_id', '23');
		//$this->offices->event_log();
		if($this->session->userdata('type') && $this->session->userdata('login_id') )
		{
			echo 'done';
		}
		else
		{
			echo 'fail';
		}
	}

	function home()
	{
		if( $this->session->userdata('login_id') != 1 )
        {
        	redirect('/user/login');
        }

		// for sales tab on dashboard
		$data['sales'] = $this->sales->get_sales();
		for( $m=0; $m<count($data['sales']); $m++ )
		{
			//get address detail
			$data['sales'][$m]['address_id'] = $this->streets->get_address($data['sales'][$m]['address_id']);
			// get customer name
			$data['sales'][$m]['customer_name'] = $this->users->get_customer_name($data['sales'][$m]['customer_id']);

			//get street name
			$data['sales'][$m]['address_id']['street_name'] = $this->streets->get_street_by_address($data['sales'][$m]['address_id']['street_id']);
			//get postcode
			$data['sales'][$m]['address_id']['postcode'] = $this->switchs->street_detail_postocde($data['sales'][$m]['address_id']['street_id']);
		}

		//debug($data['sales'],1);
		//for knocks on dashboard
		$data['knocks'] = $this->streets->get_knock_address();
		for( $k=0; $k<count($data['knocks']); $k++ )
		{
			$data['knocks'][$k]['street_name'] = $this->streets->get_street_by_address($data['knocks'][$k]['street_id']);
		}

		// pitch tab on dashbaord
		$data['pitch'] = $this->streets->get_pitch();
		for( $n=0; $n<count($data['pitch']); $n++ )
		{
			$data['pitch'][$n]['street_name'] = $this->streets->get_street_by_address($data['pitch'][$n]['street_id']);
		}

		
		$data['content'] = 'user/user_list';
		$this->load->view('layout/master',$data);
	}

	function assign_team()
	{
		$id = $this->input->post('user_id');
		$team = $this->input->post('team_list');
		$update_user = $this->users->update_user_team($team,$id);
		if($update_user)
		{
			echo '1';
		}
		else
		{
			echo '0';
		}
	}

	function assign_street()
	{
		$id = $this->input->post('user_id');
		$street_id = $this->input->post('street_id');
		$update_user = $this->switchs->update_user_street($street_id,$id);
		if($update_user)
		{
			echo '1';
		}
		else
		{
			echo '0';
		}
	}

	function get_user_detail()
	{
		$get_user_detail = $this->users->get_user_detail( $this->input->post('user_id') );
		if(!empty($get_user_detail))
		{
			//debug($get_user_detail);
			$get_user_detail['adddress'] = explode(',',$get_user_detail['address'])[0];
			$get_user_detail['street'] = explode(',',$get_user_detail['address'])[1];
			$get_user_detail['city'] = explode(',',$get_user_detail['address'])[2];
			$get_user_detail['postcode'] = explode(',',$get_user_detail['address'])[3];
		}
		//exit;
		$get_user_detail['account'] = $this->users->account_detail( $this->input->post('user_id') );
		$get_user_detail['commission'] = $this->users->get_user_commission($this->input->post('user_id'));
		$get_user_detail['knocks'] = $this->switchs->knock_user($this->input->post('user_id'));
		for($i=0; $i<count($get_user_detail['knocks']); $i++)
		{
			$sales[] = $this->switchs->sale_user($get_user_detail['knocks'][$i]['address_id']);
			foreach($sales as $key=>$value)
			{
			    if(is_null($value) || $value == '')
			        unset($sales[$key]);
			}
			$pitch[] = $this->switchs->pitch_user($get_user_detail['knocks'][$i]['address_id']);
			foreach($pitch as $key=>$value)
			{
			    if(is_null($value) || $value == '')
			        unset($pitch[$key]);
			}
			$get_user_detail['sales'] = (string)count($sales);
			$get_user_detail['pitch'] = (string)count($pitch);
		}
		//debug($get_user_detail,1);
		echo json_encode($get_user_detail);
	}

	function update_canvasser()
	{
		if( !empty($_FILES['user_image']['size']) || $_FILES['user_image']['size'] > 0 )
		{
			//$directory_path = getcwd(); 
			$db_path = $this->upload_path.'/upload/users';
			$new_file = date('Y_m_d_H_i_s').'_'.$_FILES['user_image']['name'];
			$target_path = $db_path;
			$target_file = $target_path.'/'.$new_file;
			$db_path1 = $this->upload_path1.'/upload/users';
			$target_file1 = $db_path1.'/'.$new_file;
			$temp = $_FILES["user_image"]["tmp_name"];
			if(move_uploaded_file($temp, $target_file) )
			{
				copy($target_file , $target_file1 );
				$data['user_image'] = 'upload/users/'.$new_file;			
			}
		}
		else
		{
			$data['user_image'] = $this->input->post('userImage');
		}
		
		$data['first_name'] = $this->input->post('fname');
		$data['email'] = $this->input->post('email');
		$data['username'] = $this->input->post('username');
		$data['dob'] = $this->input->post('dob');
		$data['password'] = $this->input->post('password');
		$data['phone_number'] = $this->input->post('number');
		$data['address'] = $this->input->post('house').','.$this->input->post('street').','.$this->input->post('city').','.$this->input->post('postcode');
		$account['account_number'] = $this->input->post('account');
		$account['sort_code'] = $this->input->post('sort_code');
		

		if( $this->input->post('user_id') || $this->input->post('user_id') !='0' )
		{
			$data['update_at'] = date('Y-m-d H:i:s');
			//edit user account detail
			$id = $this->input->post('user_id');
			$update_account_detail = $this->users->update_account_detail( $account, $id );

			// edit user profile
			$edit_canvasser = $this->users->edit_canvasser($data, $id);
			if( $edit_canvasser )
			{
				echo  '1';
			}
		}
		else
		{
			$data['created_at'] = date('Y-m-d H:i:s');
			$insert_canvassar = $this->users->insert_canvassar($data,$account);
			if( $insert_canvassar > 0)
			{
				echo '2';
			}
		}		
	}

	//delete user
	function user_delete()
	{
		$user_delete = $this->users->user_delete( $this->input->post('user_id') );
		if( $user_delete )
		{
			echo '1';
		}
		else
		{
			echo '0';
		}
	}

}
