<?php

Class Street extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('streets');
		if( $this->session->userdata('login_id') != 1 )
        {
            redirect('/user/login');
        }
	}

	function index()
	{
		$this->address();
	}

	function address()
	{
		$data['address_list'] = $this->streets->address_list();
		for( $m=0; $m<count($data['address_list']); $m++ )
		{
			$data['address_list'][$m]['street'] = $this->streets->streetViaAddressId($data['address_list'][$m]['street_id']);
			if( $data['address_list'][$m]['status'] == 'S' )
			{
				$data['address_list'][$m]['status'] = "Sale";
			}
			if( $data['address_list'][$m]['status'] == 'V' )
			{
				$data['address_list'][$m]['status'] = "Vacant";
			}
			if( $data['address_list'][$m]['status'] == 'NA' )
			{
				$data['address_list'][$m]['status'] = "No Answer";
			}
			if( $data['address_list'][$m]['status'] == 'C' )
			{
				$data['address_list'][$m]['status'] = "CallBack";
			}
			if( $data['address_list'][$m]['status'] == 'IR' )
			{
				$data['address_list'][$m]['status'] = "Information Request";
			}
			if( $data['address_list'][$m]['status'] == 'NI' )
			{
				$data['address_list'][$m]['status'] = "Not Interested";
			}
			if( $data['address_list'][$m]['status'] == 'DQ' )
			{
				$data['address_list'][$m]['status'] = "Does not Qualify";
			}
			if( $data['address_list'][$m]['status'] == 'P' )
			{
				$data['address_list'][$m]['status'] = "Pitched";
			}
			if( $data['address_list'][$m]['status'] == 'n/a' )
			{
				$data['address_list'][$m]['status'] = "-";
			}
		}
		$data['content'] = 'street/address_list';
		$this->load->view('layout/master', $data);

	}

} //class ends