<?php

Class Canvassers extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
     	$this->load->model('team');
        $this->load->model('users');
        $this->load->model('switchs');
        if( $this->session->userdata('login_id') != 1 )
        {
            redirect('/user/login');
        }
    }

    function index()
    {
        $data['users']=$this->users->get_canvasser();
        for( $i=0; $i<count($data['users']); $i++ )
        {
            $data['users'][$i]['street'] = $this->switchs->get_user_street($data['users'][$i]['user_id']);
        }
        $data['team'] = $this->team->get_list();
        $data['street'] = $this->switchs->not_assign_area();
        //debug($data['street'],1);
        $data['content'] = 'canvasser/user_list';
        $this->load->view('layout/master', $data);
    }

    function list($id = NULL)
    {
    	if( base64_decode($id) != '' )
    	{
	    	$data['team'] = $this->team->get_list_id(base64_decode($id));
	    	$data['team_street'] = $this->switchs->team_street( base64_decode($id) );
	    	for( $i=0; $i<count($data['team_street']); $i++ )
	    	{
	    		$data['addresss'][] = $this->switchs->street_address( $data['team_street'][$i]['assign_street_id'] );
	    	}


	    	//debug($data,1);
	    	if( !empty($data['team']) )
	    	{
	    		for( $m=0; $m<count($data['team']); $m++ )
    			{
    				$data['team'][$m]['user_detail'] = $this->users->get_user_team(base64_decode($id));
    			}	
	    	}
	    	else
	    	{
	    		$data['team'] = array();
	    	}
	    	
    	}
    	
    	$data['content'] = 'canvasser/list';
    	$this->load->view('layout/master',$data);
    	
    }

    function check_email()
    {
        $email = $this->input->post('email');
        $check_user_email = $this->users->check_user_email($email);
        if( $check_user_email['user_id'] >0 )
        {
            echo '1';
        }
        else
        {
            echo '0';
        }
    }

    function check_username()
    {
        $username = $this->input->post('username');
        $check_user_username = $this->users->check_user_username($username);
        if( $check_user_username['user_id'] > 0 )
        {
            echo '1';
        }
        else
        {
            echo '0';
        }
    }

}