<?php

Class Street extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('users');
		$this->load->model('streets');
		$this->load->model('team');
		if( $this->session->userdata('login_id') != 1 )
        {
            redirect('/user/login');
        }
	}

	function index()
	{
		$this->address();
	}

	function address()
	{
		$data['address_list'] = $this->streets->address_list();
		for( $m=0; $m<count($data['address_list']); $m++ )
		{
			$data['address_list'][$m]['street'] = $this->streets->streetViaAddressId($data['address_list'][$m]['street_id']);
			$data['user_id'] = $this->users->get_user_detail($data['address_list'][$m]['street']['user_id']);
			if( !empty($data['user_id']['first_name']) )
			{
				$data['address_list'][$m]['street']['user_id'] = $data['user_id']['first_name'];
			}
			else
			{
				$data['address_list'][$m]['street']['user_id'] = $data['user_id']['username'];
			}
			if( empty($data['user_id']) )
			{
				$data['address_list'][$m]['street']['user_id'] = '0';
			}

			if( $data['address_list'][$m]['status'] == 'S' )
			{
				$data['address_list'][$m]['status'] = "Sale";
			}
			if( $data['address_list'][$m]['status'] == 'V' )
			{
				$data['address_list'][$m]['status'] = "Vacant";
			}
			if( $data['address_list'][$m]['status'] == 'NA' )
			{
				$data['address_list'][$m]['status'] = "No Answer";
			}
			if( $data['address_list'][$m]['status'] == 'C' )
			{
				$data['address_list'][$m]['status'] = "CallBack";
			}
			if( $data['address_list'][$m]['status'] == 'IR' )
			{
				$data['address_list'][$m]['status'] = "Information Request";
			}
			if( $data['address_list'][$m]['status'] == 'NI' )
			{
				$data['address_list'][$m]['status'] = "Not Interested";
			}
			if( $data['address_list'][$m]['status'] == 'DQ' )
			{
				$data['address_list'][$m]['status'] = "Does not Qualify";
			}
			if( $data['address_list'][$m]['status'] == 'P' )
			{
				$data['address_list'][$m]['status'] = "Pitched";
			}
			if( $data['address_list'][$m]['status'] == 'n/a' )
			{
				$data['address_list'][$m]['status'] = "-";
			}
			if( $data['address_list'][$m]['street']['user_id'] == '0' || $data['address_list'][$m]['street']['user_id'] == ' ' )
			{
				$data['address_list'][$m]['street']['user_id'] = "-";
				$data['address_list'][$m]['status'] = "-";
			}
		}
		//debug($data,1);
		$data['content'] = 'street/address_list';
		$this->load->view('layout/master', $data);

	}

	function live_view()
	{
		$location = array();
		$data['team'] = $this->team->get_list();

		if(isset($_REQUEST['t']) != '')
		{
			$data['get_canvasser_team'] = $this->team->get_canvasser_team( $_REQUEST['t'] );
			$get_canvasser = $data['get_canvasser_team'];
			//$get_canvasser = $this->users->get_canvasser();
			for( $u = 0; $u<count($get_canvasser); $u++ )
			{
				$location[] = "['".$get_canvasser[$u]['username']."'".','.$get_canvasser[$u]['latitude'].','. $get_canvasser[$u]['longitude']."]";
			}
			$data['location'] = implode( ',', $location);
			//debug($data,1);
		}
		if( isset($_REQUEST['u']) != '' )
		{
			$get_canvasser = $this->users->get_user_detail($_REQUEST['u']);
			//debug($get_canvasser);
			//$get_canvasser = $this->users->get_canvasser();
			for( $u = 0; $u<count($get_canvasser); $u++ )
			{
				$location = "['".$get_canvasser['username']."'".','.$get_canvasser['latitude'].','. $get_canvasser['longitude']."]";
			}
			$data['location'] = $location;
		}
		if ( isset($_REQUEST['u']) == '' && isset($_REQUEST['t']) == '' )
		{

			$get_canvasser = $this->users->get_canvasser();
			for( $u = 0; $u<count($get_canvasser); $u++ )
			{
				$location[] = "['".$get_canvasser[$u]['username']."'".','.$get_canvasser[$u]['latitude'].','. $get_canvasser[$u]['longitude']."]";
			}
			$data['location'] = implode( ',', $location);
		}
		//debug( $data );
		$data['content'] = 'street/live_view';
		$this->load->view('layout/master', $data);
		//$this->load->view('street/live_view');
	}

	function map_data()
	{
		$this->load->view('street/data_map');
	}

	function all_addresses()
	{
		$response = [];
		$get_address = $this->streets->get_street_address( $this->input->post('streetID') );
		for( $m=0; $m<count($get_address); $m++ )
		{
			$get_address[$m]['street_name'] = $this->streets->get_street_by_address($get_address[$m]['street_id']);
			$get_address[$m]['street_postcode'] = $this->streets->get_postcode_by_street($get_address[$m]['street_id']);
		}
		$first = reset($get_address);
		$last = end($get_address);
		$response = [ $first, $last ];
		echo json_encode($response);
	}

} //class ends
