<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tariff_management extends CI_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->load->database();
        $this->load->helper('url');

        $this->load->library('Grocery_CRUD');
        $this->load->library('session');
    }

    public function _example_output($output = null)
    {
        $admin_data['page_ref'] = 'tariffs';
        $admin_data['page_title'] = 'Tariff Management';
        $admin_data['content'] = (array)$output;
        $this->load->view('layout/admin_template',$admin_data);
    }

    public function offices()
    {
        $output = $this->grocery_crud->render();

        $this->_example_output($output);
    }

    public function index()
    {
        $this->_example_output((object)array('output' => '' , 'js_files' => array() , 'css_files' => array()));
    }

    public function tariff()
    {


        $crud = new grocery_CRUD();
        $crud->set_theme('twitter-bootstrap');
        $crud->set_table('tariff');
        //$crud->where('tariff_code','IS NOT NULL');
        $crud->columns('tariff_name','tariff_code');

        $crud->set_subject('Tariff');
        $crud->unset_delete();
        //$crud->unset_add();
        $crud->unset_print();

        $output = $crud->render();

        if ( empty($this->session->userdata('login_data')) ) {

            redirect('/index.php/user/login/');

        }
        elseif( in_array($this->session->userdata('login_data')['admin_role_type_id'], array(1,3))  ){

            if (isset($savedsearch)) {
                $this->_example_output($output, $savedsearch);
            }
            else {
                $this->_example_output($output);
            }


        }
        else {
            redirect('/index.php/user/');
        }

    }

}
