package com.orbisalert.notifications;

import android.content.Context;
import android.os.PowerManager;
import android.util.Log;

/**
 * Created by Admin on 23-08-2017.
 */

public abstract class WakeLocker {
    private static PowerManager.WakeLock wakeLock;

    public static void acquire(Context context) {
        if (wakeLock != null) wakeLock.release();

        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        wakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK |
                PowerManager.ACQUIRE_CAUSES_WAKEUP |
                PowerManager.ON_AFTER_RELEASE, "WakeLock");
        wakeLock.acquire();

    }

    public static void release() {
        if (wakeLock != null) wakeLock.release(); wakeLock = null;
    }
}