package com.orbisalert.notifications;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.orbisalert.Activity.GlobalConstants;
import com.orbisalert.Activity.TabHostActivity;
import com.orbisalert.R;

import org.json.JSONException;
import org.json.JSONObject;


public class MyFirebaseMessagingService  extends FirebaseMessagingService {

    private static final String TAG = "MyFirebaseMsgService";
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {

        Log.e(TAG, "From: " + remoteMessage.getFrom());

        if (remoteMessage == null)
            return;

        // Check if message contains a notification payload.
        if (remoteMessage.getNotification() != null) {
           // Log.e(TAG, "Notification Body: " + remoteMessage.getNotification().getBody());
            //sendNotification(remoteMessage.getNotification().getBody());
        }

        // Check if message contains a data payload.
        if (remoteMessage.getData().size() > 0) {


            try {
               // Log.e(TAG, "Data Payload: " + remoteMessage.getData().toString());
                JSONObject json = new JSONObject(remoteMessage.getData().toString());
                handleDataMessage(json);
                Log.e(TAG, "JSON: " + json.toString());
            } catch (Exception e) {
                Log.e(TAG, "Exception: " + e.getMessage());
            }
        }
    }



    private void handleDataMessage(JSONObject json) {
        Log.e(TAG, "push json: " + json.toString());

        try {
           // JSONObject data = json.getJSONObject("data");
            String status = json.getString("status");
            String title = json.getString("title");
            String message = json.getString("message");
            preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
            editor = preferences.edit();
            editor.putString("FCMSignalStatus", status);
            editor.putString("FCMSignaltitle", title);
            editor.putString("FCMSignalmessage", message);
            editor.commit();


            Log.e(TAG, "title: " + title);
            Log.e(TAG, "message: " + message);
            Log.e(TAG, "STATUS: " + status);
            if (title.equalsIgnoreCase("Notallowed")){
                String notmessage= "Your data requests are restricted. Please contact Orbis";
                sendNotification(notmessage);

            }else {

                sendNotification(message);
            }


        } catch (JSONException e) {
            Log.e(TAG, "Json Exception: " + e.getMessage());
        } catch (Exception e) {
            Log.e(TAG, "Exception: " + e.getMessage());
        }
    }


    //This method is only generating push notification
    //It is same as we did in earlier posts
    private void sendNotification(String messageBody) {
        Intent intent = new Intent(this, TabHostActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent,
                PendingIntent.FLAG_ONE_SHOT);

        Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this)
                .setSmallIcon(R.drawable.app_icon)
                .setContentTitle("Signal Kill Status")
                .setContentText(messageBody)
                .setAutoCancel(true)
                .setSound(defaultSoundUri)
                .setContentIntent(pendingIntent);

        NotificationManager notificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

        notificationManager.notify(0, notificationBuilder.build());
    }
}