package com.orbisalert.net;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.orbisalert.Activity.GlobalConstants;
import com.orbisalert.Activity.TabHostActivity;
import com.orbisalert.BluetoothDevices.BluetoothLeService;
import com.orbisalert.BluetoothDevices.ProcessQueueExecutor;
import com.orbisalert.R;

/**
 * Created by nancy on 25/9/17.
 */

public class BluetoothDeviceReceiver extends BroadcastReceiver {
    String clicked_item = "", Connected_Item_DisplayName = "", Connected_Item_Device = "", Connectivity_Status = "";
    private BluetoothLeService mBluetoothLeService;
    SharedPreferences preferences;
    public ProcessQueueExecutor processQueueExecutor = new ProcessQueueExecutor();


    @Override
    public void onReceive(Context ctx, Intent intent) {

        String action = intent.getAction();
        BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        preferences = ctx.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        clicked_item = preferences.getString("Connected_Item", "");
        Connected_Item_DisplayName = preferences.getString("Connected_Item_DisplayName", "");
        Connected_Item_Device = preferences.getString("Connected_Item_Device", "");
        Connectivity_Status = preferences.getString("Connectivity_Status", "");


        if (BluetoothDevice.ACTION_FOUND.equals(action)) {


            // ... //Device found

        } else if (BluetoothDevice.ACTION_ACL_CONNECTED.equals(action)) {


            BluetoothDevice device11 = intent
                    .getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
            String devicename = device.getName().toString();


            // ... //Device is now connected
        } else if (BluetoothAdapter.ACTION_DISCOVERY_FINISHED.equals(action)) {


            // ... //Done searching
        } else if (BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED.equals(action)) {

            try {
                BluetoothDevice device11 = intent
                        .getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                String devicename = device11.getName().toString();
                String deviceAddress = device11.getAddress().toString();
                String devicestatus = device11.getUuids().toString();

                if (deviceAddress.equalsIgnoreCase(Connected_Item_Device)) {
                    Log.e("===", Connected_Item_Device);
                    Log.e("====", deviceAddress);
                    showNotification(ctx);

                    //ctx.unbindService(mServiceConnection);
                    processQueueExecutor.interrupt();
                    mBluetoothAdapter.disable();
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("Connected_Item");
                    editor.remove("Connected_Item_DisplayName");
                    editor.remove("Connected_Item_Device");
                    editor.remove("Connectivity_Status");
                    editor.apply();
                } else {
                    Log.e("====", "Another service");
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            Log.e("====+++++++", "Device Disconnect Request");
            // ... //Device is about to disconnect
        } else if (BluetoothDevice.ACTION_ACL_DISCONNECTED.equals(action)) {

            Log.e("===============", "Device Disconnect");

            try {
                BluetoothDevice device11 = intent
                        .getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                String devicename = device11.getName().toString();
                String deviceAddress = device11.getAddress().toString();
                String devicestatus = device11.getUuids().toString();

                if (deviceAddress.equalsIgnoreCase(Connected_Item_Device)) {
                    Log.e("===", Connected_Item_Device);
                    Log.e("====", deviceAddress);
                    showNotification(ctx);

                    //ctx.unbindService(mServiceConnection);
                    processQueueExecutor.interrupt();
                    mBluetoothAdapter.disable();
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("Connected_Item");
                    editor.remove("Connected_Item_DisplayName");
                    editor.remove("Connected_Item_Device");
                    editor.remove("Connectivity_Status");
                    editor.apply();
                } else {
                    Log.e("====", "Another service");
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            //... //Device has disconnected
        } else if (BluetoothDevice.ACTION_BOND_STATE_CHANGED.equals(action)) {

            int state = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE,
                    BluetoothAdapter.ERROR);
            Log.e("--------", String.valueOf(state));

        }
    }


    private void showNotification(Context ctx) {
        final NotificationManager mgr = (NotificationManager) ctx.getSystemService(Context.NOTIFICATION_SERVICE);
        NotificationCompat.Builder note = new NotificationCompat.Builder(ctx);
        note.setContentTitle("Bluetooth Disconnected");
        note.setAutoCancel(true);
        // to set default sound/light/vibrate or all
        note.setDefaults(Notification.DEFAULT_ALL);
        // Icon to be set on Notification
        note.setSmallIcon(R.drawable.app_icon);

        Uri uri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        note.setSound(uri);
        note.setPriority(Notification.PRIORITY_HIGH);
        // This pending intent will open after notification click
        PendingIntent pi = PendingIntent.getActivity(ctx, 0, new Intent(ctx,
                TabHostActivity.class), 0);
        // set pending intent to notification builder
        note.setContentIntent(pi);
        mgr.notify(101, note.build());
    }


    private final ServiceConnection mServiceConnection = new ServiceConnection() {

        @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            mBluetoothLeService = ((BluetoothLeService.LocalBinder) service).getService();
            if (!mBluetoothLeService.initialize()) {
                Log.e("8888888888888", "Unable to initialize Bluetooth");
                //ctx.finish();
            }
            // Automatically connects to the device upon successful start-up initialization.
            //  mBluetoothLeService.connect(mDeviceAddress);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            mBluetoothLeService = null;
        }
    };

}


