package com.orbisalert.Util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import com.orbisalert.R;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Utility {
    static Bitmap bitmap = null;

    // Method To Jump One Screen To Another..
    public final static void moveToNextActivity(final Context context, final Class<?> destination) {
        final Intent intent = new Intent(context, destination);
        context.startActivity(intent);
        ((Activity) context).finish();
    }


    //status bar color....
    public final static void status_bar_color_change(Activity context){
        if (android.os.Build.VERSION.SDK_INT >= 21){
            Window window = context.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(context.getResources().getColor(R.color.status_bar_color));
        }

    }

    //helvetica neue light font
    public final static void text_font_helvetica(Activity activity,TextView text) {
        Typeface typeface;
        typeface = Typeface.createFromAsset(activity.getAssets(), "fonts/helvetica-neue-light.ttf");
        text.setTypeface(typeface);
    }

}
