package com.orbisalert.Util;

import android.os.CountDownTimer;
import android.util.Log;

import java.util.concurrent.TimeUnit;


public class CounterClass extends CountDownTimer {

    private static String hms;
    private static CounterClass instance;
    private static long remaining;




    private CounterClass(long millisInFuture, long countDownInterval){
        super(millisInFuture,countDownInterval);
    }

    public static CounterClass  initInstance(long millisInFuture, long countDownInterval){
        instance=null;
        if(instance==null){
            instance =  new CounterClass(millisInFuture,countDownInterval);
        }
        return instance;
    }

    public static CounterClass  extendinitInstance(long millisInFuture, long countDownInterval){
        instance=null;
        if(instance==null){
            instance =  new CounterClass(millisInFuture,countDownInterval);
        }
        return instance;
    }




    public static CounterClass  getInstance() throws Exception{
        if(instance==null){

            throw new Exception("Parameters not initialized. Initiate with initInstance");
        }else{
            return instance;
        }
    }

    public void clear()
    {
        if (instance!=null) {
            instance = null;
        }
    }

    public static String getFormatedTime(){
        return hms;
    }

    public static void setFormatedTime(){

        hms=null;
        remaining=0;

    }
    @Override
    public void onTick(long l) {
        remaining= l;

        hms= String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(remaining),
                TimeUnit.MILLISECONDS.toMinutes(remaining) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(remaining)),
                TimeUnit.MILLISECONDS.toSeconds(remaining) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(remaining))
        );
    }

    @Override

    public void onFinish() {
       remaining=0;
        hms=null;

    }
}