package com.orbisalert;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;

import com.orbisalert.Activity.LoginScreen;
import com.orbisalert.Activity.OrbisActivity;
import com.orbisalert.Activity.TabHostActivity;
import com.orbisalert.Activity.WelcomeActivity;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.KillSignalAPICall;
import com.orbisalert.net.OnClearFromRecentService;
import com.orbisalert.net.SettingsAPICall;

import java.util.Timer;
import java.util.TimerTask;


public class SplashScren extends OrbisActivity {
    Timer timer=new Timer();
    String verifystatus="";
    String confirmstatus="";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash_scren);
        boolean firstRun=preferences.getBoolean("firstRun",false);
        verifystatus=preferences.getString("STATUS","");
        confirmstatus=preferences.getString("confirm","");

        Utility.status_bar_color_change(SplashScren.this);
        try {

            Intent serviceIntent = new Intent(this, OnClearFromRecentService.class);
            startService(serviceIntent);

        }catch (Exception e){
            e.printStackTrace();
        }



        if(firstRun==false)//if running for first time
        //Splash will load for first time
        {
            SharedPreferences.Editor editor=preferences.edit();
            editor.putBoolean("firstRun",true);
            editor.commit();
            move_Next_screen();

        }
        else
        {

            if(verifystatus.equalsIgnoreCase("1")){

                //Setting API Call
                SettingsAPICall.getSettings(SplashScren.this);

                //Signal call
                KillSignalAPICall.getKillSignal(SplashScren.this);

                //Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
                //startService(intent_service);

                Intent intent = new Intent(SplashScren.this,TabHostActivity.class);
                startActivity(intent);
                finish();

            }
            else {
                if (confirmstatus.equalsIgnoreCase("1")){
                Utility.moveToNextActivity(SplashScren.this, LoginScreen.class);
                overridePendingTransition(0, 0);
                finish();
                }
            else {
                    Intent intent = new Intent(SplashScren.this,WelcomeActivity.class);
                    startActivity(intent);
                    finish();

                }
            }
        }
    }





    private void move_Next_screen() {
        timer.schedule(new TimerTask() {
            public void run() {
                if(verifystatus.equalsIgnoreCase("1")){
                    Utility.moveToNextActivity(SplashScren.this,TabHostActivity.class);
                }
                else {

                    Log.e("++++++++++++++","======");
                    Utility.moveToNextActivity(SplashScren.this, WelcomeActivity.class);
                   // Utility.moveToNextActivity(SplashScren.this, LoginScreen.class);
                    overridePendingTransition(0, 0);
                    finish();
                }
            }
        },3000);
    }
}

/* */