/**
 * @author Rajiv Manivannan <rajiv@contus.in>
 * @copyright Copyright (C) 2014 VSNMobil. All rights reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 */
package com.orbisalert.BluetoothDevices;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.orbisalert.R;

import java.util.List;

/**
 * ScannedDeviceAdapter.java
 *
 * This adapter is used to load the scanned puck in list view.
 *
 */
public class ScannedDeviceAdapter extends ArrayAdapter<ScannedDevice> {
    private List<ScannedDevice> list;
    private LayoutInflater inflater;
    private int resId;
    TextView deviceNameTextview;
    TextView deviceAddress;

    // Constructor
    public ScannedDeviceAdapter(Context context, int resId,
                                List<ScannedDevice> objects) {
        super(context, resId, objects);
        inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        this.resId = resId;
        list = objects;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ScannedDevice item = (ScannedDevice) getItem(position);

        if (convertView == null) {
            convertView = inflater.inflate(resId, null);
        }
        deviceNameTextview = (TextView) convertView
                .findViewById(R.id.device_name);
        deviceAddress = (TextView) convertView
                .findViewById(R.id.device_address);
        TextView device_status = (TextView) convertView.findViewById(R.id.device_status);
        deviceNameTextview.setText(item.getDevice().getName());
        deviceAddress.setText(item.getDevice().getAddress());
        if (item.getDeviceConnectivityStatus() != null) {
            device_status.setText(item.getDeviceConnectivityStatus());
        }
        return convertView;
    }

    /** add or update BluetoothDevice */
    public void update(BluetoothDevice newDevice, int rssi, byte[] scanRecord) {
        if ((newDevice == null) || (newDevice.getAddress() == null)) {
            return;
        }
        boolean contains = false;
        for (ScannedDevice device : list) {
            if (newDevice.getAddress().equals(device.getDevice().getAddress())) {
                contains = true;
                device.setRssi(rssi); // update
                break;
            }
        }
        String deviceDisplayName = newDevice.getName();
        if ((deviceDisplayName == null) || (deviceDisplayName.length() == 0)) {
            contains = true;
        }
        if (!contains) {
            // add new BluetoothDevice into the adapter.
            list.add(new ScannedDevice(newDevice, rssi));
        }
        // Refresh the list view.
        notifyDataSetChanged();
    }

    public void updateStatus(String status, String devicename, String ddeviceAddress) {
        for (ScannedDevice device : list) {
            if (status.equalsIgnoreCase("Connected")) {
                device.setDeviceConnectivityStatus("Disconnected");
            } else {
                device.setDeviceConnectivityStatus("Disconnected");
            }
            notifyDataSetChanged();
        }
    }
}