/**
 * @author    Rajiv Manivannan <rajiv@contus.in>
 * @copyright  Copyright (C) 2014 VSNMobil. All rights reserved.
 * @license    http://www.apache.org/licenses/LICENSE-2.0
 */
package com.orbisalert.BluetoothDevices;

import android.bluetooth.BluetoothDevice;
import android.util.Log;

/**
 * ScannedDevice.java
 * Model class that provides details about device name, device MAC address and RSSI value.
 *
 */
public class ScannedDevice {
    private static final String UNKNOWN = "Unknown";
    /** BluetoothDevice */
    private BluetoothDevice bluetoothDevice;
    /** RSSI */
    private int rssiValue;
    /** Display Name */
    private String deviceDisplayName;
    /** Device MAC Address */
    private String deviceDiplayAddress;
    /** DEvice Connectivity Status*/
    private String deviceConnectivityStatus;

    public ScannedDevice(BluetoothDevice device, int rssi) {
        if (device == null) {
            throw new IllegalArgumentException("BluetoothDevice is null");
        }
        bluetoothDevice = device;
      //  Log.e("44444444",device.getName().toString());
        deviceDisplayName = device.getName();
        if ((deviceDisplayName == null) || (deviceDisplayName.length() == 0)) {
            deviceDisplayName = UNKNOWN;
        }
        rssiValue = rssi;
        deviceDiplayAddress =  device.getAddress();

    }

    public BluetoothDevice getDevice() {
        return bluetoothDevice;
    }

    public int getRssi() {
        return rssiValue;
    }

    public void setRssi(int rssi) {
        rssiValue = rssi;
    }

    public String getDisplayName() {
        return deviceDisplayName;
    }

    public void setDisplayName(String displayName) {
        deviceDisplayName = displayName;
    }
    
    public String getDeviceMac() {
        return deviceDiplayAddress;
    }

    public void setDeviceMac(String deviceAddress) {
        deviceDiplayAddress = deviceAddress;
    }


    public String getDeviceConnectivityStatus(){
        return deviceConnectivityStatus;
    }

    public void setDeviceConnectivityStatus(String deviceConnectivityStatus) {
        this.deviceConnectivityStatus = deviceConnectivityStatus;
    }
}
