package com.orbisalert.Activity;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TabActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TabHost;
import android.widget.Toast;

import com.orbisalert.Model.SignalBeans;
import com.orbisalert.Model.UserDataBeans;
import com.orbisalert.Model.VerifyBeans;
import com.orbisalert.R;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.NfcSignal;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.WebRequest;

import java.io.IOException;
import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TabHostActivity extends TabActivity {

    private int current_tab;
    private int selected_tab;
    private TabHost tabHost;
    RelativeLayout rl_alert;
    ImageView iv_alert, img_signal1;
    int[] imageArray = {R.drawable.ic_one_signal, R.drawable.ic_two_signals, R.drawable.ic_three_signal};
    LinearLayout ll_view;
    private static final int MIN_CLICK_DURATION = 2000;
    private long startClickTime;
    boolean longClickActive = false;
    public SharedPreferences preferences;
    Handler handler = new Handler();
    ImageView iv_one, iv_two, iv_three;
    private NfcAdapter mNfcAdapter;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    String  datetime,imei,number,messageType,lat,lng,posdatatime,postype,status="",interval,speed;
    WebRequest mWebrequest;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tab_host);
        //new tab
        mNfcAdapter = NfcAdapter.getDefaultAdapter(this);

        /***
         * return selected tab
         */
        rl_alert = (RelativeLayout) findViewById(R.id.rl_alert);
        iv_alert = (ImageView) findViewById(R.id.iv_alert);
        rl_alert.setOnTouchListener(speakTouchListener);
        ll_view = (LinearLayout) findViewById(R.id.ll_1);
        //new addition
        iv_one = (ImageView) findViewById(R.id.ic_one);
        iv_two = (ImageView) findViewById(R.id.ic_two);
        iv_three = (ImageView) findViewById(R.id.ic_three);


        //img_signal1= (ImageView) findViewById(R.id.img_signal1);
        preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        //intialize();
        Intent i = getIntent();
        selected_tab = i.getIntExtra("tab", -1);

        if (current_tab != -1) {
            // Open the right tab
            setTabs(selected_tab);
            System.err.print("This is in method" + current_tab);

        } else {
            setTabs(current_tab);
        }
        tabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener() {
            @Override
            public void onTabChanged(String arg0) {
                setTabColor(tabHost);

            }
        });
        setTabColor(tabHost);
    }

    private void setTabs(int current_tab) {
        addTab("", R.drawable.hme_bottom, DashboardScreen.class);
        addTab("", R.drawable.loc_bottom, MapboxActivity.class);
        addTab("", R.drawable.circle, DashboardScreen.class);
        addTab("", R.drawable.msg_bottom, MessageScreen.class);
        addTab("", R.drawable.fall_bottom, FallMoveDetectActivity.class);
        tabHost.setCurrentTab(current_tab);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        current_tab = getIntent().getIntExtra("tab", 0);
        tabHost.setCurrentTab(current_tab);
        try {

            NfcManager manager = (NfcManager) this.getSystemService(Context.NFC_SERVICE);
            NfcAdapter adapter = manager.getDefaultAdapter();
            if (adapter != null && adapter.isEnabled()) {

                //Yes NFC available

            Tag tag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

            Log.d("+++++++", "onNewIntent: " + intent.getAction());

            if (tag != null) {

                showNotification();
                //Toast.makeText(this, getString(R.string.message_tag_detected), Toast.LENGTH_SHORT).show();
                Ndef ndef = Ndef.get(tag);
                onNfcDetected(ndef);

            }
            }
            else{

                Toast.makeText(TabHostActivity.this,"Your device doesn't support NFC",Toast.LENGTH_LONG);
                //Your device doesn't support NFC
            }



        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    //Change the background color of tab
    public void setTabColor(TabHost tabhost) {

        for (int i = 0; i < tabhost.getTabWidget().getChildCount(); i++)
            tabhost.getTabWidget().getChildAt(i).setBackgroundColor(Color.parseColor("#6D5E82")); //unselected

        if (tabhost.getCurrentTab() == 0)
            tabhost.getTabWidget().getChildAt(tabhost.getCurrentTab()).setBackgroundColor(Color.parseColor("#583975")); //1st tab selected
        else
            tabhost.getTabWidget().getChildAt(tabhost.getCurrentTab()).setBackgroundColor(Color.parseColor("#583975")); //2nd tab selected

        if (tabhost.getCurrentTab() == 2) {
            tabhost.getTabWidget().getChildAt(tabhost.getCurrentTab()).setBackgroundColor(Color.parseColor("#6D5E82")); //1st tab selected

        }

    }

    private void addTab(String labelId, int drawableId, Class<?> c) {

        tabHost = getTabHost();

        Intent intent = new Intent(this, c);
        TabHost.TabSpec spec = tabHost.newTabSpec("tab" + labelId);

        @SuppressWarnings("deprecation")
        View tabIndicator = LayoutInflater.from(this).inflate(R.layout.tab_icon, getTabWidget(),
                false);
        ImageView icon = (ImageView) tabIndicator.findViewById(R.id.icon);
        icon.setImageResource(drawableId);
        spec.setIndicator(tabIndicator);
        spec.setContent(intent);
        tabHost.addTab(spec);
    }

    private View.OnTouchListener speakTouchListener = new View.OnTouchListener() {
        @Override
        public boolean onTouch(View pView, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    if (longClickActive == false) {
                        longClickActive = true;
                        startClickTime = Calendar.getInstance().getTimeInMillis();

                    }
                    // img_signal1.setVisibility(View.VISIBLE);

                    //image_Show();
                    //for initial delay.
                    break;
                // new condition added
                case MotionEvent.ACTION_UP:
                    Log.e("LONGUP", "============");
                    longClickActive = false;
                    ll_view.setVisibility(View.INVISIBLE);
                    // image_Show("0");
                    handler.removeCallbacks(mHandlerTask);
                    handler.removeCallbacksAndMessages(null);
                    //handler.removeCallbacks(null);

                    break;
                case MotionEvent.ACTION_POINTER_DOWN:

                    break;
                case MotionEvent.ACTION_POINTER_UP:

                    break;
                case MotionEvent.ACTION_MOVE:
                    if (longClickActive == true) {
                        Vibrator vibe = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
                        vibe.vibrate(1000);
                        //img_signal1.setVisibility(View.VISIBLE);
                        handler = new Handler();
                        mHandlerTask.run();

                        //image_Show("1");
                        //for initial delay.
                        //handel.postDelayed(run, 3000);
                        long clickDuration = Calendar.getInstance().getTimeInMillis() - startClickTime;
                        if (clickDuration >= 1000) {
                            longClickActive = false;
                            handler.removeCallbacks(mHandlerTask);
                            handler.removeCallbacksAndMessages(null);
                            iv_one.setVisibility(View.GONE);
                            iv_two.setVisibility(View.GONE);
                            iv_three.setVisibility(View.GONE);

                            SharedPreferences.Editor editorr = preferences.edit();
                            editorr.putString("Triggerfrom", "RedAlert");
                            editorr.putString("redalert", "2");
                            editorr.commit();
                            Intent inte = new Intent(TabHostActivity.this, RedAlertActivate.class);
                            startActivity(inte);
                            finish();
                        }
                    }
                    break;
            }

            return true;
        }
    };


    public void show_image() {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                //I want to display this images in 2 second count
                iv_one.setVisibility(View.VISIBLE);
                iv_two.setVisibility(View.GONE);
                iv_three.setVisibility(View.GONE);

            }
        }, (long) (1 * 1000));

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {


                //I want to display this image in 3 second count
                iv_one.setVisibility(View.GONE);
                iv_two.setVisibility(View.VISIBLE);
                iv_three.setVisibility(View.GONE);
            }
        }, (long) (2 * 1000));

        new Handler().postDelayed(new Runnable() {
                                      @Override
                                      public void run() {

                                          //I want to display this image in 4 second count
                                          iv_one.setVisibility(View.GONE);
                                          iv_two.setVisibility(View.GONE);
                                          iv_three.setVisibility(View.VISIBLE);


                                      }

                                  },

                (long) (3 * 1000));
    }


    Runnable mHandlerTask = new Runnable() {
        int i = 0;

        public void run() {

            show_image();
            handler.postDelayed(mHandlerTask, 3000);

        }

    };


    @Override
    public void onBackPressed() {
        super.onBackPressed();
        //finish();
        showBuilder1(TabHostActivity.this, "Orbis App", "Do you really want to exit this app?");
    }

    public void showBuilder1(@NonNull Context context, @NonNull String title, @NonNull String message) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
                TabHostActivity.this.finish();
            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();

            }
        });
        builder.show();
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            mNfcAdapter = NfcAdapter.getDefaultAdapter(this);

//            if (!mNfcAdapter.isEnabled()) {
//                Toast.makeText(getApplicationContext(), "Please activate NFC and press Back to return to the application!", Toast.LENGTH_LONG).show();
//                //startActivity(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS));
//                startActivity(new Intent(Settings.ACTION_NFC_SETTINGS));
//            }



            Log.e("==========", "NFCCC Connected");
            IntentFilter tagDetected = new IntentFilter(NfcAdapter.ACTION_TAG_DISCOVERED);
            IntentFilter ndefDetected = new IntentFilter(NfcAdapter.ACTION_NDEF_DISCOVERED);
            IntentFilter techDetected = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);
            IntentFilter[] nfcIntentFilter = new IntentFilter[]{techDetected, tagDetected, ndefDetected};

            PendingIntent pendingIntent = PendingIntent.getActivity(
                    this, 0, new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
            if (mNfcAdapter != null)
                mNfcAdapter.enableForegroundDispatch(this, pendingIntent, nfcIntentFilter, null);



        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mNfcAdapter != null)
            mNfcAdapter.disableForegroundDispatch(this);
    }


    public void onNfcDetected(Ndef ndef) {

        readFromNFC(ndef);
    }

    private void readFromNFC(Ndef ndef) {

        try {
            ndef.connect();
            NdefMessage ndefMessage = ndef.getNdefMessage();
            String message = new String(ndefMessage.getRecords()[0].getPayload());
            Log.e("========", "readFromNFC: " + message);
            if (message != "") {

                SharedPreferences.Editor editorr = preferences.edit();
                editorr.putString("Triggerfrom", "TAG");
                //editorr.putString("redalert", "2");
                editorr.putString("msgtype", "TAG");
                editorr.putString("statustype", message);
                editorr.commit();
                SignalCall(message,"TAG");
               /// Intent inte = new Intent(TabHostActivity.this, RedAlertActivate.class);
                //startActivity(inte);
               // finish();

            }
            // mTvMessage.setText(message);
            ndef.close();

        } catch (IOException | FormatException e) {
            e.printStackTrace();

        }
    }


    private void showNotification() {
        final NotificationManager mgr = (NotificationManager) this
                .getSystemService(Context.NOTIFICATION_SERVICE);
        NotificationCompat.Builder note = new NotificationCompat.Builder(this);
        note.setContentTitle("NFC Tag Detected");
        note.setAutoCancel(true);
        // to set default sound/light/vibrate or all
        note.setDefaults(Notification.DEFAULT_ALL);
        // Icon to be set on Notification
        note.setSmallIcon(R.drawable.app_icon);

        Uri uri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        note.setSound(uri);
        note.setPriority(Notification.PRIORITY_HIGH);
        // This pending intent will open after notification click
        PendingIntent pi = PendingIntent.getActivity(this, 0, new Intent(this,
                TabHostActivity.class), 0);
        // set pending intent to notification builder
        note.setContentIntent(pi);
        mgr.notify(101, note.build());
    }



    public void SignalCall(String msgg,String msgType){


        TriggerSignal.sendTriggerSignal(TabHostActivity.this,msgg,"");

        NfcSignal.sendNFCSignal(TabHostActivity.this,msgg,msgType);


    }











}



