package com.orbisalert.Activity;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.orbisalert.R;
import com.orbisalert.Util.CounterClass;
import com.orbisalert.notifications.FallDetectCounter;
import com.orbisalert.Util.MyService;
import com.orbisalert.Util.NoMovementService;
import com.orbisalert.Util.SOSService;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.FallHandler;
import com.orbisalert.net.PwonSignal;
import com.orbisalert.net.Test;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.UpdateLocationIntentService;

import de.hdodenhof.circleimageview.CircleImageView;

public class ProfileScreen extends OrbisActivity implements View.OnClickListener {

    RelativeLayout rl_setting, rl_logout, rl_message;
    CircleImageView iv_user_profile;
    ImageView iv_back;
    String UserName,cityName,userImage="";
    TextView tv_user_name,tv_user_desc;
    CounterClass counterClass;
    FallDetectCounter fallCounter;
    String timerrunning="",falltimerRunning="";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_profile_screen);
        Utility.status_bar_color_change(this);
        UserName=preferences.getString("Name", "");
        userImage= preferences.getString("userImage","");
        timerrunning=preferences.getString("timerrunning","");
        falltimerRunning=preferences.getString("falltimerrunning","");


        intialize_Id();
    }

    /**
     * Id's intialization
     */

    private void intialize_Id() {
        tv_user_desc=(TextView)findViewById(R.id.tv_user_desc);
        cityName=preferences.getString("City", "");

        if(cityName.equalsIgnoreCase("")){
            tv_user_desc.setText("No Location Found");

        }else{
            tv_user_desc.setText(cityName);
        }
        tv_user_name=(TextView)findViewById(R.id.tv_user_name);
        tv_user_name.setText(UserName);

        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
        rl_message = (RelativeLayout) findViewById(R.id.rl_message);
        rl_setting = (RelativeLayout) findViewById(R.id.rl_setting);
        rl_logout = (RelativeLayout) findViewById(R.id.rl_logout);
        rl_setting.setOnClickListener(this);
        rl_logout.setOnClickListener(this);
        iv_user_profile = (CircleImageView) findViewById(R.id.iv_user_profile);

//        Glide.with(this).load(userImage).centerCrop().error(R.drawable.orbis_man)
//                .into(iv_user_profile);

        if (userImage.equalsIgnoreCase("http://54.218.78.31:50/dev//img/dashboardImage.png")){
            Glide.with(this)
                    .load(R.drawable.orbis_man)
                    .centerCrop()
                    .error(R.drawable.orbis_man)
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .into(iv_user_profile);


        }else {


            Glide.with(this)
                    .load(userImage)
                    .centerCrop()
                    .error(R.drawable.orbis_man)
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .into(iv_user_profile);
        }


    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.rl_logout:
                String ref = "ref";
                logout(ref);
                break;
            case R.id.iv_back:
                Intent intent = new Intent(ProfileScreen.this,TabHostActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();

                break;
            case R.id.rl_setting:
                Intent intent2 = new Intent(ProfileScreen.this,SettingScreen.class);
                intent2.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent2);
                finish();

                break;

            default:
                //sb android developer dhundne lge
        }

    }
    private void logout(String ref){
        try {
             /*delete cache*/
            deleteCache(ProfileScreen.this);
            SharedPreferences.Editor editor3 = preferences.edit();
            editor3.putString("Triggerfrom","PWOFF");
            editor3.commit();

            TriggerSignal.sendTriggerSignal(ProfileScreen.this,"","");

            if (timerrunning.equalsIgnoreCase("1")) {

                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("timerrunning", "0");
                editor.commit();
                Test.clearInstance();
                // counterClass = CounterClass.logoutinitInstance(0,0);
                counterClass = CounterClass.getInstance();
                counterClass.setFormatedTime();
                counterClass.clear();
                counterClass.cancel();
                counterClass = null;

            } else {
                Log.e("This is timer not running", "====");
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if (falltimerRunning.equalsIgnoreCase("1")) {

            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("falltimerrunning", "0");
            editor.commit();
            Test.clearInstance();
            // counterClass = CounterClass.logoutinitInstance(0,0);
            try {
                FallHandler.clearInstance();
                fallCounter = FallDetectCounter.getInstance();
                fallCounter.setFallFormatedTime();
                fallCounter.clear();
                fallCounter.cancel();
                fallCounter = null;
            } catch (Exception e) {
                e.printStackTrace();
            }


        } else {
            Log.e("This is timer not running", "====");
        }



        SharedPreferences.Editor editor = preferences.edit();
        editor.remove("STATUS");
        editor.remove("selectedminute");
        editor.remove("selectedsecond");
        editor.remove("FallDetection");
        editor.remove("fallDetected");
        editor.remove("MoveDetection");
        editor.remove("moveChecked");
        editor.remove("selectedHours");
        editor.remove("selectedMinutes");
        editor.apply();

        preferences.getBoolean("dashfirstRun", false);

        editor.commit();

        //counterClass.clear();

        PwonSignal.sendPWONSignal(getApplicationContext(),"PWOFF");
        //Stop SOS SERVICE



        //TriggerSignal.sendTriggerSignal(ProfileScreen.this);

        Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
        stopService(intent_service);

        // STop fall detect
        Intent intentss = new Intent(getApplicationContext(), MyService.class);
        stopService(intentss);

        // Stop getting device movement
        Intent mmoveintent = new Intent(getApplicationContext(), NoMovementService.class);
        stopService(mmoveintent);


        try{
            AlarmManager alarmManager = (AlarmManager)getSystemService(Context.ALARM_SERVICE);
            Intent alarm = new Intent(ProfileScreen.this, UpdateLocationIntentService.class);
            PendingIntent pendingIntent = PendingIntent.getService(ProfileScreen.this, 0, alarm, 0);
            alarmManager.cancel(pendingIntent);
            Log.e("==========","STop Alarm");
        }catch (Exception e){
            e.printStackTrace();
        }




        Intent intent = new Intent(ProfileScreen.this,LoginScreen.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        finish();

    }



}