package com.orbisalert.Activity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.orbisalert.Model.SignalBeans;
import com.orbisalert.R;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.GPSTracker;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.WebRequest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class MessageScreen extends OrbisActivity implements View.OnClickListener, View.OnTouchListener {
    TextView tv_message, tv_Title;
    ImageView iv_send_message, iv_back;
    EditText et_message;
    Spinner sp_status;
    RelativeLayout rl;
    WebRequest mWebrequest;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    String datetime, imei, number, messageType, currentLat, currentLong, posdatatime, postype, status, interval, speed;
    String date, time;
    TelephonyManager tManager;
    String phoneNumber = "07786200129";
    String checksum = "";
    String fcmstatus = "", fcmmessage = "";
    GPSTracker gps;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_message__screen);
        mWebrequest = WebRequest.getSingleton(MessageScreen.this);
        //change status bar color
        Utility.status_bar_color_change(MessageScreen.this);
        date = get_current_date();
        time = get_current_time();
        tManager = (TelephonyManager) getBaseContext()
                .getSystemService(Context.TELEPHONY_SERVICE);
        datetime = date + time;
        imei = tManager.getDeviceId();
        number = preferences.getString("number", "");
        posdatatime = date + time;
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");
        speed = GlobalConstants.SPEED;
        try {
            gps = new GPSTracker(MessageScreen.this);
            currentLat = String.valueOf(gps.getLatitude());
            currentLong = String.valueOf(gps.getLongitude());
            Log.e("TRIGGER========", currentLat);
            Log.e("TRIGGEER========", currentLong);

            if (currentLat.equalsIgnoreCase("0.0")) {

                currentLat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++++", currentLat);

            } else {
            }
            if (currentLong.equalsIgnoreCase("0.0")) {
                currentLong = preferences.getString("currentLONGITUDE", "");
                Log.e("+++++++", currentLong);
            } else {
                Log.e("+++++++", currentLong);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        //find view by id
        intialize_ID();
    }

    private void intialize_ID() {
        rl = (RelativeLayout) findViewById(R.id.rl);
        tv_Title = (TextView) findViewById(R.id.tv_Title);
        Utility.text_font_helvetica(this, tv_Title);
        tv_message = (TextView) findViewById(R.id.tv_message);
        Utility.text_font_helvetica(this, tv_message);
        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
        sp_status = (Spinner) findViewById(R.id.sp_status);
        iv_send_message = (ImageView) findViewById(R.id.iv_send_message);
        iv_send_message.setOnClickListener(this);
        et_message = (EditText) findViewById(R.id.et_message);
        rl.setOnTouchListener(this);

        //set spinner value
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.array_current_status, R.layout.spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        sp_status.setAdapter(adapter);

        showLog(String.valueOf(sp_status.getSelectedItem()));
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                onBackPressed();
                break;

            case R.id.iv_send_message:
                if (et_message.getText().toString().equalsIgnoreCase("")) {
                    showToast("Please enter message");
                    et_message.requestFocus();
                    showLog(et_message.getText().toString());


                } else {
                    String msg = et_message.getText().toString().replace(",", "");
                    status = String.valueOf(sp_status.getSelectedItem()) + ":" + msg;
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.putString("messageStatus",String.valueOf(sp_status.getSelectedItem()));
                            //+":"+et_message.getText().toString());
                    editor.putString("Triggerfrom", "Message");
                    editor.commit();

                    TriggerSignal.sendTriggerSignal(MessageScreen.this, status, "");


                    if (isNetworkAvailable()) {
                        date = get_current_date();
                        time = get_current_time();
                        interval = "";
                        speed = "";
                        messageType = "STA";
                        postype = "GPS";
                        String msg1 = et_message.getText().toString().replace(",", "");
                        status = String.valueOf(sp_status.getSelectedItem()) + ":" + msg1;

                        if (posdatatime == "") {
                            posdatatime = date + time;
                        }
                        if (fcmstatus.equalsIgnoreCase("0")) {

                        } else {
                            speed = GlobalConstants.SPEED;
                            signal_Send(date + time, imei, number, messageType, currentLat, currentLong, date + time, postype, status, interval, speed);
                        }
                        sp_status.setSelection(0);
                        et_message.setText("");
                    } else {
                        date = get_current_date();
                        time = get_current_time();
                        messageType = "STA";
                        postype = "GPS";
                        interval = "";
                        String msg2 = et_message.getText().toString().replace(",", "");
                        status = String.valueOf(sp_status.getSelectedItem()) + ":" + msg2;
                        String messagechck = "PRT" + "," + date + time + "," + imei + "," + number + "," + messageType + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed;
                        checksum = md5(messagechck);

                        date = get_current_date();
                        time = get_current_time();
                        if (posdatatime == "") {
                            posdatatime = date + time;
                        }
                        speed = GlobalConstants.SPEED;
                        String messagesend = "PRT" + "," + date + time + "," + imei + "," + number + "," + "STA" + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;

                        if (fcmstatus.equalsIgnoreCase("0")) {


                        } else {
                            phoneNumber ="07860047514";
                            SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                        }
                        sp_status.setSelection(0);
                        showToast("message sent");
                        et_message.setText("");
                    }
                }

                break;
            default:
        }
    }

    private void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private void getSignalResponse(final Call<SignalBeans> signalResp) {
        //showProgressDialog(MessageScreen.this, "Message Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();


                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        String message = response.body().getMessage().toString();
                        showToast("message sent");
                    } else {
                        Log.e("In condition", "Failed");
                        showToast("Message Sending Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //  dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.
                INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
        return true;
    }

}
