package com.orbisalert.Activity;

import android.app.AlarmManager;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.drawable.ColorDrawable;
import android.location.Geocoder;
import android.location.LocationManager;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.iid.FirebaseInstanceId;
import com.orbisalert.Model.LoginBeans;
import com.orbisalert.Model.UserDataBeans;
import com.orbisalert.Model.VerifyBeans;
import com.orbisalert.Model.Verify_otp_beans;
import com.orbisalert.R;
import com.orbisalert.Util.SOSService;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.GPSTracker;
import com.orbisalert.net.KillSignalAPICall;
import com.orbisalert.net.PwonSignal;
import com.orbisalert.net.SettingsAPICall;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.UpdateLocationIntentService;

import com.orbisalert.net.Update_locationCall;
import com.orbisalert.net.WebRequest;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class LoginScreen extends OrbisActivity implements View.OnClickListener, View.OnTouchListener {
    TextView tv_login;
    WebRequest mWebrequest;
    EditText et_phone;
    Dialog dialog1;
    RelativeLayout rl_phone, rl_login1;
    Button btn_cancel_otp, btn_login_otp;
    EditText et_otp;
    Call<LoginBeans> loginResponseCall;
    LoginBeans loginResponse;
    Call<VerifyBeans> otpverify_ResponseCall;
    VerifyBeans verify_otpresponse;
    ImageView btn_login;
    String get_otp;
    String number, device_id, device_token;
    String device_type = "android";
    TextView resend_otp;
    String first_time = "";
    String ref_id = "", app_type = "Orbis";
    String fcmstatus = "", fcmmessage = "";
    Timer timer = new Timer();
    String ref_id1 = "";
    GPSTracker gps;
    public final static int INTERVAL_update = 1000 * 60 * 5; //5 minutes
    AlarmManager alarmManager;
    PendingIntent pendingIntent;
    Calendar calendar;
    Intent alarm;
    final int SDK_INT = Build.VERSION.SDK_INT;
    double latt, lngg;
    String lat, lng;
    private NfcAdapter mNfcAdapter;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login_screen);

        mWebrequest = WebRequest.getSingleton(LoginScreen.this);
        dialog1 = new Dialog(LoginScreen.this);
        // FirebaseInstanceId.getInstance().getToken();

        fcmstatus = preferences.getString("FCMSignalStatusHS2", "");
        fcmmessage = preferences.getString("FCMSignalmessageHS2", "");
        //changing statusbar color
        Utility.status_bar_color_change(LoginScreen.this);
        try {


            mNfcAdapter = NfcAdapter.getDefaultAdapter(this);
            if (!mNfcAdapter.isEnabled())
            {
                showNFCAlert();
//                Toast.makeText(getApplicationContext(), "Please activate NFC and press Back to return to the application!", Toast.LENGTH_LONG).show();
//                //startActivity(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS));
//                startActivity(new Intent(Settings.ACTION_NFC_SETTINGS));
            }

           // showAlert();

            gps = new GPSTracker(this);
            LocationManager lm = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
            boolean gps_enabled = false;
            boolean network_enabled = false;

            try {
                gps_enabled = lm.isProviderEnabled(LocationManager.GPS_PROVIDER);
            } catch (Exception ex) {
            }

            try {
                network_enabled = lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            } catch (Exception ex) {
            }

            if (!gps_enabled && !network_enabled) {
                // notify user
                AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
                dialog.setMessage(this.getResources().getString(R.string.gps_network_not_enabled));
                dialog.setPositiveButton(this.getResources().getString(R.string.open_location_settings), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub
                        Intent myIntent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                        startActivity(myIntent);
                        //get gps
                    }
                });
                dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub

                    }
                });
                dialog.show();
            }


        } catch (Exception e) {
            e.printStackTrace();
        }



//        try{
//            if (gps.getLatitude()==0){
//                showAlert();
//            }
//            else{
//
//            }
//        }catch (Exception e){
//            e.printStackTrace();
//        }


        //find view by id
        intialize_ID();

    }

    private void intialize_ID() {
        //Get Device ID
        device_id = Settings.Secure.getString(LoginScreen.this.getContentResolver(), Settings.Secure.ANDROID_ID);
       /* device_token=preferences.getString("refreshedToken", "");*/
        Log.e("8888888",device_id);

        rl_login1 = (RelativeLayout) findViewById(R.id.rl_login1);
        rl_login1.setOnTouchListener(this);
        btn_login = (ImageView) findViewById(R.id.btn_login);
        btn_login.setOnClickListener(this);
        rl_phone = (RelativeLayout) findViewById(R.id.rl_phone);
        rl_phone.getBackground().setAlpha(45);
        et_phone = (EditText) findViewById(R.id.et_phone);
        tv_login = (TextView) findViewById(R.id.tv_login);
        Utility.text_font_helvetica(this, tv_login);
        //new <code></code>
        try {
            gps = new GPSTracker(LoginScreen.this);
            lat = String.valueOf(gps.getLatitude());
            lng = String.valueOf(gps.getLongitude());
            Log.e("Login========", lat);
            Log.e("Login========", lng);

            if (lat.equalsIgnoreCase("0.0")) {

                lat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++++", lat);

            } else {

            }

            if (lng.equalsIgnoreCase("0.0")) {

                lng = preferences.getString("currentLONGITUDE", "");
                Log.e("+++++++", lng);

            } else {

                Log.e("+++++++", lng);
            }


        } catch (Exception e) {
            e.printStackTrace();

        }

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_login:
                Log.e("BTNNNNNNNNNNNNN", "");
                if (isNetworkAvailable()) {
                    try {
                        if (et_phone.getText().toString().equalsIgnoreCase("")) {
                            showToast("Please enter phone number");
                            et_phone.requestFocus();
                        } else {
                            if (fcmstatus.equalsIgnoreCase("0")) {
                                Log.e("ENTER SIGNAL NOT ALLOWED", "====");
                            } else {
                                number = et_phone.getText().toString().trim();
                                SharedPreferences.Editor editor = preferences.edit();
                                editor.putString("NUMBER", number);
                                editor.commit();
                                login(number);


//                                    double lattitude = gps.getLatitude();
//                                    if (gps.getLatitude() == 0.0) {
//                                        showAlert();
//                                    } else {
//                                        login(number);
//                                    }


                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    showBuilder(LoginScreen.this, "Network Error", "Please Connect to the Internet");
                }
                break;
            case R.id.btn_cancel_otp:
                showToast("Cancel");
                dialog1.dismiss();
                dialog1=null;
                break;

            case R.id.btn_login_otp:
                Log.e("=======","=======");
                if (et_otp.getText().toString().equalsIgnoreCase("")) {
                    showToast("Please Enter OTP");
                } else {
                    if (fcmstatus.equalsIgnoreCase("0")) {
                        Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                    } else {

                        first_time = "First_time";
                        String otp_final = et_otp.getText().toString();
                        device_token = FirebaseInstanceId.getInstance().getToken();
                        Log.e("device_token", "" + device_token);
                        Log.e("device id",device_id);

                       // number, device_type, device_token, device_id, app_type, otp
                        verify_OTP(number, app_type, device_type, device_id, device_token, otp_final);
                    }
                }
                break;
            case R.id.resend_otp:
                first_time = "RESEND";
                String resend_number = preferences.getString("NUMBER", "");
                login(resend_number);
                break;
            default:
        }
    }

    private void verify_OTP(String number, String app_type, String device_type, String device_id, String device_token, String verifyotp) {
        showLog(number);

        showLog(get_otp);

        otpverify_ResponseCall = mWebrequest.apiInterface.verifyOTP(number, app_type, device_type, device_id, device_token, verifyotp);

        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("number", number);
        editor.commit();
        showLog(number);
        getVerifyOtpResponse(otpverify_ResponseCall);
    }

    //Verify OTP API Response
    private void getVerifyOtpResponse(final Call<VerifyBeans> otpverifyResp) {
        showProgressDialog(LoginScreen.this, "OTP Verify...");
        otpverifyResp.enqueue(new Callback<VerifyBeans>() {
            @Override
            public void onResponse(Call<VerifyBeans> call, Response<VerifyBeans> response) {

                if (response.isSuccessful()) {
                    verify_otpresponse = response.body();
                    //Log.e("verify respose ", String.valueOf(verify_otpresponse));

                    String status = response.body().getStatus().toString();
                    String message = response.body().getMessage().toString();
                    Log.e("ll", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        UserDataBeans userdata = verify_otpresponse.getData();
                        String name = userdata.getFullname().toString();
                        ref_id = userdata.getRef().toString();
                        String email = userdata.getEmailaddress().toString();
                        // String userimage=userdata.getUser_image().toString();

                        String address = userdata.getContractarea().toString();
                        //showToast(message);
                        String officeAdd = userdata.getOffice().toString();
                        Log.e("=====",address);
                        Log.e("=======",officeAdd);
                        Log.e("=======",email);
                        Log.e("=======",name);

                        //showToast(message);

                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("Name", name);
                        editor.putString("useremail", email);
                        editor.putString("address_one", address);
                        editor.putString("address_two", officeAdd);
                        editor.putString("STATUS", status);
                        editor.putString("REF_ID", ref_id);
                        editor.putString("Triggerfrom", "PUD");
                        editor.putString("SOSDetected","1");
                        editor.putString("pressdetectedlevel","2");
                        editor.commit();
                        gps = new GPSTracker(LoginScreen.this);
                        latt = gps.getLatitude();
                        lngg = gps.getLongitude();


                        Update_locationCall.sendUpdateSignal(LoginScreen.this, latt, lngg);


                        //new data
                        calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        int interval = 1000 * 60 * 15;

                        alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
                        alarm = new Intent(LoginScreen.this, UpdateLocationIntentService.class);
                        pendingIntent = PendingIntent.getService(LoginScreen.this, 0, alarm, 0);

                        if (SDK_INT < Build.VERSION_CODES.KITKAT) {
                            alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);

                        } else if (Build.VERSION_CODES.KITKAT <= SDK_INT && SDK_INT < Build.VERSION_CODES.M) {
                            alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);

                        } else if (SDK_INT >= Build.VERSION_CODES.M) {
                            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
                            Log.e("marshmallowMF", "hahah");
                        }


                        //Setting API Call
                        SettingsAPICall.getSettings(LoginScreen.this);

                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "");

                        KillSignalAPICall.getKillSignal(LoginScreen.this);

                        Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
                        startService(intent_service);


                        PwonSignal.sendPWONSignal(LoginScreen.this, "PWON");
                        SharedPreferences.Editor editoree = preferences.edit();

                        editoree.putString("Triggerfrom", "PWON");
                        // editor.putString("userImage",userimage);
                        editoree.commit();


                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "");


                        move_withDelay();

                        //custom dialog
                    } else {

                    }
                }
            }

            @Override
            public void onFailure(Call<VerifyBeans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    private void move_withDelay() {
        try {
            timer.schedule(new TimerTask() {
                public void run() {
                    dismissProgressDialog();
                    Log.e("PROGRESSS", ">>>");
                    dialog1.dismiss();

                    Intent intent = new Intent(LoginScreen.this, TabHostActivity.class);
                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                    startActivity(intent);
                    finish();

                }
            }, 8000);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Override
    protected void onPause() {
        super.onPause();
    /*    if(progressDialog.isShowing()) {
        progressDialog.dismiss();
    }*/
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        switch (v.getId()) {
            case R.id.rl_login1:
                try {
                    Log.e("DIALOG ", "DiSPLAYINGGG");

                    dialog1.setCancelable(false);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
        }
        return true;
    }

    @Override
    protected void onResume() {
        super.onResume();
        checkPermissions();




//
//        try {
//            mNfcAdapter = NfcAdapter.getDefaultAdapter(this);
//            if (!mNfcAdapter.isEnabled()) {
//                Toast.makeText(getApplicationContext(), "Please activate NFC and press Back to return to the application!", Toast.LENGTH_LONG).show();
//                //startActivity(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS));
//                //startActivity(new Intent(Settings.ACTION_NFC_SETTINGS));
//            }
//
//
//            IntentFilter tagDetected = new IntentFilter(NfcAdapter.ACTION_TAG_DISCOVERED);
//            IntentFilter ndefDetected = new IntentFilter(NfcAdapter.ACTION_NDEF_DISCOVERED);
//            IntentFilter techDetected = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);
//            IntentFilter[] nfcIntentFilter = new IntentFilter[]{techDetected, tagDetected, ndefDetected};
//
//            PendingIntent pendingIntent = PendingIntent.getActivity(
//                    this, 0, new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
//            if (mNfcAdapter != null) {
//                mNfcAdapter.enableForegroundDispatch(this, pendingIntent, nfcIntentFilter, null);
//
//            }
//        }catch (Exception e){
//            e.printStackTrace();
//        }



    }

    private void showNFCAlert(){
         try{
             mNfcAdapter = NfcAdapter.getDefaultAdapter(this);
             if (!mNfcAdapter.isEnabled()) {
            // notify user
            AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
            dialog.setMessage(this.getResources().getString(R.string.nfc_not_enabled));
            dialog.setPositiveButton(this.getResources().getString(R.string.open_Nfc_settings), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub
                    Intent myIntent = new Intent(Settings.ACTION_NFC_SETTINGS);
                    startActivity(myIntent);
                    //get gps
                }
            });
            dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub

                }
            });
            dialog.show();
        }


    } catch (Exception e) {
        e.printStackTrace();
    }


    }



    private void login(String number) {
        loginResponseCall = mWebrequest.apiInterface.userLogin(number);
        getLoginResponse(loginResponseCall);
    }

    //Login API Response
    private void getLoginResponse(Call<LoginBeans> loginResp) {
        showProgressDialog(LoginScreen.this, "Login...");
        loginResp.enqueue(new Callback<LoginBeans>() {
            @Override
            public void onResponse(Call<LoginBeans> call, Response<LoginBeans> response) {
                //showLog(response.body().getMessage().toString());
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    loginResponse = response.body();
                    String status = response.body().getStatus().toString();
                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        get_otp = response.body().getOtp().toString();
                        String message = response.body().getMessage().toString();
                        Log.e("get_otp>>>>>>>>:-", get_otp);
                        try {

                            otp_Dialog();

//                                if (gps.getLatitude() == 0.0) {
//                                    showAlert();
//                                } else {
//
//
//
//                                }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Log.e("In condition", "Failed");
                        AlertDialog.Builder builder = new AlertDialog.Builder(LoginScreen.this);
                        builder.setTitle("Error");
                        builder.setMessage("You have entered an unrecognised number, please check and try again. If you are still having problems then please contact Orbis on 0845 345 7800 or email lwpsupport@orbisprotect.com");
                        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                        builder.show();
                    }
                }
            }

            @Override
            public void onFailure(Call<LoginBeans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    private void otp_Dialog() {
        if (dialog1!=null){

            Log.e("Not NULL","=======");
            dialog1.requestWindowFeature(Window.FEATURE_NO_TITLE);
            dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
            dialog1.setContentView(R.layout.otp_layout);
            et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
            btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
            btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
            resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
            resend_otp.setOnClickListener(this);
            // Click cancel to dismiss android custom dialog box
            btn_cancel_otp.setOnClickListener(this);
            btn_login_otp.setOnClickListener(this);

            dialog1.show();

        }else{
            Log.e("NULL","=======");
            dialog1 = new Dialog(LoginScreen.this);
            dialog1.requestWindowFeature(Window.FEATURE_NO_TITLE);
            dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
            dialog1.setContentView(R.layout.otp_layout);
            et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
            btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
            btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
            resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
            resend_otp.setOnClickListener(this);
            // Click cancel to dismiss android custom dialog box
            btn_cancel_otp.setOnClickListener(this);
            btn_login_otp.setOnClickListener(this);

            dialog1.show();
        }


        dialog1.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        dialog1.setContentView(R.layout.otp_layout);
        et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
        btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
        btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
        resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
        resend_otp.setOnClickListener(this);
        // Click cancel to dismiss android custom dialog box
        btn_cancel_otp.setOnClickListener(this);
        btn_login_otp.setOnClickListener(this);

        dialog1.show();
    }

    public void showAlert() {


        try {
            gps = new GPSTracker(this);
            LocationManager lm = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
            boolean gps_enabled = false;
            boolean network_enabled = false;

            try {
                gps_enabled = lm.isProviderEnabled(LocationManager.GPS_PROVIDER);
            } catch (Exception ex) {
            }

            try {
                network_enabled = lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            } catch (Exception ex) {
            }

            if (!gps_enabled && !network_enabled) {
                // notify user
                AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
                dialog.setMessage(this.getResources().getString(R.string.gps_network_not_enabled));
                dialog.setPositiveButton(this.getResources().getString(R.string.open_location_settings), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub
                        Intent myIntent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                        startActivity(myIntent);
                        //get gps
                    }
                });
                dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub

                    }
                });
                dialog.show();
            }


        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}