package com.orbisalert.Activity;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.BatteryManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v7.widget.Toolbar;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.orbisalert.R;
import com.orbisalert.Util.CounterClass;
import com.orbisalert.Util.LocationHandler;
import com.orbisalert.Util.MyService;
import com.orbisalert.Util.PrefManager;
import com.orbisalert.Util.SOSService;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.EscalationApiCall;
import com.orbisalert.net.GPSTracker;


import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import de.hdodenhof.circleimageview.CircleImageView;


public class DashboardScreen extends OrbisActivity implements View.OnClickListener {

    ImageView iv_call, iv_amber, iv_fall, iv_location, iv_battery, iv_signal;
    TextView tv_user_name, tv_user_desc, tv_active, tv_timer, tv_seconds, tv_address, tv_active_fall, tv_senstive, tv_call_time, tv_contact, tv_active_battery, tv_signal_detail;
    CircleImageView iv_user;
    Intent callIntent;
    TelephonyManager telephonyManager;
    myPhoneStateListener psListener;
    BroadcastReceiver mBatInfoReceiver;
    private String UserName, update_time, locationupdate_time;
    private String cityName = "", amber_hour = "", amber_min = "", amber_time = "", fall_detect = "";
    private String lattitude, longitude;
    private String pwon_status = "";
    CounterClass counterClass = null;
    AlertDialog.Builder builder;
    private String date, time, imei, number, messageType, lat, lng, posdatatime, postype, status = "", interval, speed;
    TelephonyManager tManager;
    private String checksum = "";
    private String prt = "PRT";
    private String messagechck = "";
    private String fcmstatus = "", fcmmessage = "", phoneNumber = "", userImage = "";
    private final Handler handler = new Handler();
    private String fullname = "", emailadd = "", pronumber = "", address = "";
    static Handler mDashboardHandler;
    GPSTracker gps;
    SharedPreferences sharedPreferences;
    String SOSDetect="";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_dashboard_screen);
        mDashboardHandler = LocationHandler.getMainLocationInstance();
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayShowTitleEnabled(false);

        //changing statusbar color....
        Utility.status_bar_color_change(DashboardScreen.this);

        builder = new AlertDialog.Builder(this);

        //get value from sha
        try {

            cityName = preferences.getString("City", "");
            UserName = preferences.getString("Name", "");
            date = get_current_date();
            time = get_current_time();
            tManager = (TelephonyManager) getBaseContext()
                    .getSystemService(Context.TELEPHONY_SERVICE);
            imei = tManager.getDeviceId();
            number = preferences.getString("number", "");
            messageType = "EMG";
            posdatatime = preferences.getString("posdatatime", "");
            phoneNumber = preferences.getString("redalertsmsnumber", "");
            userImage = preferences.getString("userImage", "");
            locationupdate_time = preferences.getString("locationupdate", "");
            update_time = preferences.getString("UpdateLocationTime", "");
            startRepeatingTask();

        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            gps = new GPSTracker(DashboardScreen.this);
            lat = String.valueOf(gps.getLatitude());
            lng = String.valueOf(gps.getLongitude());
            Log.e("REDAlertLat", lat);
            Log.e("REDAlertLong", lng);
            if (lat.equalsIgnoreCase("0.0")) {
                lat = preferences.getString("currentLATTITUDE", "");
            } else {
            }
            if (lng.equalsIgnoreCase("0.0")) {
                lng = preferences.getString("currentLONGITUDE", "");
            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        postype = "GPS";
        speed = GlobalConstants.SPEED;
       /* if (status.equalsIgnoreCase("")) {
            status = "Emergency";
        } else {
            status = preferences.getString("messageStatus", "");
        }
        Log.e("DASBOARD STATUS",status);*/
        messagechck = prt + "," + date + time + "," + imei + "," + number + "," + messageType + "," + lat + "," + lng + "," + posdatatime + "," + postype + "," + status + "," + interval + "," + speed;
        checksum = md5(messagechck);
        lattitude = preferences.getString("currentLATTITUDE", "");
        longitude = preferences.getString("currentLONGITUDE", "");
        amber_hour = preferences.getString("AMBERTIME", "");
        amber_min = preferences.getString("AMBERTIME_min", "");
        pwon_status = preferences.getString("PwonStatus", "");
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");
        SOSDetect = preferences.getString("SOSDetected", "");
        //SOS

        if (SOSDetect.equalsIgnoreCase("0")) {

            Intent intent2 = new Intent(DashboardScreen.this, SOSService.class);
            stopService(intent2);
            Log.e("Dasboard@@@@@@","Stop Service");

        }else{

            Intent intent2 = new Intent(DashboardScreen.this, SOSService.class);
            startService(intent2);
            Log.e("Dash@@@@@@", "Start Service");

        }







        if (amber_hour.length() <= 9 || amber_min.length() <= 9) {
            amber_hour = "0" + amber_hour;
            amber_min = "0" + amber_min;

        } else {
            amber_hour = "" + amber_hour;
            amber_min = "" + amber_min;

        }
        amber_time = amber_hour + ":" + amber_min;
        //findViewById....
        intialize_ID();
        //Check Device percentage.....
        check_battery_percentage();
        try {
            EscalationApiCall.getEscalation(DashboardScreen.this);
            fullname = preferences.getString("fullname", "");
            address = preferences.getString("address", "");
            emailadd = preferences.getString("emailaddress", "");
            pronumber = preferences.getString("number", "");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void check_battery_percentage() {
        mBatInfoReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context ctxt, Intent intent) {
                int level = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, 0);
                tv_active_battery.setText(String.valueOf(level) + "%");
            }
        };
        this.registerReceiver(this.mBatInfoReceiver, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
    }

    private void intialize_ID() {
        psListener = new myPhoneStateListener();
        telephonyManager = (TelephonyManager) getApplicationContext().getSystemService(Context.TELEPHONY_SERVICE);
        telephonyManager.listen(psListener, PhoneStateListener.LISTEN_SIGNAL_STRENGTHS);

        iv_amber = (ImageView) findViewById(R.id.iv_amber);
        iv_amber.setOnClickListener(this);
        iv_fall = (ImageView) findViewById(R.id.iv_fall);
        iv_fall.setOnClickListener(this);
        iv_call = (ImageView) findViewById(R.id.iv_call);
        iv_call.setOnClickListener(this);
        iv_user = (CircleImageView) findViewById(R.id.iv_user);
        iv_location = (ImageView) findViewById(R.id.iv_location);
        iv_location.setOnClickListener(this);
        iv_battery = (ImageView) findViewById(R.id.iv_battery);
        iv_battery.setOnClickListener(this);
        iv_signal = (ImageView) findViewById(R.id.iv_signal);
        iv_signal.setOnClickListener(this);
        iv_user = (CircleImageView) findViewById(R.id.iv_user);
        //helvetica neue light....
        tv_user_name = (TextView) findViewById(R.id.tv_user_name);
        Utility.text_font_helvetica(this, tv_user_name);
        tv_user_name.setText(UserName);
        tv_user_desc = (TextView) findViewById(R.id.tv_user_desc);
        Utility.text_font_helvetica(this, tv_user_desc);

        tv_active = (TextView) findViewById(R.id.tv_active);
        Utility.text_font_helvetica(this, tv_active);
        tv_timer = (TextView) findViewById(R.id.tv_timer);
        Utility.text_font_helvetica(this, tv_timer);





        try {
            if (userImage.equalsIgnoreCase("http://54.218.78.31:50/dev//img/dashboardImage.png")) {
                Glide.with(this)
                        .load(R.drawable.orbis_man)
                        .centerCrop()
                        .error(R.drawable.orbis_man)
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .into(iv_user);

            } else {

                Glide.with(this)
                        .load(userImage)
                        .centerCrop()
                        .error(R.drawable.orbis_man)
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .into(iv_user);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            counterClass = CounterClass.getInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (counterClass.getFormatedTime() != null) {
            tv_active.setText("Activated");
        } else {
            tv_active.setText("Deactivated");
        }
        if (amber_time.equalsIgnoreCase("")) {
            tv_active.setText("Deactivated");
        } else {
            final Handler handler = new Handler();
            final Runnable r = new Runnable() {
                public void run() {
                    handler.postDelayed(this, 1000);
                    try {
                        String timme = counterClass.getFormatedTime().toString();
                        String[] time = timme.split(":");
                        int hour = Integer.parseInt(time[0].trim());
                        int min = Integer.parseInt(time[1].trim());
                        int sec = Integer.parseInt(time[2].trim());
                        try {
                            if (hour != 0) {
                                int exhour = hour * 60;
                                int exmin = min + exhour;
                                tv_timer.setText(exmin + "mins" + sec + " secs");
                            } else {
                                tv_timer.setText(min + " " + "mins" + " " + sec + " secs");
                            }
                        } catch (NumberFormatException ex) { // handle your exception
                            ex.printStackTrace();
                        }


                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            handler.postDelayed(r, 0000);
        }
        tv_seconds = (TextView) findViewById(R.id.tv_seconds);
        Utility.text_font_helvetica(this, tv_seconds);
        if (locationupdate_time.equalsIgnoreCase("")) {
        } else {
            Runnable runnable = new Runnable() {
                @Override
                public void run() {
                    handler.postDelayed(this, 1000);
                    tv_seconds.setVisibility(View.VISIBLE);

                    try

                    {
                        CharSequence relavetime1;
                        long now = System.currentTimeMillis();
                        //String datetime1 = "06/12/2015 03:58 PM";
                        String datetime1 = locationupdate_time;
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
                        Date convertedDate = dateFormat.parse(datetime1);

                        relavetime1 = DateUtils.getRelativeTimeSpanString(
                                convertedDate.getTime(),
                                now,
                                DateUtils.SECOND_IN_MILLIS);
                        if (relavetime1 == "60 seconds ago") {
                            relavetime1 = DateUtils.getRelativeTimeSpanString(
                                    convertedDate.getTime(),
                                    now,
                                    DateUtils.SECOND_IN_MILLIS,
                                    DateUtils.FORMAT_ABBREV_RELATIVE);
                        }
                        if (relavetime1 == "5 Minutes ago") {
                            startRepeatingTask();
                        } else {
                            stopRepeatingTask();
                        }
                        if (relavetime1 == "6 minutes ago") {
                            String updatedtime = get_locationcurrent_time();
                            if (updatedtime != null) {
                                SharedPreferences.Editor editor2 = preferences.edit();
                                editor2.remove("locationupdate");
                                editor2.apply();
                            }
                            SharedPreferences.Editor editor = preferences.edit();
                            editor.putString("locationupdate", updatedtime);
                            editor.commit();
                            startRepeatingTask();
                        } else {
                            stopRepeatingTask();
                        }

                        tv_seconds.setText("Last Updated :" + String.valueOf(relavetime1));

                        System.out.println(relavetime1);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };

            handler.post(runnable);


        }
        tv_address = (TextView) findViewById(R.id.tv_address);
        Utility.text_font_helvetica(this, tv_address);
        if (cityName.equalsIgnoreCase("")) {
            tv_user_desc.setText("No Location Found");
            tv_address.setText("No Location Found");

        } else {
            tv_user_desc.setText(cityName);
            tv_address.setText(cityName);
        }
        tv_active_fall = (TextView) findViewById(R.id.tv_active_fall);
        Utility.text_font_helvetica(this, tv_active_fall);

        fall_detect = preferences.getString("FallDetection", "");
        if (fall_detect != null) {
            if (fall_detect.equalsIgnoreCase("Activated")) {

                tv_active_fall.setText("Activated");
                Intent intent = new Intent(DashboardScreen.this, MyService.class);
                startService(intent);


            } else {
                tv_active_fall.setText("Inactive");
            }
        }
        tv_senstive = (TextView) findViewById(R.id.tv_senstive);
        Utility.text_font_helvetica(this, tv_senstive);
        tv_call_time = (TextView) findViewById(R.id.tv_call_time);
        Utility.text_font_helvetica(this, tv_call_time);
        tv_contact = (TextView) findViewById(R.id.tv_contact);
        Utility.text_font_helvetica(this, tv_contact);
        tv_active_battery = (TextView) findViewById(R.id.tv_active_battery);
        Utility.text_font_helvetica(this, tv_active_battery);
        tv_signal_detail = (TextView) findViewById(R.id.tv_signal_detail);
        Utility.text_font_helvetica(this, tv_signal_detail);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_amber:
                Utility.moveToNextActivity(DashboardScreen.this, SetAmberScreen.class);
                break;
            case R.id.iv_location:
                previousActivity();
                break;
            case R.id.iv_fall:
                previousActivity1();
                break;
            case R.id.iv_call:

                Calendar c = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                String formattime = simpleDateFormat.format(c.getTime());
                tv_call_time.setText("Last call :" + formattime);

                String number = "tel:"+ URLEncoder.encode("*31#01513432852");
                callIntent = new Intent(Intent.ACTION_CALL);
                callIntent.setData(Uri.parse(number));
                startActivity(callIntent);


//                callIntent = new Intent(Intent.ACTION_CALL);
//                callIntent.setData(Uri.parse("tel:01513432852"));
//                startActivity(callIntent);
                break;
            case R.id.iv_battery:
                break;
            case R.id.iv_signal:
                break;
            default:
        }
    }

    public class myPhoneStateListener extends PhoneStateListener {
        public int signalStrengthValue;

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            if (signalStrength.isGsm()) {
                if (signalStrength.getGsmSignalStrength() != 99) {
                    signalStrengthValue = signalStrength.getGsmSignalStrength() * 2 - 113;
                    tv_signal_detail.setText("Strong");
                } else {
                    signalStrengthValue = signalStrength.getGsmSignalStrength();
                    tv_signal_detail.setText("Weak");
                }
            } else {
                signalStrengthValue = signalStrength.getCdmaDbm();
                tv_signal_detail.setText(" Strength : " + signalStrengthValue);
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.items, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_profile:
                Intent intent = new Intent(DashboardScreen.this, ProfileScreen.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();
                return true;
            case R.id.action_setting:
                Intent intent1 = new Intent(DashboardScreen.this, SettingScreen.class);
                intent1.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent1);
                finish();
                return true;
            case R.id.action_device_info:
                Intent intent2 = new Intent(DashboardScreen.this, DeviceInfoScreen.class);
                intent2.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent2);
                finish();

                return true;
            case R.id.action_user_guide_info:
                PrefManager prefManager = new PrefManager(getApplicationContext());

                // make first time launch TRUE
                prefManager.setFirstTimeLaunch(true);
                startActivity(new Intent(DashboardScreen.this, UserGuideActivity.class));
                finish();

                return true;

            default:
                return super.onOptionsItemSelected(item);
        }
    }

    public void previousActivity() {
        Intent intent = new Intent(DashboardScreen.this, TabHostActivity.class);
        intent.putExtra("tab", 1);
        startActivity(intent);
        finish();
    }

    public void previousActivity1() {
        Intent intent11 = new Intent(DashboardScreen.this, TabHostActivity.class);
        intent11.putExtra("tab", 4);
        startActivity(intent11);
        finish();
    }

    public void onBackPressed() {
        //super.onBackPressed();
        showBuilder1(DashboardScreen.this, "Orbis App", "Do you really want to exit this app?");
    }

    /*
    * Alert builder
    *
    * */
    public void showBuilder1(@NonNull Context context, @NonNull String title, @NonNull String message) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
                finish();
                //kill all running process
                android.os.Process.killProcess(android.os.Process.myPid());

            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();

            }
        });
        builder.show();
    }

    /**
     * Start handler
     */

    void startRepeatingTask() {

        final Runnable r = new Runnable() {
            public void run() {
                mDashboardHandler.postDelayed(this, 1000);

                try {
                    locationupdate_time = preferences.getString("locationupdate", "");
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }

        };
        mDashboardHandler.postDelayed(r, 00000);
    }

    /**
     * Stop handler
     */

    void stopRepeatingTask() {
        mDashboardHandler = LocationHandler.getMainLocationInstance();
        mDashboardHandler.removeCallbacks(null);
        LocationHandler.clearInstance();
    }

    /**
     * get current time
     */
    public static String get_locationcurrent_time() {

        Calendar c = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }


}

