package com.orbis.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.StrictMode;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.LocationUpdateBeans;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Admin on 09-08-2017.
 */

public class Update_locationCall {

    static WebRequest mWebrequest;
    static Call<LocationUpdateBeans> locationupdate_ResponseCall;
    static LocationUpdateBeans locationupdate_otpresponse;
    static String date, time;
    static String refid1, currentLat, currentLong, datetime1, imei1, number1, messageType1, posdatatime, postype, status1, interval, speed;
    static TelephonyManager tManager;
    static double longittude, lattitude;
    static SharedPreferences preferences;
    static String fcmstatus = "";
    static String fcmmessage = "";
    static String update_location;
    static final Handler handler = new Handler();
    static Context ctx;

    public static void sendUpdateSignal(Context context, double latitude, double longitude) {

        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder()
                .permitAll().build();
        StrictMode.setThreadPolicy(policy);
        ctx = context;

        GPSTracker gpsTracker = new GPSTracker(context);
        longittude = longitude;
        lattitude = latitude;

        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        tManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        datetime1 = date + time;
        Log.e("Date Time ", datetime1);
        postype = "GPS";
        interval = "";
        speed = GlobalConstants.SPEED;

        imei1 = tManager.getDeviceId();
        refid1 = preferences.getString("REF_ID", "");
        status1 = preferences.getString("messageStatus", "");
/*
        try {
        if (status1.equalsIgnoreCase("")) {
            status1 = "Emergency";
        } else {
            status1 = preferences.getString("messageStatus", "");
        }
        }
        catch(Exception e){
            e.printStackTrace();
        }*/
        number1 = preferences.getString("number", "");
        messageType1 = "PUD";
        posdatatime = preferences.getString("posdatatime", "");
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");


        try {
            if (longitude == 0.0) {
                Log.e("+++++long1", String.valueOf(longitude));
                currentLong = preferences.getString("currentLONGITUDE", "");
                Log.e("+++++long", String.valueOf(currentLong));
            } else {

                Log.e("+++++long2", String.valueOf(longitude));
                currentLong = String.valueOf(longitude);
            }

            if (latitude == 0.0) {
                Log.e("+++++lat", String.valueOf(latitude));
                currentLat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++lat1", String.valueOf(currentLat));

            } else {
                currentLat = String.valueOf(latitude);
                Log.e("+++++lat", String.valueOf(currentLat));

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (isNetworkAvailable(ctx)) {

                date = get_current_date();
                time = get_current_time();

                update_location = refid1 + "," + currentLat + "," + currentLong + "," + date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed;
                Log.e("Update==DATE==NETON", datetime1);
                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                } else {
                    date = get_current_date();
                    time = get_current_time();
                    Log.e("Update==LOC==NETON", update_location);
                    Update_locationCall(refid1, currentLat, currentLong, date + time, imei1, number1, messageType1, date + time, postype, status1, interval, speed);
                    Log.e("Values", update_location);
                }
            } else {
                Log.e("NOT ", "IIIIIIIIIII");

                date = get_current_date();
                time = get_current_time();
                datetime1 = date + time;

                String phoneNumber = "07786200129";
                Log.e("NOT ", "IIIIIIIIIII");

                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                } else {
                    date = get_current_date();
                    time = get_current_time();


                    Log.e("NOT ", "NETWORKKKKK");

                    try {
                        mHandlerTask.run();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }


                }
            }
        } catch (Exception e) {

        }
    }

    static Runnable mHandlerTask = new Runnable() {
        public void run() {
            try {
                show_image();

            } catch (Exception e) {
                e.printStackTrace();
            }

            handler.postDelayed(mHandlerTask, 30000);

        }

    };

    static public void show_image() {
        date = get_current_date();
        time = get_current_time();
        update_location = refid1 + "," + currentLat + "," + currentLong + "," + date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed;
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                date = get_current_date();
                time = get_current_time();
                //I want to display this images in 2 second count
                Log.e("Update==LOC11==NETON", update_location);
                Update_locationCall(refid1, currentLat, currentLong, date + time, imei1, number1, messageType1, date + time, postype, status1, interval, speed);
                Log.e("Values1", "11111");

            }
        }, (long) (2 * 10000));

        new Handler().postDelayed(new Runnable() {
                                      @Override
                                      public void run() {
                                          Log.e("Update==LOC33==NETON", update_location);
                                          if (isNetworkAvailable(ctx)) {
                                              date = get_current_date();
                                              time = get_current_time();
                                              Update_locationCall(refid1, currentLat, currentLong, date + time, imei1, number1, messageType1, date + time, postype, status1, interval, speed);
                                              Log.e("Values1", "33333");
                                          } else {
                                              try {
                                                  String updatedtime = get_locationcurrent_time();
                                                  if (updatedtime != null) {
                                                      SharedPreferences.Editor editor2 = preferences.edit();
                                                      editor2.remove("locationupdate");
                                                      editor2.apply();
                                                  }

                                                  SharedPreferences.Editor editor = preferences.edit();
                                                  editor.putString("locationupdate", updatedtime);
                                                  editor.commit();


                                                  date = get_current_date();
                                                  time = get_current_time();
                                                  String messagechck = "PRT" + "," + date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed;
                                                  // md5(messagechck);
                                                  String checksum = md5(messagechck);
                                                  String phoneNumber = "07786200129";
                                                  String messagesend = "PRT" + "," + date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed + "," + checksum;
                                                  Log.e("UpdateNETOFF", messagesend);
                                                  SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                                                  handler.removeCallbacks(null);
                                                  handler.removeCallbacksAndMessages(null);


                                              } catch (Exception e) {
                                                  e.printStackTrace();
                                              }
                                          }
                                      }

                                  },

                (long) (3 * 10000));
    }

    public static void Update_locationCall(String refid, String currentLat, String currentLong, String datetime1, String imei1, String number1, String messageType1, String posdatatime, String postype, String status1, String interval, String speed) {
        locationupdate_ResponseCall = mWebrequest.apiInterface.userLocationUpdate(refid1, currentLat, currentLong, datetime1, imei1, number1, messageType1, posdatatime, postype, status1, interval, speed);
        getLocationUpdateResponse(locationupdate_ResponseCall);
    }

    //Signal API Response
    public static void getLocationUpdateResponse(final Call<LocationUpdateBeans> locationResp) {
        Log.e("LocationRESPONSE", "++++++");
        locationResp.enqueue(new Callback<LocationUpdateBeans>() {
            @Override
            public void onResponse(Call<LocationUpdateBeans> call, Response<LocationUpdateBeans> response) {
                //Log.e("LocationRESPONSE",response.body().toString());
                if (response.isSuccessful()) {
                    locationupdate_otpresponse = response.body();


                    String status = response.body().getStatus().toString();
                    String message = response.body().getMessage().toString();

                    Log.e("LOcation status In condition", status);
                    if (status.equalsIgnoreCase("1")) {

                        handler.removeCallbacks(null);
                        handler.removeCallbacksAndMessages(null);

                        String updatedtime = get_locationcurrent_time();
                        Log.e("=====UPDATE TIME", updatedtime);
                        if (updatedtime != null) {
                            SharedPreferences.Editor editor2 = preferences.edit();
                            editor2.remove("locationupdate");
                            editor2.apply();
                        }

                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("locationupdate", updatedtime);
                        editor.commit();


                    } else {
                        Log.e("In condition", "Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<LocationUpdateBeans> call, Throwable t) {
                // dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    public static boolean isNetworkAvailable(Context context) {

        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    //==============get curent time =========================//
    public static String get_current_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    public static String get_locationcurrent_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Location" +
                "Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    //==============get curent date =========================//
    public static String get_current_date() {
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String formattedDate = df.format(c.getTime());

        return formattedDate;
    }

    public static final String md5(final String s) {
        final String MD5 = "MD5";
        try {
            // Create MD5 Hash
            MessageDigest digest = MessageDigest
                    .getInstance(MD5);
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();

            // Create Hex String
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2)
                    h = "0" + h;
                hexString.append(h);

            }
            Log.e("CheckSum", hexString.toString());
            return hexString.toString();


        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

}
