package com.orbis.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.StrictMode;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.SignalBeans;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Admin on 09-08-2017.
 */

public class PwonSignal {

    static WebRequest mWebrequest;
    static Call<SignalBeans> signal_ResponseCall;
    static SignalBeans signal_otpresponse;
    static String date, time;
    static String refid1, currentLat, currentLong, datetime1, imei1, number1, messageType1, posdatatime, postype, status1, interval, speed;
    static TelephonyManager tManager;
    static LocationManager locationManager;
    static SharedPreferences preferences;
    static String fcmstatus = "";
    static String fcmmessage = "";
    static String checksum = "";
    static String prt = "PRT";
    static String messagesend = "", phoneNumber = "";

    public static void sendPWONSignal(Context context, String messageType1) {

        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder()
                .permitAll().build();
        StrictMode.setThreadPolicy(policy);

        GPSTracker gps = new GPSTracker(context);

        // Getting LocationManager object
        Log.e("PWONUpdate", "Loc CALL");
        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        tManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        datetime1 = date + time;
        Log.e("Date Time ", datetime1);
        postype = "GPS";
        //status = "arrived";
        interval = "";
        speed =GlobalConstants.SPEED;
        try {
            imei1 = tManager.getDeviceId();
        }
        catch(Exception e){
            e.printStackTrace();
        }
        refid1 = preferences.getString("REF_ID", "");

       // status1 = preferences.getString("messageStatus", "");
        /*if (status1.equalsIgnoreCase("")) {
            status1 = "Emergency";
        } else {
            status1 = preferences.getString("messageStatus", "");
        }*/
        number1 = preferences.getString("number", "");
        posdatatime = preferences.getString("posdatatime", "");
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");
        phoneNumber = preferences.getString("redalertsmsnumber", "");
        currentLong = preferences.getString("currentLONGITUDE", "");
        currentLat = preferences.getString("currentLATTITUDE", "");

        try {
            if (isNetworkAvailable(context)) {
                Log.e("PWON Signal Start", "Done");
                messageType1 = messageType1;
                date = get_current_date();
                time = get_current_time();
                try {
                    if (currentLat == "") {
                        currentLat = String.valueOf(gps.getLatitude());
                    }

                    if (currentLong == "") {
                        currentLong = String.valueOf(gps.getLongitude());
                    }

                    if (currentLat.equalsIgnoreCase("0.0")) {
                        currentLat = String.valueOf(gps.getLatitude());
                    }

                    if (currentLong.equalsIgnoreCase("0.0")) {
                        currentLong = String.valueOf(gps.getLongitude());
                    }


                } catch (Exception e) {

                }


                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");


                } else {


                    Log.e("PWONcurrentLattitude", currentLat);
                    Log.e("PWONcurrentLongitude", currentLong);
                    Log.e("messageType1", messageType1);

                    String PW_MEssage = date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed;
                    Log.e("PwMessageSignal", PW_MEssage);

                    signal_Send(date + time, imei1, number1, messageType1, currentLat, currentLong, date + time, postype, status1, interval, speed);
                }
            } else {
                Log.e("TAGGGGGG", "SMS SENT");
                SharedPreferences.Editor editorr = preferences.edit();
                editorr.putString("PwonStatus", "1");
                editorr.commit();
                date = get_current_date();
                time = get_current_time();
                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                } else {
                    messageType1 = messageType1;
                    messagesend = prt + "," + date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed + "," + checksum;

                    Log.e("messagesend", messagesend);
                    SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                }
            }
        } catch (Exception e) {

        }
    }

    private static void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private static void getSignalResponse(final Call<SignalBeans> signalResp) {
        //  showProgressDialog(SetAmberScreen.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();
                    Log.e("PWONll", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("PWON In condition", "Success");
                        String message = response.body().getMessage().toString();
                        SharedPreferences.Editor editorr = preferences.edit();
                        editorr.putString("PwonStatus", "1");
                        editorr.commit();

                    } else {
                        Log.e("In condition", "Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //  dismissProgressDialog();
                t.printStackTrace();
            }
        });

    }

    public static boolean isNetworkAvailable(Context context) {

        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    //==============get curent time =========================//
    public static String get_current_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    public static String get_locationcurrent_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Location" +
                "Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    //==============get curent date =========================//
    public static String get_current_date() {
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String formattedDate = df.format(c.getTime());

        return formattedDate;
    }

    public static final String md5(final String s) {
        final String MD5 = "MD5";
        try {
            // Create MD5 Hash
            MessageDigest digest = MessageDigest
                    .getInstance(MD5);
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();

            // Create Hex String
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2)
                    h = "0" + h;
                hexString.append(h);

            }
            Log.e("CheckSum", hexString.toString());
            return hexString.toString();


        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

//    static class ConnectTask extends AsyncTask<String, String, TcpClient> {
//
//        @Override
//        protected TcpClient doInBackground(String... message) {
//
//            //we create a TCPClient object and
//            mTcpClient = new TcpClient(new TcpClient.OnMessageReceived() {
//                @Override
//                //here the messageReceived method is implemented
//                public void messageReceived(String message) {
//                    //this method calls the onProgressUpdate
//                    publishProgress(message);
//                }
//            });
//            mTcpClient.run();
//
//            return null;
//        }
//
//        @Override
//        protected void onProgressUpdate(String... values) {
//            super.onProgressUpdate(values);
//
//
//        }
//    }


}
