package com.orbis.net;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;

/**
 * Created by nancy on 6/9/17.
 */

public class OnClearFromRecentService extends Service {
    SharedPreferences preferences;
    private static final String TAG = OnClearFromRecentService.class.getSimpleName();
    private String verifystatus = "";
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.e(TAG, "onCreate()");
        preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        Notification notification = new Notification();
        startForeground(42, notification);

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e(TAG, "onStartCommand()");
        return START_NOT_STICKY;
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {

        try {
            verifystatus = preferences.getString("STATUS", "");

            if (verifystatus.equalsIgnoreCase("1")) {

                SharedPreferences.Editor editor3 = preferences.edit();
                editor3.putString("Triggerfrom", "KILL");
                editor3.commit();


                TriggerSignal.sendTriggerSignal(OnClearFromRecentService.this, "", "", "");

                PwonSignal.sendPWONSignal(getApplicationContext(), "KILL");
            } else {
                Log.e("KILL SIgnal", "NOT LOGIN");
            }
            super.onTaskRemoved(rootIntent);
            Log.e(TAG, "onTaskRemoved()");

        } catch (Exception e) {
e.printStackTrace();
        }
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d("ClearFromRecentService", "Service Destroyed");
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        Log.e(TAG, "onLowMemory()");
    }

}

