package com.orbis.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.StrictMode;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.SignalBeans;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Admin on 0018,18,April,2018.
 */

public class NfcSignal {
    static WebRequest mWebrequest;
    static Call<SignalBeans> signal_ResponseCall;
    static SignalBeans signal_otpresponse;

    static String date, time;
    static String refid1, currentLat, currentLong, datetime1, imei1, number1, messageType1, posdatatime, postype, status1, interval, speed;
    static TelephonyManager tManager;
    static LocationManager locationManager;
    static String provider;
    static double longittude,lattitude;
    static SharedPreferences preferences;
    static String fcmstatus="";
    static String fcmmessage ="";
    static String socketmessage="";
    static Intent newIntent = new Intent();
    static GPSTracker gps;
    static String trigger;
    static String falltrigger="";
    static String lastfallSignal;
    boolean signalstatus=false;
    //static String msgType="",statusType="";
    static String nfcMsg="",nfcStatus;


    @SuppressLint("MissingPermission")
    public static void sendNFCSignal(Context context, String status, String msgType) {

        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder()
                .permitAll().build();
        StrictMode.setThreadPolicy(policy);

        GPSTracker gpsTracker = new GPSTracker(context);


        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        tManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        date=get_current_date();
        time=get_current_time();
        datetime1 = date + time;
        Log.e("Date Time ", datetime1);
        postype = "GPS";
        speed = GlobalConstants.SPEED;
        if (status!=null){
            nfcStatus=status;
        }

        if (msgType!=null){
            nfcMsg=msgType;
        }

        imei1 = tManager.getDeviceId();
        refid1 = preferences.getString("REF_ID", "");

        //status1 = preferences.getString("messageStatus", "");
        number1 = preferences.getString("number", "");
        //messageType1 = "Trigger";
        // posdatatime = preferences.getString("posdatatime", "");
        posdatatime = date + time;
        fcmstatus = preferences.getString("FCMSignalStatus","");
        fcmmessage = preferences.getString("FCMSignalmessage","");
        trigger =preferences.getString("Triggerfrom","");
        falltrigger= preferences.getString("FallDetectTrigger","");
        lastfallSignal= preferences.getString("LastUpdatedTime","");
        //msgType =preferences.getString("msgtype","");
        //statusType=preferences.getString("statustype","");


        try{
//            if(status1.equalsIgnoreCase("")){
//                status1 = "Emergency";
//            }
//            else{
//                status1 = preferences.getString("messageStatus", "");
//            }
//
//            Log.e("NFCSIGnal STATUS",status1);


            gps = new GPSTracker(context);
            currentLat =String.valueOf(gps.getLatitude());
            currentLong=String.valueOf(gps.getLongitude());


            if (currentLat.equalsIgnoreCase("0.0")){

                currentLat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++++",currentLat);

            }
            else{

            }

            if (currentLong.equalsIgnoreCase("0.0")){


                currentLong = preferences.getString("currentLONGITUDE","");

                Log.e("+++++++",currentLong);
                ;

            }
            else{

                Log.e("+++++++",currentLong);
            }





        }catch (Exception e){
            e.printStackTrace();

        }

        try{
            if (isNetworkAvailable(context)) {

                date = get_current_date();
                time = get_current_time();
                datetime1=date+time;
                speed = GlobalConstants.SPEED;
//                if (msgType!=""){
//                    messageType1=msgType;
//                }
//                if (statusType!=""){
//                    status1=statusType;
//                }
                if (posdatatime.equalsIgnoreCase("")){
                    posdatatime=date+time;
                }


                if (fcmstatus.equalsIgnoreCase("0")){
                    Log.e("ENTER SIGNAL NOT ALLOWED","====");

                }else {

                    if (number1.equalsIgnoreCase("0")){

                    }
                    else {

                        if (currentLat.equalsIgnoreCase("0")) {
                            Log.e("FAILED","SIGNAL");

                        } else {

                            if (fcmstatus.equalsIgnoreCase("0")) {
                                Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                            } else {
                                if (posdatatime.equalsIgnoreCase("")) {
                                    posdatatime = date + time;
                                }
                                Log.e("NFC SIGNAL STATUS",nfcStatus);
                                Log.e("NFC SIGNAL MESSAGE",nfcMsg);
                                signal_Send(date + time, imei1, number1, nfcMsg, currentLat, currentLong, date + time, postype, nfcStatus, interval, speed);

                            }
                        }
                    }


                }



            }
            else {

                date = get_current_date();
                time = get_current_time();
                datetime1=date+time;
                speed = GlobalConstants.SPEED;
//                if (msgType!=""){
//                    messageType1=msgType;
//                }
//                if (statusType!=""){
//                    status1=statusType;
//                    Log.e("NFC SIGNAL",statusType);
//                }

                if (posdatatime.equalsIgnoreCase("")){
                    posdatatime=date+time;
                }
                String phoneNumber= "07786200129";
                String messagechck= "PRT"+","+datetime1+","+imei1+","+number1+","+nfcMsg+","+ currentLat+","+ currentLong+"," +date + time+","+postype+","+nfcStatus+","+interval+","+speed;
                // md5(messagechck);
                String checksum =md5(messagechck);
                String messagesend = "PRT" + "," + date+time + "," + imei1 + "," + number1 + "," + nfcMsg + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + nfcStatus + "," + interval + "," + speed + "," + checksum;
                Log.e("UpdateNETOFF",messagesend);
                if (fcmstatus.equalsIgnoreCase("0")){
                    Log.e("ENTER SIGNAL NOT ALLOWED","====");

                }else {

                    Log.e("NFC SIGNAL",messagesend);

                    SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                }
            }
        }
        catch (Exception e){

        }
    }


    private static void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime,imei,number,messageType,lat,lng,posdatatime,postype,status,interval,speed);
        getSignalResponse(signal_ResponseCall);
    }
    //Signal API Response
    private static void getSignalResponse(final Call<SignalBeans> signalResp) {
        // showProgressDialog(RedAlertActivate.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();
                    Log.e("NFCll", status);

                    if (status.equalsIgnoreCase("1")) {
                        SharedPreferences.Editor editor1 = preferences.edit();
                        editor1.remove("msgtype");
                        editor1.remove("statustype");
                        editor1.apply();


                    }
                    else{
                    }
                }
                else {
                    Log.e("In condition", "Failed");
                }

            }
            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }
    public static boolean isNetworkAvailable(Context context) {

        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    //==============get curent time =========================//
    public static String get_current_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    public static String get_locationcurrent_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Location" +
                "Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    //==============get curent date =========================//
    public static String get_current_date() {
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String formattedDate = df.format(c.getTime());

        return formattedDate;
    }

    public static final String md5(final String s) {
        final String MD5 = "MD5";
        try {
            // Create MD5 Hash
            MessageDigest digest = MessageDigest
                    .getInstance(MD5);
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();

            // Create Hex String
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2)
                    h = "0" + h;
                hexString.append(h);

            }
            Log.e("CheckSum", hexString.toString());
            return hexString.toString();


        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

//    static class ConnectTask extends AsyncTask<String, String, TcpClient> {
//
//        @Override
//        protected TcpClient doInBackground(String... message) {
//
//            //we create a TCPClient object and
//            mTcpClient = new TcpClient(new TcpClient.OnMessageReceived() {
//                @Override
//                //here the messageReceived method is implemented
//                public void messageReceived(String message) {
//                    //this method calls the onProgressUpdate
//                    publishProgress(message);
//                }
//            });
//            mTcpClient.run();
//
//            return null;
//        }
//
//        @Override
//        protected void onProgressUpdate(String... values) {
//            super.onProgressUpdate(values);
//
//
//        }
//    }



}
