package com.orbis.net;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;


/**
 * Created by admin on 9/9/17.
 */

public class LocationReceiver extends BroadcastReceiver {

    final int SDK_INT = Build.VERSION.SDK_INT;
    GPSTracker gps;
    SharedPreferences preferences;
    String lat = "", lng = "";
    double latt, lngg;
    String verifystatus="";

    @Override
    public void onReceive(Context ctx, Intent intent) {

        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {



            try {
                preferences = ctx.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
                verifystatus=preferences.getString("STATUS","");
                gps = new GPSTracker(ctx);
                lat = String.valueOf(gps.getLatitude());
                lng = String.valueOf(gps.getLongitude());
                Log.e("RECEIVER========", lat);
                Log.e("RECEIVER========", lng);

                if (lat.equalsIgnoreCase("0.0")) {

                    lat = preferences.getString("currentLATTITUDE", "");
                    latt = Double.parseDouble(lat);
                    Log.e("+++++++", lat);

                } else {

                    latt = gps.getLatitude();

                }

                if (lng.equalsIgnoreCase("0.0")) {

                    lng = preferences.getString("currentLONGITUDE", "");
                    Log.e("+++++++", lng);
                    lngg = Double.parseDouble(lng);

                } else {

                    lngg = gps.getLongitude();


                    Log.e("+++++++", lng);
                }


            } catch (Exception e) {
                e.printStackTrace();

            }
            try {

                if (verifystatus.equalsIgnoreCase("1")) {

                    SharedPreferences.Editor editor3 = preferences.edit();
                    editor3.putString("Triggerfrom", "PWON");
                    editor3.commit();

                    Log.e("ROOT TRIGGREED", "+++++++++++++++++");

                    TriggerSignal.sendTriggerSignal(ctx, "", "","");

                    PwonSignal.sendPWONSignal(ctx, "PWON");

                    Update_locationCall.sendUpdateSignal(ctx, latt, lngg);


                    Log.e("==========", "Boot Alarms");
                    AlarmManager alarmMgr = (AlarmManager) ctx.getSystemService(Context.ALARM_SERVICE);
                    Intent intent1 = new Intent(ctx, UpdateLocationIntentService.class);
                    PendingIntent alarmIntent = PendingIntent.getService(ctx, 0, intent1, 0);
                    int interval = 1000 * 60 * 15;


                    if (SDK_INT < Build.VERSION_CODES.KITKAT) {
                        alarmMgr.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, alarmIntent);
                        Log.d("lowerFB", "hahah");
                    } else if (Build.VERSION_CODES.KITKAT <= SDK_INT && SDK_INT < Build.VERSION_CODES.M) {
                        alarmMgr.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, alarmIntent);
                        Log.d("kitkatFB", "hahah");
                    } else if (SDK_INT >= Build.VERSION_CODES.M) {
                        alarmMgr.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, alarmIntent);
                        Log.d("marshmallowFB", "hahah");
                    }
                }
                else{
                    Log.e("====================","Not Login");
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }
}