package com.orbis.Util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.orbis.R;

public class Utility {

    // Method To Jump One Screen To Another..
    public final static void moveToNextActivity(final Context context, final Class<?> destination) {
        final Intent intent = new Intent(context, destination);
        context.startActivity(intent);
        ((Activity) context).finish();
    }


    // Method For Hyperlink Text...
    public final static SpannableString text_Link(String text) {
        SpannableString content = new SpannableString(text);
        content.setSpan(new UnderlineSpan(), 0, text.length(), 0);
        return content;
    }

    //status bar color....
    public final static void status_bar_color_change(Activity context) {
        if (android.os.Build.VERSION.SDK_INT >= 21) {
            Window window = context.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(context.getResources().getColor(R.color.status_bar_color));
        }

    }

    //helvetica neue light font
    public final static void text_font_helvetica(Activity activity, TextView text) {
        //helvetica neue light font
        Typeface typeface;
        typeface = Typeface.createFromAsset(activity.getAssets(), "fonts/helvetica-neue-light.ttf");
        text.setTypeface(typeface);
    }

    public static void alertDialog(Context context, String message) {
        AlertDialog.Builder builder;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            builder = new AlertDialog.Builder(context, android.R.style.Theme_Material_Dialog_Alert);
        } else {
            builder = new AlertDialog.Builder(context);
        }
        builder.setTitle("Orbis")
                .setMessage(message)
                .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                        // continue with delete
                        dialog.dismiss();
                    }
                })
                .setIcon(android.R.drawable.ic_dialog_alert)
                .show();
    }
}
