package com.orbis.Util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;

/**
 * Created by theappguruz on 07/05/16.
 */
public class PhoneStateReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {

        try {
            System.out.println("Receiver start");
            SharedPreferences preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
            String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
            String incomingNumber = intent.getStringExtra(TelephonyManager.EXTRA_INCOMING_NUMBER);

            if(state.equals(TelephonyManager.EXTRA_STATE_RINGING)){
                Log.e("Incoming Call State","????");
                SOSBroadcastReceiver.triggerInProgress=true;

                //Toast.makeText(context,"Incoming Call State",Toast.LENGTH_SHORT).show();
             //   Toast.makeText(context,"Ringing State Number is -"+incomingNumber,Toast.LENGTH_SHORT).show();

                }
            if ((state.equals(TelephonyManager.EXTRA_STATE_OFFHOOK))){
                SOSBroadcastReceiver.triggerInProgress=true;
                Log.e("Call Received State","????");
              //  Toast.makeText(context,"Call Received State",Toast.LENGTH_SHORT).show();


                SharedPreferences.Editor editorr = preferences.edit();
                editorr.putString("receivedstate", "1");
                editorr.commit();


            }
            if (state.equals(TelephonyManager.EXTRA_STATE_IDLE)){
                Log.e("Call Idle State","????");
                SOSBroadcastReceiver.triggerInProgress=false;

                try {
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("receivedstate");
                    editor.apply();
                }
                catch(Exception e){
                    e.printStackTrace();
                }
              //  Toast.makeText(context,"Call Idle State",Toast.LENGTH_SHORT).show();


            }
        }
        catch (Exception e){
            e.printStackTrace();
        }

    }
}


