package com.orbis.Util;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;

import java.util.Random;


public class NoMovementService extends Service implements SensorEventListener {

    private SensorManager mSensorManager;
    private Sensor mAccelerometer;

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
        mAccelerometer = mSensorManager
                .getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        mSensorManager.registerListener(this, mAccelerometer,
                SensorManager.SENSOR_DELAY_UI, new Handler());
        return START_STICKY;
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        Log.e("Accuracy", "ACCURACY");

    }

    @Override
    public void onSensorChanged(SensorEvent event) {

        if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
            //get x, y, z values
            float value[] = event.values;
            float x = value[0];
            float y = value[1];
            float z = value[2];
            //use the following formula
            //use gravity according to your place if you are on moon than use moon gravity
            float asr = (x * x + y * y + z * z) / (SensorManager.GRAVITY_EARTH *
                    SensorManager.GRAVITY_EARTH);
            //If mobile move any direction then the following condition will become true
            if (asr >= 2) {
                //Generate random number every time and display on text view
                Random r = new Random();
                int i = r.nextInt(10);
                Log.e("X-NOMOVEMENTS", String.valueOf(i));
                Intent newIntent = new Intent();
                newIntent.setAction("nomovement");
                sendBroadcast(newIntent);
                //showNotification();

                //tv.setText(""+i);
            }
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        // Toast.makeText(this, "Movement Servive stoped", Toast.LENGTH_LONG).show();
        mSensorManager.unregisterListener(this);
    }


}
