package com.orbis.Util;

import android.os.CountDownTimer;
import android.util.Log;

import java.util.concurrent.TimeUnit;


public class FallDetectCounter extends CountDownTimer {

    private static String fhms;
    private static FallDetectCounter instance;
    private static long fallremaining;

    private FallDetectCounter(long millisInFuture, long countDownInterval) {
        super(millisInFuture, countDownInterval);
        Log.e("FALLDETECTCOUNTER","********");
    }


    public static FallDetectCounter initInstance(long millisInFuture, long countDownInterval) {
        instance = null;
        Log.e("initInstanceOUT","********");
        if (instance == null) {
            instance = new FallDetectCounter(millisInFuture, countDownInterval);
            Log.e("initInstance IN","********");
        }
        return instance;
    }

    public static FallDetectCounter extendinitInstance(long millisInFuture, long countDownInterval) {
        instance = null;
        Log.e("extendinitInstance OUT","********");
        if (instance == null) {
            instance = new FallDetectCounter(millisInFuture, countDownInterval);
            Log.e("extendinitInstance IN","********");
        }
        return instance;
    }


    public static FallDetectCounter getInstance() throws Exception {
        if (instance == null) {

            throw new Exception("Parameters not initialized. Initiate with initInstance");
        } else {
            return instance;
        }
    }

    public void clear() {
        if (instance != null) {
            instance = null;
            Log.e("clear OUT","********");
        }
    }


    public static String getFallFormatedTime() {
        return fhms;
    }
    public static void setFallFormatedTime() {

        fhms = null;
        fallremaining = 0;
    }

    @Override
    public void onTick(long fl) {
        fallremaining = fl;

        fhms = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(fallremaining), TimeUnit.MILLISECONDS.toMinutes(fallremaining) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(fallremaining)), TimeUnit.MILLISECONDS.toSeconds(fallremaining) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(fallremaining)));

    }

    @Override

    public void onFinish() {
        fallremaining = 0;
        fhms = null;
    }
}