package com.orbis.Util;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.util.Log;

/**
 * Created by nancy on 15/9/17.
 */

public class AmberService extends Service {

    private SensorManager mSensorManager;
    private Sensor mAccelerometer;
    private float mAccel; // acceleration apart from gravity
    private float mAccelCurrent; // current acceleration including gravity
    private float mAccelLast; // last acceleration including gravity
    Intent callIntent;
    PowerManager.WakeLock wl;
    private int lastInteractionTime;
    private Boolean isScreenOff = false;
    public final static int INTERVAL = 10000;
    boolean isInForeGrnd;
    static Handler mHandler;

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }


    @Override
    public void onCreate() {
        super.onCreate();
        Log.e("********", "onCreate()");
        PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
        wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK | PowerManager.ON_AFTER_RELEASE, "Screen OFF");
        Notification notification = new Notification();
        startForeground(12, notification);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        mHandler = LocationHandler.getMainLocationInstance();

        PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
        wl = pm.newWakeLock(PowerManager.FULL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, "Screen OFF");

        startRepeatingTask();


        return START_STICKY;
    }

    Runnable mHandlerTask = new Runnable() {
        @Override
        public void run() {

            try {

                if (isScreenOff || getLastInteractionTime() > INTERVAL || !isInForeGrnd) {

                    Log.e("*******", ")))))))");
                    wl.release();
                    wl.acquire();
                    wl.release();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            mHandler.postDelayed(mHandlerTask, 5000);

        }
    };

    void startRepeatingTask() {
        mHandlerTask.run();
    }

    void stopRepeatingTask() {

        try {
            wl.release();
            mHandler = LocationHandler.getMainLocationInstance();

            mHandler.removeCallbacks(mHandlerTask);
            LocationHandler.clearInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        stopRepeatingTask();

    }

    public long getLastInteractionTime() {
        return lastInteractionTime;
    }

    public long setLastInteractionTime(int lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
        return lastInteractionTime;
    }
}