package com.orbis.Util;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;


/**
 * Created by nancy on 15/9/17.
 */

public class AmberIntentService extends IntentService {

    Context context;
    PowerManager.WakeLock wl;
    static Handler mHandler;
    private int lastInteractionTime;
    private Boolean isScreenOff = false;
    public final static int INTERVAL = 40000;
    boolean isInForeGrnd;

    public AmberIntentService() {
        super("");
    }

    @Override
    protected void onHandleIntent(Intent intent) {

        PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
        wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.ON_AFTER_RELEASE, "Screen OFF");

        Log.e("=========", "AmberIntent");
        sendDATA();

    }

    private void sendDATA() {
        try {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(10000); // checks every 15sec for inactivity

                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                        if (isScreenOff || getLastInteractionTime() > INTERVAL || !isInForeGrnd) {

                            wl.acquire();

                            if ((wl != null) && (wl.isHeld())) {
                                wl.release();
                            }
                        }
                    }
                }
            }).start();
        } catch (Exception e) {
        }
    }

    public long getLastInteractionTime() {
        return lastInteractionTime;
    }

    public long setLastInteractionTime(int lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
        return lastInteractionTime;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            if (wl != null)
                wl.release();

            wl = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}