package com.orbis.Adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.util.Log;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.orbis.Activity.EscalationScreen;
import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.EscalationDetailDataBeans;
import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.interfaces.ItemTouchHelperAdapter;
import com.orbis.interfaces.ItemTouchHelperViewHolder;
import com.orbis.interfaces.OnStartDragListener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by Admin on 0016,16,April,2018.
 */

public class RecyclerListAdapter extends RecyclerView.Adapter<RecyclerListAdapter.ItemViewHolder>
        implements ItemTouchHelperAdapter {

    private final List<String> mItems = new ArrayList<>();
    private final List<String> mItems_number = new ArrayList<>();
    SharedPreferences preferences;
    private final OnStartDragListener mDragStartListener;
    Context context;
    public static CardView item_layout;
    public static int newPosition;
    int selectedPosition = -1;
    String value;
    public List<EscalationDetailDataBeans> detailList;
    boolean touch = false;
    EscalationScreen activity;


    public RecyclerListAdapter(Context context, List<EscalationDetailDataBeans> detailList, OnStartDragListener dragStartListener, String value, EscalationScreen activity) {
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        mDragStartListener = dragStartListener;
        mItems.addAll(Arrays.asList(context.getResources().getStringArray(R.array.dummy_items)));
        mItems_number.addAll(Arrays.asList(context.getResources().getStringArray(R.array.dummy_number)));
        this.context = context;
        this.value = value;
        this.activity = activity;
        this.detailList = detailList;
    }

    @Override
    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.model_list_row, parent, false);
        ItemViewHolder itemViewHolder = new ItemViewHolder(view);
        return itemViewHolder;
    }

    @Override
    public void onBindViewHolder(final ItemViewHolder holder, final int position) {


        newPosition = position;
        int tile = position;
        EscalationDetailDataBeans escalationDetailDataBeans = detailList.get(position);
        holder.tvPosition.setText("" + (tile + 1) + " |");

        holder.textView.setText(Html.fromHtml(escalationDetailDataBeans.getFULLNAME()));
        holder.tv_number.setText(Html.fromHtml(escalationDetailDataBeans.getMOBILE()));

        holder.ll_escalation.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View view) {
                mDragStartListener.onStartDrag(holder);
                return false;
            }
        });
//        holder.ll_escalation.setOnTouchListener(new View.OnTouchListener() {
//            @Override
//            public boolean onTouch(View v, MotionEvent event) {
//                if (MotionEventCompat.getActionMasked(event) == MotionEvent.ACTION_DOWN) {
//                    Log.e("*****POSITION**", String.valueOf(position));
//                    touch = true;
//                    mDragStartListener.onStartDrag(holder);
//                }
//
//                return false;
//            }
//        });

        holder.ll_escalation.setOnDragListener(new View.OnDragListener() {
            @Override
            public boolean onDrag(View view, DragEvent dragEvent) {
                Log.e("onDrag", "onDrag");
                return false;
            }
        });
    }

    @Override
    public void onItemDismiss(int position) {
        detailList.remove(position);
        notifyItemRemoved(position);
    }

    @Override
    public boolean onItemMove(int fromPosition, int toPosition) {
        Collections.swap(detailList, fromPosition, toPosition);
        notifyItemMoved(fromPosition, toPosition);
        return true;
    }

    @Override
    public int getItemCount() {
        return detailList.size();
    }

    public class ItemViewHolder extends RecyclerView.ViewHolder implements
            ItemTouchHelperViewHolder {

        public TextView textView, tv_number, tvPosition;
        public ImageView iv_EditEscalation, iv_DeleteEscalation;
        public final LinearLayout ll_escalation;
        public RelativeLayout rl_mainList;
        public CardView item_layout;

        public ItemViewHolder(View itemView) {
            super(itemView);
            textView = (TextView) itemView.findViewById(R.id.title);
            tv_number = (TextView) itemView.findViewById(R.id.tv_number);
            tvPosition = (TextView) itemView.findViewById(R.id.tvPosition);
            iv_EditEscalation = (ImageView) itemView.findViewById(R.id.iv_EditEscalation);
            iv_DeleteEscalation = (ImageView) itemView.findViewById(R.id.iv_DeleteEscalation);
            item_layout = (CardView) itemView.findViewById(R.id.item_layout);
            ll_escalation = (LinearLayout) itemView.findViewById(R.id.ll_escalation);
            rl_mainList = (RelativeLayout) itemView.findViewById(R.id.rl_mainList);
            iv_EditEscalation.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    activity.edit(getAdapterPosition());
                }
            });
            iv_DeleteEscalation.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    AlertDialog.Builder builder;
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        builder = new AlertDialog.Builder(context, android.R.style.Theme_Material_Dialog_Alert);
                    } else {
                        builder = new AlertDialog.Builder(context);
                    }
                    builder.setTitle("Alert")
                            .setMessage("Do you really want to delete.")
                            .setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int which) {
                                    // continue with delete
                                    Utility.alertDialog(context, "Escalation Details updates take up to 24 hours to be completed.");
                                    activity.delete(getAdapterPosition());
                                    dialog.dismiss();
                                }
                            }).setNegativeButton(android.R.string.no, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int i) {
                            dialog.dismiss();
                        }
                    })
                            .setIcon(android.R.drawable.ic_dialog_alert)
                            .show();

                }
            });
        }

        @Override
        public void onItemSelected() {
            //  if (touch) {
            Log.e("******POSition___", String.valueOf(newPosition));
            item_layout.setRotation(-8);

        }

        @Override
        public void onItemClear() {
            touch = false;
            item_layout.setRotation(0);

            notifyDataSetChanged();

        }
    }
}