package com.orbis.Activity;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.StrictMode;
import android.os.Vibrator;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.orbis.Model.SignalBeans;
import com.orbis.R;
import com.orbis.net.GPSTracker;
import com.orbis.net.TriggerSignal;
import com.orbis.net.WebRequest;
import com.skyfishjy.library.RippleBackground;
import com.skyfishjy.library.RippleBackground1;

import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class RedAlertActivate extends OrbisActivity implements View.OnClickListener {

    RelativeLayout rl_deactive_button, rl_main, rl_main_alert;
    ImageView iv_back;
    Button btn_red_alert;
    Vibrator vibrator;
    Handler handel = new Handler();
    Handler handel1 = new Handler();
    RippleBackground rippleBackground;
    RippleBackground1 rippleBackground1;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    String datetime, imei, number, messageType, lat, lng, posdatatime, postype, status = "", interval, speed;
    WebRequest mWebrequest;
    TelephonyManager tManager;
    Intent callIntent;
    String date, time;
    View myLayout;
    ImageView iv_alert1;
    String checksum = "";
    String prt = "PRT";
    String amber_hour = "", amber_min = "";
    String messagesend = "", messagechck = "", redAlertStatus = "";
    String value = "";
    String triggerFrom = "";
    String verifystatus = "";
    String fcmstatus = "", fcmmessage = "", redalertNumber = "", phoneNumber = "";
    GPSTracker gps;
    String msgType = "", statusType = "";
    String msg = "";
    private long startClickTime;
    boolean longClickActive = false;
    private long startClickTime1;
    boolean longClickActive1 = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_red_alert_activate);

        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder()
                .permitAll().build();
        StrictMode.setThreadPolicy(policy);

        //changing statusbar color
        status_bar();

        //find view by id
        intialize_ID();

        mWebrequest = WebRequest.getSingleton(RedAlertActivate.this);
        date = get_current_date();
        time = get_current_time();
        try {

            tManager = (TelephonyManager) getBaseContext()
                    .getSystemService(Context.TELEPHONY_SERVICE);

            datetime = date + time;
            imei = tManager.getDeviceId();


            gps = new GPSTracker(RedAlertActivate.this);
            lat = String.valueOf(gps.getLatitude());
            lng = String.valueOf(gps.getLongitude());
            Log.e("RED ALERT LAT", lat);
            Log.e("RED ALERT Long", lng);
            if (lat.equalsIgnoreCase("0.0")) {
                lat = preferences.getString("currentLATTITUDE", "");
            } else {
                Log.e("*****", lat);
            }
            if (lng.equalsIgnoreCase("0.0")) {
                lng = preferences.getString("currentLONGITUDE", "");
            } else {
                Log.e("*****", lng);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        number = preferences.getString("number", "");
        messageType = "EMG";
        amber_hour = preferences.getString("AMBERTIME", "");
        amber_min = preferences.getString("AMBERTIME_min", "");
        posdatatime = date + time;
        //posdatatime = preferences.getString("posdatatime", "");
        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");
        redalertNumber = preferences.getString("redalertnumber", "");
        phoneNumber = preferences.getString("redalertsmsnumber", "");
        triggerFrom = preferences.getString("Triggerfrom", "");
        msgType = preferences.getString("msgtype", "");
        statusType = preferences.getString("statustype", "");

        if (triggerFrom != "") {
            TriggerSignal.sendTriggerSignal(RedAlertActivate.this, "", "", "");
        }
        if (phoneNumber.equalsIgnoreCase("")) {
            phoneNumber = "07786200129";
        }
        if (redalertNumber.equalsIgnoreCase("")) {
            redalertNumber = "01513432846";
        }
        postype = "GPS";
        interval = "";
        speed = GlobalConstants.SPEED;
        verifystatus = preferences.getString("STATUS", "");

/*

        if (status.equalsIgnoreCase("")) {
            status = "Emergency";
        } else {
            status = preferences.getString("messageStatus", "");
        }


        Log.e("STATUS RED ALERT", status);*/
        messagechck = prt + "," + datetime + "," + imei + "," + number + "," + messageType + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed;
        checksum = md5(messagechck);
        speed = GlobalConstants.SPEED;
        messagesend = prt + "," + datetime + "," + imei + "," + number + "," + messageType + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;


        Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.cancel();

        if (fcmstatus.equalsIgnoreCase("0")) {
            Log.e("ENTER SIGNAL NOT ALLOWED", "====");


        } else {

            callIntent = new Intent(Intent.ACTION_CALL);
            callIntent.setData(Uri.parse("tel:" + redalertNumber));
            //callIntent.setData(Uri.parse("tel:01513432846"));
            startActivity(callIntent);
        }

        //shared prefrence redalert
        redAlertStatus = preferences.getString("redalert", "");
        if (redAlertStatus.equalsIgnoreCase("2")) {

            if (isNetworkAvailable()) {
                value = "redstart";
                date = get_current_date();
                time = get_current_time();
                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");
                    showBuilder(RedAlertActivate.this, "Request Failed", "Your data requests are restricted. Please contact HS2");

                } else {

                    if (msgType != "") {
                        msg = msgType;
                    } else {
                        msg = "EMG";
                    }

                    if (statusType != "") {
                        status = statusType;
                    }
                    if (posdatatime.equalsIgnoreCase("")) {
                        posdatatime = date + time;
                    }
                    speed = GlobalConstants.SPEED;
                    signal_Send(date + time, imei, number, msg, lat, lng, date + time, postype, status, interval, speed);


                }

            } else {
                value = "redstart";
                date = get_current_date();
                time = get_current_time();
                showLog(messagesend);
                if (msgType != "") {
                    msg = msgType;
                } else {
                    msg = "EMG";
                }

                if (statusType != "") {
                    status = statusType;
                }

                if (posdatatime.equalsIgnoreCase("")) {
                    posdatatime = date + time;
                }
                speed = GlobalConstants.SPEED;

                messagesend = prt + "," + date + time + "," + imei + "," + number + "," + msg + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;
                Log.e("messagesend", messagesend);

                if (fcmstatus.equalsIgnoreCase("0")) {

                    showBuilder(RedAlertActivate.this, "Request Failed", "Your data requests are restricted. Please contact HS2");


                } else {

                    SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                }
            }
        } else {
            Toast.makeText(RedAlertActivate.this, "Network issue", Toast.LENGTH_SHORT).show();
        }


    }

    /***
     * Start Vibrate
     */
    private void startVibrate() {

        Log.e("START", ">>>>>>");

        long pattern[] = {0, 250, 350, 450, 550, 650};
        //long pattern[]={0,100,250,125,900,100,250,125};
        vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.vibrate(pattern, 0);
    }

    public void stopVibrate()

    {
        vibrator.cancel();
    }

    private void status_bar() {
        //status bar color....
        if (android.os.Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(this.getResources().getColor(R.color.color_red_alert
            ));
        }
    }

    private void intialize_ID() {
        myLayout = findViewById(R.id.tabmain);
        iv_alert1 = (ImageView) myLayout.findViewById(R.id.iv_alert1);
        rl_main = (RelativeLayout) findViewById(R.id.rl_main);
        rippleBackground = (RippleBackground) findViewById(R.id.content);
        rippleBackground1 = (RippleBackground1) findViewById(R.id.content1);
        rl_deactive_button = (RelativeLayout) findViewById(R.id.rl_deactive_button);
        rippleBackground.startRippleAnimation();
        btn_red_alert = (Button) findViewById(R.id.btn_red_alert);
        rl_main_alert = (RelativeLayout) findViewById(R.id.rl_main_alert);
        rl_main_alert.setOnTouchListener(speakTouchListener1);
        btn_red_alert.setOnTouchListener(speakTouchListener);
        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
        rippleBackground1.startRippleAnimation();
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                //onBackPressed();
                break;
            default:
        }
    }

    private View.OnTouchListener speakTouchListener = new View.OnTouchListener() {

        @Override
        public boolean onTouch(View pView, MotionEvent event) {
            switch (event.getAction()) {
              /*  case MotionEvent.ACTION_DOWN:
                    handel.postDelayed(run, 3000*//* OR the amount of time you want *//*);
                    break;*/
                case MotionEvent.ACTION_DOWN:
                    if (longClickActive == false) {
                        longClickActive = true;
                        Log.e("ACTION_DOWN", "============");

                        startClickTime = Calendar.getInstance().getTimeInMillis();
                        rippleBackground1.startRippleAnimation();
                        rippleBackground1.setVisibility(View.VISIBLE);
                        rippleBackground.setVisibility(View.GONE);
                        handel1.postDelayed(run1, 2000);
                    }
                    break;
                // new condition added
                case MotionEvent.ACTION_UP:
                    Log.e("ACTION UP", "============");
                    longClickActive = false;
                    rippleBackground.setVisibility(View.VISIBLE);
                    rippleBackground1.setVisibility(View.GONE);
                    rippleBackground.startRippleAnimation();
                    handel.removeCallbacksAndMessages(null);
                    break;
                case MotionEvent.ACTION_POINTER_DOWN:

                    break;
                case MotionEvent.ACTION_POINTER_UP:

                    break;
                case MotionEvent.ACTION_MOVE:
                    if (longClickActive == true) {

                        long clickDuration = Calendar.getInstance().getTimeInMillis() - startClickTime;
                        if (clickDuration >= 1000) {
                            longClickActive1 = false;
                            Log.e("ACTION INSIDE MOVE1", "=============");

                        }
                    }
                    break;


            }
            return true;

        }
    };

    private void changeAnimation() {


    }

    Runnable run = new Runnable() {
        @Override
        public void run() {
            vibrator.cancel();
            if (msgType != "") {
                SharedPreferences.Editor editor1 = preferences.edit();
                editor1.putString("Triggerfrom", "TAGUC");
                editor1.commit();

            } else {
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("Triggerfrom", "EMGUC");
                editor.commit();
            }
            TriggerSignal.sendTriggerSignal(RedAlertActivate.this, "", "", "");
            // Your code to run on long click after 3 seconds.....
            if (isNetworkAvailable()) {
                value = "redcancel";
                date = get_current_date();
                time = get_current_time();
                if (fcmstatus.equalsIgnoreCase("0")) {


                } else {


                    if (msgType != "") {
                        msg = msgType;
                    } else {
                        msg = "EMGUC";
                    }

                    if (statusType != "") {
                        status = statusType;
                    }

                    if (posdatatime.equalsIgnoreCase("")) {
                        posdatatime = date + time;
                    }
                    speed = GlobalConstants.SPEED;
                    signal_Send(date + time, imei, number, msg, lat, lng, date + time, postype, status, interval, speed);
                }

                String data = datetime + imei + number + messageType + lat + lng + date + time + postype + status + interval + speed;
                Log.e("REDALERTTTTTFINAL SIGNAL", data);

            } else {
                value = "redcancel";
                date = get_current_date();
                time = get_current_time();
                if (msgType != "") {
                    msg = msgType;
                } else {
                    msg = "EMGUC";
                }

                if (statusType != "") {
                    status = statusType;
                }
                showLog(messagesend);
                if (posdatatime.equalsIgnoreCase("")) {
                    posdatatime = date + time;
                }
                messagesend = prt + "," + date + time + "," + imei + "," + number + "," + msg + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;

                if (fcmstatus.equalsIgnoreCase("0")) {


                } else {

                    SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                }
            }
            //showToast("Red Alert Deactivated");

            SharedPreferences.Editor editorr = preferences.edit();
            editorr.putString("redalert", "2");
            editorr.commit();

            Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
            vibrator.cancel();
            if (verifystatus.equalsIgnoreCase("1")) {

                SharedPreferences.Editor editor1 = preferences.edit();
                editor1.remove("msgtype");
                editor1.remove("statustype");
                editor1.apply();

                Intent intent = new Intent(RedAlertActivate.this, TabHostActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();
            } else {
                Intent intent = new Intent(RedAlertActivate.this, LoginScreen.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();


            }
        }
    };
    private View.OnTouchListener speakTouchListener1 = new View.OnTouchListener() {

        @Override
        public boolean onTouch(View pView, MotionEvent event) {
            switch (event.getAction()) {
              /*  case MotionEvent.ACTION_DOWN:
                    handel.postDelayed(run, 3000*//* OR the amount of time you want *//*);
                    break;*/
                case MotionEvent.ACTION_DOWN:
                    if (longClickActive == false) {
                        longClickActive = true;
                        Log.e("ACTION_DOWN", "============");

                        startClickTime = Calendar.getInstance().getTimeInMillis();
                        rippleBackground1.startRippleAnimation();
                        rippleBackground1.setVisibility(View.VISIBLE);
                        rippleBackground.setVisibility(View.GONE);
                        handel1.postDelayed(run1, 2000);
                    }
                    break;
                // new condition added
                case MotionEvent.ACTION_UP:
                    Log.e("ACTION UP", "============");
                    longClickActive = false;
                    rippleBackground.setVisibility(View.VISIBLE);
                    rippleBackground1.setVisibility(View.GONE);
                    rippleBackground.startRippleAnimation();
                    handel.removeCallbacksAndMessages(null);
                    break;
                case MotionEvent.ACTION_POINTER_DOWN:

                    break;
                case MotionEvent.ACTION_POINTER_UP:

                    break;
                case MotionEvent.ACTION_MOVE:
                    if (longClickActive == true) {

                        long clickDuration = Calendar.getInstance().getTimeInMillis() - startClickTime;
                        if (clickDuration >= 1000) {
                            longClickActive1 = false;
                            Log.e("ACTION INSIDE MOVE1", "=============");

                        }
                    }
                    break;
            }
            return true;
        }
    };


    Runnable run1 = new Runnable() {
        @Override
        public void run() {


            if (msgType != "") {
                SharedPreferences.Editor editor1 = preferences.edit();
                editor1.putString("Triggerfrom", "TAGUC");
                editor1.commit();

            } else {
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("Triggerfrom", "EMGUC");
                editor.commit();
            }
            // Your code to run on long click after 3 seconds.....

            TriggerSignal.sendTriggerSignal(RedAlertActivate.this, "", "", "");
            if (isNetworkAvailable()) {
                value = "redcancel";
                date = get_current_date();
                time = get_current_time();
                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                } else {
                    if (msgType != "") {
                        msg = msgType;
                    } else {
                        msg = "EMGUC";
                    }

                    if (statusType != "") {
                        status = statusType;
                    }


                    if (posdatatime.equalsIgnoreCase("")) {
                        posdatatime = date + time;
                    }

                    signal_Send(date + time, imei, number, msg, lat, lng, date + time, postype, status, interval, speed);
                }

            } else {
                date = get_current_date();
                time = get_current_time();
                value = "redcancel";
                showLog(messagesend);
                if (msgType != "") {
                    msg = msgType;
                } else {
                    msg = "EMGUC";
                }

                if (statusType != "") {
                    status = statusType;
                }
                if (posdatatime.equalsIgnoreCase("")) {
                    posdatatime = date + time;
                }
                speed = GlobalConstants.SPEED;
                messagesend = prt + "," + date + time + "," + imei + "," + number + "," + msg + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;
                Log.e("messagesend", messagesend);
                if (fcmstatus.equalsIgnoreCase("0")) {
                    Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                } else {
                    SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                }
            }
            //showToast("Red Alert Deactivated");
            rippleBackground.stopRippleAnimation();

            SharedPreferences.Editor editorr = preferences.edit();
            editorr.putString("redalert", "2");
            editorr.commit();

            Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
            vibrator.cancel();

            if (verifystatus.equalsIgnoreCase("1")) {


                SharedPreferences.Editor editor1 = preferences.edit();
                editor1.remove("msgtype");
                editor1.remove("statustype");
                editor1.apply();
                Intent intent = new Intent(RedAlertActivate.this, TabHostActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();
            } else {
                Intent intent = new Intent(RedAlertActivate.this, LoginScreen.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();


            }


        }


    };

    @Override
    public void onBackPressed() {
        super.onBackPressed();

        Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.cancel();

    }

    private void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private void getSignalResponse(final Call<SignalBeans> signalResp) {
        // showProgressDialog(RedAlertActivate.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();
                    Log.e("ll", status);

                    if (status.equalsIgnoreCase("1")) {

                        if (value.equalsIgnoreCase("redcancel")) {

                            String message = response.body().getMessage().toString();
                            vibrator.cancel();
                            SharedPreferences.Editor editorr = preferences.edit();
                            editorr.putString("redalert", "1");
                            editorr.commit();


                        } else if (value.equalsIgnoreCase("redstart")) {

                            String message = response.body().getMessage().toString();
                            SharedPreferences.Editor editorr = preferences.edit();
                            editorr.putString("redalert", "1");
                            editorr.commit();

                        } else {
                        }
                    } else {
                        Log.e("In condition", "Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }


    @Override
    protected void onResume() {
        super.onResume();
        startVibrate();

    }

    @Override
    protected void onStop() {
        super.onStop();
        Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.cancel();   // or cancel here
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.cancel();
        // or cancel here
        //this.finish();
    }


    @Override
    protected void onPause() {
        super.onPause();
        Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        vibrator.cancel();

    }
}
